/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.web.dto.DeviceApplicationRestRequest;
import org.waterforpeople.mapping.app.web.dto.DeviceApplicationRestResponse;
import org.waterforpeople.mapping.dao.DeviceApplicationDao;
import org.waterforpeople.mapping.domain.DeviceApplication;

public class DeviceApplicationRestService
extends AbstractRestApiServlet {
    private static final long serialVersionUID = -830140106880504436L;
    private DeviceApplicationDao devAppDao;

    public DeviceApplicationRestService() {
        this.setMode("JSON");
        this.devAppDao = new DeviceApplicationDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DeviceApplicationRestRequest restRequest = new DeviceApplicationRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DeviceApplicationRestRequest daReq;
        List<DeviceApplication> devAppList;
        DeviceApplicationRestResponse resp = new DeviceApplicationRestResponse();
        Properties props = System.getProperties();
        String autoUpdateApk = props.getProperty("autoUpdateApk");
        if ("getLatestVersion".equalsIgnoreCase(req.getAction()) && autoUpdateApk != null && autoUpdateApk.equalsIgnoreCase("true") && (devAppList = this.devAppDao.listByDeviceTypeAndAppCode((daReq = (DeviceApplicationRestRequest)req).getDeviceType(), daReq.getAppCode(), 1)) != null && devAppList.size() > 0) {
            resp.setVersion(devAppList.get(0).getVersion());
            resp.setFileName(devAppList.get(0).getFileName());
            resp.setMd5Checksum(devAppList.get(0).getMd5Checksum());
        }
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        this.getResponse().getWriter().println(new JSONObject((Object)resp).toString());
    }
}

