/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.surveyal.dao.SurveyedLocaleClusterDao;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.gallatinsystems.surveyal.domain.SurveyedLocaleCluster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.dto.PlacemarkDto;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;

@Controller
@RequestMapping(value={"/placemarks"})
public class PlacemarkRestService {
    final int LIMIT_PLACEMARK_POINTS = 2000;
    private static final Logger log = Logger.getLogger(PlacemarkRestService.class.getName());
    private SurveyedLocaleDao localeDao = new SurveyedLocaleDao();
    private SurveyedLocaleClusterDao slcDao = new SurveyedLocaleClusterDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listPlaceMarks(@RequestParam(value="bbString", defaultValue="") String boundingBoxString, @RequestParam(value="gcLevel", defaultValue="") Integer gcLevel) {
        Collection auths;
        Boolean allPlacemarks = false;
        log.log(Level.FINE, "received request for: " + boundingBoxString + ", " + gcLevel);
        List<String> geocells = Arrays.asList(boundingBoxString.split(","));
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && ((auths = authentication.getAuthorities()).contains((Object)AppRole.USER) || auths.contains((Object)AppRole.ADMIN) || auths.contains((Object)AppRole.SUPER_ADMIN))) {
            allPlacemarks = true;
        }
        return this.getPlacemarksReponse(geocells, gcLevel, allPlacemarks);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> placeMarkDetails(@PathVariable(value="id") Long id) {
        return this.getPlacemarkResponseById(id);
    }

    private Map<String, Object> getPlacemarksReponse(List<String> geocells, Integer gcLevel, Boolean allPlacemarks) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<PlacemarkDto> result = new ArrayList<PlacemarkDto>();
        if (gcLevel > 0) {
            List<SurveyedLocaleCluster> slcList = allPlacemarks != false ? this.slcDao.listLocaleClustersByGeocell(geocells, gcLevel) : this.slcDao.listPublicLocaleClustersByGeocell(geocells, gcLevel);
            if (slcList.size() > 0) {
                for (SurveyedLocaleCluster slc : slcList) {
                    result.add(this.marshallClusterDomainToDto(slc));
                }
            }
        } else {
            ArrayList<SurveyedLocale> slList = new ArrayList<SurveyedLocale>();
            if (allPlacemarks.booleanValue()) {
                slList.addAll(this.localeDao.listLocalesByGeocell(geocells, 2000));
            } else {
                slList.addAll(this.localeDao.listPublicLocalesByGeocell(geocells, 2000));
            }
            if (slList.size() > 0) {
                for (SurveyedLocale sl : slList) {
                    result.add(this.marshallDomainToDto(sl));
                }
            }
        }
        response.put("placemarks", result);
        return response;
    }

    private Map<String, Object> getPlacemarkResponseById(Long id) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        SurveyedLocale sl = this.localeDao.getById(id);
        if (sl == null) {
            throw new HttpMessageNotReadableException("ID not found");
        }
        response.put("placemark", this.marshallDomainToDto(sl));
        return response;
    }

    private PlacemarkDto marshallDomainToDto(SurveyedLocale sl) {
        PlacemarkDto dto = new PlacemarkDto();
        dto.setLatitude(sl.getLatitude());
        dto.setLongitude(sl.getLongitude());
        dto.setCount(1);
        dto.setDetailsId(sl.getKey().getId());
        dto.setLevel(0);
        dto.setSurveyId(sl.getCreationSurveyId());
        dto.setCollectionDate(sl.getLastSurveyedDate());
        dto.setKeyId(sl.getKey().getId() * 2L);
        return dto;
    }

    private PlacemarkDto marshallClusterDomainToDto(SurveyedLocaleCluster slc) {
        PlacemarkDto dto = new PlacemarkDto();
        dto.setLatitude(slc.getLatCenter());
        dto.setLongitude(slc.getLonCenter());
        dto.setCount(slc.getCount());
        dto.setLevel(slc.getLevel());
        dto.setKeyId(slc.getKey().getId() * 2L + 1L);
        if (slc.getCount() == 1) {
            dto.setDetailsId(slc.getFirstSurveyedLocaleId());
            dto.setCollectionDate(slc.getFirstCollectionDate());
        }
        return dto;
    }
}

