/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.gis.map;

import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleClusterDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.gallatinsystems.surveyal.domain.SurveyedLocaleCluster;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsr107cache.Cache;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class MapUtils {
    private static final int MULT = 1000000;
    private static final double REVMULT = 1.0E-6;
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ALTITUDE = "height";

    public static void recomputeCluster(Cache cache, SurveyedLocale locale, int delta) {
        SurveyInstance si;
        SurveyedLocaleClusterDao slcDao = new SurveyedLocaleClusterDao();
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        SurveyDAO sDao = new SurveyDAO();
        Boolean showOnPublicMap = false;
        Long surveyId = null;
        if (locale.getGeocells() == null || locale.getGeocells().size() == 0) {
            return;
        }
        if (locale.getLastSurveyalInstanceId() != null && (si = (SurveyInstance)siDao.getByKey(locale.getLastSurveyalInstanceId())) != null) {
            surveyId = si.getSurveyId();
            String pubKey = surveyId.toString() + "-publicStatus";
            if (MemCacheUtils.containsKey(cache, pubKey)) {
                showOnPublicMap = (Boolean)cache.get((Object)pubKey);
            } else {
                SurveyGroup surveyGroup;
                Survey s = (Survey)sDao.getByKey(surveyId);
                if (s != null && (surveyGroup = SurveyUtils.retrieveSurveyGroup(s.getSurveyGroupId())) != null) {
                    showOnPublicMap = surveyGroup.getPrivacyLevel() == SurveyGroup.PrivacyLevel.PUBLIC;
                    MemCacheUtils.putObject(cache, pubKey, showOnPublicMap);
                }
            }
        }
        for (int i = 1; i <= 4; ++i) {
            Long count;
            String cell = locale.getGeocells().get(i) + "-" + showOnPublicMap.toString();
            if (MemCacheUtils.containsKey(cache, cell)) {
                SurveyedLocaleCluster clusterInStore;
                Map cellMap = (Map)cache.get((Object)cell);
                count = (Long)cellMap.get("count");
                if (count == 1L && delta == -1) {
                    cache.remove((Object)cell);
                    clusterInStore = (SurveyedLocaleCluster)slcDao.getByKey((Long)cellMap.get("id"));
                    if (clusterInStore == null) continue;
                    slcDao.delete(clusterInStore);
                    continue;
                }
                Long latTotal = (Long)cellMap.get("lat") + Math.round(locale.getLatitude() * 1000000.0 * (double)delta);
                Long lonTotal = (Long)cellMap.get("lon") + Math.round(locale.getLongitude() * 1000000.0 * (double)delta);
                MapUtils.addToCache(cache, cell, (Long)cellMap.get("id"), count + (long)delta, latTotal, lonTotal);
                clusterInStore = (SurveyedLocaleCluster)slcDao.getByKey((Long)cellMap.get("id"));
                if (clusterInStore == null) continue;
                clusterInStore.setCount(((Long)cellMap.get("count")).intValue() + delta);
                clusterInStore.setLatCenter(1.0E-6 * (double)latTotal.longValue() / (double)(count + (long)delta));
                clusterInStore.setLonCenter(1.0E-6 * (double)lonTotal.longValue() / (double)(count + (long)delta));
                slcDao.save(clusterInStore);
                continue;
            }
            SurveyedLocaleCluster clusterInStore = slcDao.getExistingCluster(locale.getGeocells().get(i), showOnPublicMap);
            if (clusterInStore != null) {
                if (clusterInStore.getCount() == 1 && delta == -1) {
                    slcDao.delete(clusterInStore);
                    continue;
                }
                count = clusterInStore.getCount().longValue();
                Double latCenter = (clusterInStore.getLatCenter() * (double)count.longValue() + locale.getLatitude() * (double)delta) / (double)(count + (long)delta);
                Double lonCenter = (clusterInStore.getLonCenter() * (double)count.longValue() + locale.getLongitude() * (double)delta) / (double)(count + (long)delta);
                MapUtils.addToCache(cache, cell, clusterInStore.getKey().getId(), clusterInStore.getCount() + delta, Math.round(1000000.0 * latCenter * (double)(count + (long)delta)), Math.round(1000000.0 * lonCenter * (double)(count + (long)delta)));
                clusterInStore.setCount(clusterInStore.getCount() + delta);
                clusterInStore.setLatCenter(latCenter);
                clusterInStore.setLonCenter(lonCenter);
                slcDao.save(clusterInStore);
                continue;
            }
            SurveyedLocaleCluster slcNew = new SurveyedLocaleCluster(locale.getLatitude(), locale.getLongitude(), locale.getGeocells().subList(0, i), locale.getGeocells().get(i), i + 1, locale.getKey().getId(), showOnPublicMap, locale.getLastSurveyedDate());
            slcDao.save(slcNew);
            if (cache == null) continue;
            MapUtils.addToCache(cache, cell, slcNew.getKey().getId(), 1L, Math.round(1000000.0 * locale.getLatitude()), Math.round(1000000.0 * locale.getLongitude()));
        }
    }

    private static void addToCache(Cache cache, String cell, Long id, long count, Long latTotal, Long lonTotal) {
        HashMap<String, Long> v = new HashMap<String, Long>();
        v.put("count", count);
        v.put("id", id);
        v.put("lat", latTotal);
        v.put("lon", lonTotal);
        MemCacheUtils.putObject(cache, cell, v);
    }
}

