/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.surveyal.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.surveyal.domain.SurveyedLocaleCluster;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class SurveyedLocaleClusterDao
extends BaseDAO<SurveyedLocaleCluster> {
    public SurveyedLocaleClusterDao() {
        super(SurveyedLocaleCluster.class);
    }

    public SurveyedLocaleCluster getExistingCluster(String geocell, Boolean showOnPublicMap) {
        String queryString;
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocaleCluster.class, queryString = "clusterGeocell == :p1 && showOnPublicMap == :p2");
        List result = (List)query.execute((Object)geocell, (Object)showOnPublicMap);
        if (result != null && result.size() > 0) {
            return (SurveyedLocaleCluster)result.get(0);
        }
        return null;
    }

    public List<SurveyedLocaleCluster> listLocaleClustersByGeocell(List<String> geocells, Integer gcLevel) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = ":p1.contains(geocells) && level == :p2";
        Query query = pm.newQuery(SurveyedLocaleCluster.class, queryString);
        List results = (List)query.execute(geocells, (Object)gcLevel);
        return results;
    }

    public List<SurveyedLocaleCluster> listPublicLocaleClustersByGeocell(List<String> geocells, Integer gcLevel) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = ":p1.contains(geocells) && level == :p2 && showOnPublicMap == true";
        Query query = pm.newQuery(SurveyedLocaleCluster.class, queryString);
        List results = (List)query.execute(geocells, (Object)gcLevel);
        return results;
    }
}

