/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.gis.geography.domain.Country;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.waterforpeople.mapping.analytics.domain.AccessPointStatusSummary;
import org.waterforpeople.mapping.domain.AccessPoint;

public class AccessPointStatusSummaryDao
extends BaseDAO<AccessPointStatusSummary> {
    public AccessPointStatusSummaryDao() {
        super(AccessPointStatusSummary.class);
    }

    public static synchronized void incrementCount(AccessPoint ap, Country c, int unit) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(AccessPointStatusSummary.class);
        query.setFilter("year == yearParam && status == statusParam && community == communityParam && type == typeParam");
        query.declareParameters("String yearParam, String statusParam, String communityParam, String typeParam");
        String yearString = null;
        if (ap.getCollectionDate() != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(ap.getCollectionDate());
            yearString = cal.get(1) + "";
        }
        List results = (List)query.executeWithArray(new Object[]{yearString, ap.getPointStatus(), ap.getCommunityCode(), ap.getPointType()});
        AccessPointStatusSummary summary = null;
        if ((results == null || results.size() == 0) && unit > 0) {
            summary = new AccessPointStatusSummary();
            summary.setCount(1L);
            summary.setYear(yearString);
            summary.setStatus(ap.getPointStatus());
            if (ap.getCountryCode() != null) {
                summary.setCountry(ap.getCountryCode());
            } else {
                summary.setCountry(c.getIsoAlpha2Code());
            }
            summary.setCommunity(ap.getCommunityCode());
            summary.setType(ap.getPointType() != null ? ap.getPointType().toString() : "UNKNOWN");
        } else if (unit > 0) {
            summary = (AccessPointStatusSummary)results.get(0);
            summary.setCount(summary.getCount() + (long)unit);
        }
        if (summary != null) {
            AccessPointStatusSummaryDao thisDao = new AccessPointStatusSummaryDao();
            if (summary.getCount() == 0L && summary.getKey() != null) {
                thisDao.delete(summary);
            } else if (summary.getCount() > 0L) {
                try {
                    thisDao.save(summary);
                }
                catch (DatastoreTimeoutException te) {
                    AccessPointStatusSummaryDao.sleep();
                    thisDao.save(summary);
                }
            }
        }
    }

    public List<AccessPointStatusSummary> listByLocationAndYear(String country, String community, String type, String year, String status) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(AccessPointStatusSummary.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("country", filterString, paramString, "String", country, paramMap);
        this.appendNonNullParam("community", filterString, paramString, "String", community, paramMap);
        this.appendNonNullParam("year", filterString, paramString, "String", year, paramMap);
        this.appendNonNullParam("type", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("status", filterString, paramString, "String", status, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        return (List)query.executeWithMap(paramMap);
    }

    public List<AccessPointStatusSummary> listByCountryAndCreationDate(String country, Date creationDate, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(AccessPointStatusSummary.class);
        query.setFilter("country == countryParam && createdDateTime > dateParam");
        query.declareParameters("String countryParam, Date dateParam");
        query.declareImports("import java.util.Date");
        this.prepareCursor(cursorString, query);
        return (List)query.execute((Object)country, (Object)creationDate);
    }
}

