/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.VelocityUtil;
import com.gallatinsystems.editorial.dao.EditorialPageDao;
import com.gallatinsystems.editorial.domain.EditorialPage;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.standards.dao.LOSScoreToStatusMappingDao;
import com.gallatinsystems.standards.dao.LevelOfServiceScoreDao;
import com.gallatinsystems.standards.domain.LOSScoreToStatusMapping;
import com.gallatinsystems.standards.domain.LevelOfServiceScore;
import com.gallatinsystems.standards.domain.Standard;
import com.gallatinsystems.surveyal.domain.SurveyalValue;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.Key;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.velocity.VelocityContext;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.dao.GeoRegionDAO;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.GeoRegion;
import org.waterforpeople.mapping.domain.TechnologyType;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class KMLGenerator {
    private static final String IMAGE_ROOT = "mapiconimageroot";
    private static final Logger log = Logger.getLogger(KMLGenerator.class.getName());
    public static final String GOOGLE_EARTH_DISPLAY = "googleearth";
    public static final String WATER_POINT_FUNCTIONING_GREEN_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/glassGreen32.png";
    public static final String WATER_POINT_FUNCTIONING_YELLOW_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/glassOrange32.png";
    public static final String WATER_POINT_FUNCTIONING_RED_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/glassRed32.png";
    public static final String WATER_POINT_FUNCTIONING_BLACK_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/iconBlack36.png";
    public static final String PUBLIC_INSTITUTION_FUNCTIONING_GREEN_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/houseGreen36.png";
    public static final String PUBLIC_INSTITUTION_FUNCTIONING_YELLOW_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/houseYellow36.png";
    public static final String PUBLIC_INSTITUTION_FUNCTIONING_RED_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/houseRed36.png";
    public static final String PUBLIC_INSTITUTION_FUNCTIONING_BLACK_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/houseBlack36.png";
    public static final String PUBLIC_INSTITUTION_FUNCTION_BLACK_ICON_URL_2 = PropertyUtil.getProperty("mapiconimageroot") + "/images/iconBlack36.png";
    public static final String SCHOOL_INSTITUTION_FUNCTIONING_GREEN_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/pencilGreen36.png";
    public static final String SCHOOL_INSTITUTION_FUNCTIONING_YELLOW_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/pencilYellow36.png";
    public static final String SCHOOL_INSTITUTION_FUNCTIONING_RED_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/pencilRed36.png";
    public static final String SCHOOL_INSTITUTION_FUNCTIONING_BLACK_ICON_URL = PropertyUtil.getProperty("mapiconimageroot") + "/images/pencilBlack36.png";
    public static final Boolean useScore = Boolean.parseBoolean(PropertyUtil.getProperty("scoreAPFlag"));
    public static final String ORGANIZATION_KEY = "organization";
    public static final String ORGANIZATION = PropertyUtil.getProperty("organization");
    private static final ThreadLocal<DateFormat> LONG_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss z");
        }
    };
    private static final Map<String, String> ICON_TYPE_MAPPING;
    private static final Map<String, String> ICON_COLOR_MAPPING;
    private static final String IMAGE_PREFIX;
    private static final String DEFAULT = "DEFAULT";
    public static final String defaultPhotoCaption;
    private static final String DYNAMIC_SCORING_FLAG = "scoreAPDynamicFlag";
    public static final String useLongDates;

    public static String getMarkerImageUrl(String type, String status) {
        String url = IMAGE_PREFIX + "/images/";
        String typePart = ICON_TYPE_MAPPING.get(type != null ? type : DEFAULT);
        if (typePart == null) {
            typePart = ICON_TYPE_MAPPING.get(DEFAULT);
        }
        url = url + typePart;
        String statusPart = ICON_COLOR_MAPPING.get(status != null ? status : DEFAULT);
        if (statusPart == null) {
            statusPart = ICON_COLOR_MAPPING.get(DEFAULT);
        }
        url = url + statusPart;
        return url;
    }

    public String generateRegionDocumentString(String regionVMName) {
        String regionKML = this.generateRegionOutlines(regionVMName);
        return regionKML;
    }

    public void generateCountryOrderedPlacemarks(String vmName, String countryCode, String technologyType) {
    }

    public HashMap<String, ArrayList<String>> generateCountrySpecificPlacemarks(String vmName, String countryCode) {
        if (countryCode.equals("MW")) {
            HashMap techMap = new HashMap();
            BaseDAO<TechnologyType> techDAO = new BaseDAO<TechnologyType>(TechnologyType.class);
            List<TechnologyType> techTypeList = techDAO.list("all");
            AccessPointDao apDao = new AccessPointDao();
            List<AccessPoint> waterAPList = apDao.searchAccessPoints(countryCode, null, null, null, "WATER_POINT", null, null, null, null, null, null, "all");
            for (TechnologyType techType : techTypeList) {
                ArrayList techTypeAPList = new ArrayList();
                for (AccessPoint accessPoint : waterAPList) {
                    if (techType.getName().toLowerCase().equals("unimproved waterpoint") && accessPoint.getTypeTechnologyString().toLowerCase().contains("unimproved waterpoint")) {
                        techTypeAPList.add(accessPoint);
                        continue;
                    }
                    if (!accessPoint.getTypeTechnologyString().equals(techType.getName())) continue;
                    techTypeAPList.add(accessPoint);
                }
                techMap.put(techType.getName(), techTypeAPList);
            }
            List<AccessPoint> sanitationAPList = apDao.searchAccessPoints(countryCode, null, null, null, "SANITATION_POINT", null, null, null, null, null, null, "all");
            HashMap<String, AccessPoint> sanitationMap = new HashMap<String, AccessPoint>();
            for (AccessPoint item : sanitationAPList) {
                sanitationMap.put(item.getGeocells().toString(), item);
            }
            sanitationAPList = null;
            HashMap<String, ArrayList<String>> techPlacemarksMap = new HashMap<String, ArrayList<String>>();
            for (Map.Entry entry : techMap.entrySet()) {
                String key = (String)entry.getKey();
                ArrayList<String> placemarks = new ArrayList<String>();
                for (AccessPoint waterAP : (ArrayList)entry.getValue()) {
                    AccessPoint sanitationAP = (AccessPoint)sanitationMap.get(waterAP.getGeocells().toString());
                    if (sanitationAP != null) {
                        placemarks.add(this.buildMainPlacemark(waterAP, sanitationAP, vmName));
                        continue;
                    }
                    log.info("No matching sanitation point found for " + waterAP.getLatitude() + ":" + waterAP.getLongitude() + ":" + waterAP.getCommunityName());
                }
                techPlacemarksMap.put(key, placemarks);
            }
            return techPlacemarksMap;
        }
        return null;
    }

    private HashMap<String, String> loadContextBindings(AccessPoint waterAP, AccessPoint sanitationAP) {
        try {
            HashMap<String, String> contextBindingsMap = new HashMap<String, String>();
            if (waterAP.getCollectionDate() != null) {
                String timestamp = DateFormatUtils.formatUTC((Date)waterAP.getCollectionDate(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
                String formattedDate = DateFormat.getDateInstance(3).format(waterAP.getCollectionDate());
                contextBindingsMap.put("collectionDate", formattedDate);
                contextBindingsMap.put("timestamp", timestamp);
                String collectionYear = new SimpleDateFormat("yyyy").format(waterAP.getCollectionDate());
                contextBindingsMap.put("collectionYear", collectionYear);
            } else {
                String timestamp = DateFormatUtils.formatUTC((Date)new Date(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
                String formattedDate = DateFormat.getDateInstance(3).format(new Date());
                contextBindingsMap.put("collectionDate", formattedDate);
                contextBindingsMap.put("timestamp", timestamp);
                String collectionYear = new SimpleDateFormat("yyyy").format(new Date());
                contextBindingsMap.put("collectionYear", collectionYear);
            }
            contextBindingsMap.put("communityCode", this.encodeNullDefault(waterAP.getCommunityCode(), "Unknown"));
            contextBindingsMap.put("communityName", this.encodeNullDefault(waterAP.getCommunityName(), "Unknown"));
            contextBindingsMap.put("typeOfWaterPointTechnology", this.encodeNullDefault(waterAP.getTypeTechnologyString(), "Unknown"));
            contextBindingsMap.put("constructionDateOfWaterPoint", this.encodeNullDefault(waterAP.getConstructionDateYear(), "Unknown"));
            contextBindingsMap.put("numberOfHouseholdsUsingWaterPoint", this.encodeNullDefault(waterAP.getNumberOfHouseholdsUsingPoint(), "Unknown"));
            contextBindingsMap.put("costPer20ML", this.encodeNullDefault(waterAP.getCostPer(), "Unknown"));
            contextBindingsMap.put("farthestHouseholdFromWaterPoint", this.encodeNullDefault(waterAP.getFarthestHouseholdfromPoint(), "Unknown"));
            contextBindingsMap.put("currentManagementStructureOfWaterPoint", this.encodeNullDefault(waterAP.getCurrentManagementStructurePoint(), "Unknown"));
            contextBindingsMap.put("waterSystemStatus", this.encodeStatusString(waterAP.getPointStatus()));
            contextBindingsMap.put("photoUrl", this.encodeNullDefault(waterAP.getPhotoURL(), "Unknown"));
            contextBindingsMap.put("waterPointPhotoCaption", this.encodeNullDefault(waterAP.getPointPhotoCaption(), "Unknown"));
            contextBindingsMap.put("primarySanitationTechnology", this.encodeNullDefault(sanitationAP.getTypeTechnologyString(), "Unknown"));
            contextBindingsMap.put("percentageOfHouseholdsWithImprovedSanitation", this.encodeNullDefault(sanitationAP.getNumberOfHouseholdsUsingPoint(), "Unknown"));
            contextBindingsMap.put("photoOfPrimarySanitationtechnology", this.encodeNullDefault(sanitationAP.getPhotoURL(), "Unknown"));
            contextBindingsMap.put("sanitationPhotoCaption", this.encodeNullDefault(sanitationAP.getPointPhotoCaption(), "Unknown"));
            contextBindingsMap.put("footer", this.encodeNullDefault(waterAP.getFooter(), "Unknown"));
            contextBindingsMap.put("longitude", this.encodeNullDefault(waterAP.getLongitude().toString(), "Unknown"));
            contextBindingsMap.put("latitude", this.encodeNullDefault(waterAP.getLatitude().toString(), "Unknown"));
            contextBindingsMap.put("altitude", this.encodeNullDefault(waterAP.getAltitude().toString(), "0.0"));
            contextBindingsMap.put("pinStyle", KMLGenerator.encodePinStyle(waterAP.getPointType(), waterAP.getPointStatus()));
            return contextBindingsMap;
        }
        catch (NullPointerException nex) {
            log.log(Level.SEVERE, "Could not load context bindings", nex);
            return null;
        }
    }

    private String buildMainPlacemark(AccessPoint waterAP, AccessPoint sanitationAP, String vmName) {
        HashMap<String, String> contextBindingsMap = this.loadContextBindings(waterAP, sanitationAP);
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, String> entry : contextBindingsMap.entrySet()) {
            context.put(entry.getKey(), (Object)entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        String output = null;
        try {
            output = this.mergeContext(context, vmName);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not build main placemark", e);
        }
        sb.append(output);
        return sb.toString();
    }

    private String encodeNullDefault(Object value, String defaultMissingVal) {
        try {
            if (value != null) {
                return value.toString();
            }
            return defaultMissingVal;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Could not encode null default", ex);
            return null;
        }
    }

    private String mergeContext(VelocityContext context, String template) throws Exception {
        return VelocityUtil.mergeContext(context, template, new VelocityUtil.TemplateCacheBackingStore(){

            @Override
            public String getByKey(String key) {
                EditorialPageDao edDao = new EditorialPageDao();
                EditorialPage page = edDao.findByTargetPage(key);
                if (page != null) {
                    return page.getTemplate().getValue();
                }
                return null;
            }
        });
    }

    public String bindPlacemark(SurveyedLocale ap, String vmName, String display) throws Exception {
        String formattedDate;
        String timestamp;
        if (ap.getCountryCode() == null) {
            ap.setCountryCode("Unknown");
        }
        VelocityContext context = new VelocityContext();
        context.put(ORGANIZATION_KEY, (Object)ORGANIZATION);
        if (display != null) {
            context.put("display", (Object)display);
        }
        context.put("countryCode", (Object)ap.getCountryCode());
        if (ap.getLastSurveyedDate() != null) {
            timestamp = DateFormatUtils.formatUTC((Date)ap.getLastSurveyedDate(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
            formattedDate = null;
            formattedDate = "true".equals(useLongDates) ? LONG_DATE_FORMAT.get().format(ap.getLastSurveyedDate()) : DateFormat.getDateInstance(3).format(ap.getLastSurveyedDate());
            context.put("collectionDate", (Object)formattedDate);
            context.put("timestamp", (Object)timestamp);
            String collectionYear = new SimpleDateFormat("yyyy").format(ap.getLastSurveyedDate());
            context.put("collectionYear", (Object)collectionYear);
        } else {
            timestamp = DateFormatUtils.formatUTC((Date)ap.getCreatedDateTime(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
            formattedDate = null;
            formattedDate = "true".equals(useLongDates) ? LONG_DATE_FORMAT.get().format(ap.getCreatedDateTime()) : DateFormat.getDateInstance(3).format(ap.getCreatedDateTime());
            context.put("collectionDate", (Object)formattedDate);
            context.put("timestamp", (Object)timestamp);
        }
        if (ap.getIdentifier() != null) {
            context.put("identifier", (Object)ap.getIdentifier());
        } else {
            context.put("identifier", (Object)("Unknown" + new Date()));
        }
        boolean foundPhoto = false;
        boolean foundStatus = false;
        if (ap.getSurveyalValues() != null) {
            ArrayList<SurveyalValue> valuesToBind = new ArrayList<SurveyalValue>(ap.getSurveyalValues());
            for (SurveyalValue val : ap.getSurveyalValues()) {
                if (val.getQuestionType() != null && !"free_text".equalsIgnoreCase(val.getQuestionType()) && !"option".equalsIgnoreCase(val.getQuestionType())) {
                    valuesToBind.remove(val);
                }
                if (val.getStringValue() == null) {
                    valuesToBind.remove(val);
                    continue;
                }
                if (val.getStringValue().trim().toLowerCase().endsWith(".jpg") || val.getStringValue().trim().toLowerCase().endsWith(".jpeg")) {
                    String urlBase = val.getStringValue();
                    if (urlBase.contains("/")) {
                        urlBase = urlBase.substring(urlBase.lastIndexOf("/") + 1);
                    }
                    if (!urlBase.toLowerCase().startsWith("http")) {
                        if (urlBase.endsWith("/")) {
                            urlBase = urlBase.substring(0, urlBase.length() - 1);
                        }
                        urlBase = PropertyUtil.getProperty("photo_url_root") + urlBase;
                    }
                    context.put("photoUrl", (Object)urlBase);
                    foundPhoto = true;
                    valuesToBind.remove(val);
                    continue;
                }
                if (ap.getCurrentStatus() != null || val.getMetricName() == null || !val.getMetricName().trim().toLowerCase().contains("status")) continue;
                context.put("waterSystemStatus", (Object)val.getStringValue());
                foundStatus = true;
            }
            context.put("surveyalValues", valuesToBind);
        }
        if (ap.getCurrentStatus() != null) {
            try {
                context.put("waterSystemStatus", (Object)this.encodeStatusString(AccessPoint.Status.valueOf(ap.getCurrentStatus())));
            }
            catch (Exception e) {
                context.put("waterSystemStatus", (Object)"Unknown");
            }
        } else if (!foundStatus) {
            context.put("waterSystemStatus", (Object)"Unknown");
        }
        if (!foundPhoto) {
            context.put("photoUrl", (Object)"http://waterforpeople.s3.amazonaws.com/images/wfplogo.jpg");
        }
        context.put("latitude", (Object)ap.getLatitude());
        context.put("longitude", (Object)ap.getLongitude());
        if (ap.getLocaleType() != null) {
            context.put("type", (Object)ap.getLocaleType());
        } else {
            context.put("type", (Object)"water");
        }
        String output = this.mergeContext(context, vmName);
        context = null;
        return output;
    }

    public String bindPlacemark(AccessPoint ap, String vmName, String display, Standard.StandardType standardType) throws Exception {
        if (display != null && display.trim().equalsIgnoreCase(GOOGLE_EARTH_DISPLAY)) {
            vmName = "placemarkGoogleEarth.vm";
        }
        if (ap.getCountryCode() == null) {
            ap.setCountryCode("Unknown");
        }
        if (ap.getCountryCode() != null) {
            String formattedDate;
            String timestamp;
            VelocityContext context = new VelocityContext();
            context.put(ORGANIZATION_KEY, (Object)ORGANIZATION);
            if (display != null) {
                context.put("display", (Object)display);
            }
            context.put("countryCode", (Object)ap.getCountryCode());
            if (ap.getCollectionDate() != null) {
                timestamp = DateFormatUtils.formatUTC((Date)ap.getCollectionDate(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
                formattedDate = DateFormat.getDateInstance(3).format(ap.getCollectionDate());
                context.put("collectionDate", (Object)formattedDate);
                context.put("timestamp", (Object)timestamp);
                String collectionYear = new SimpleDateFormat("yyyy").format(ap.getCollectionDate());
                context.put("collectionYear", (Object)collectionYear);
            } else {
                timestamp = DateFormatUtils.formatUTC((Date)ap.getCreatedDateTime(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
                formattedDate = DateFormat.getDateInstance(3).format(ap.getCreatedDateTime());
                context.put("collectionDate", (Object)formattedDate);
                context.put("timestamp", (Object)timestamp);
            }
            if (ap.getCommunityCode() != null) {
                context.put("communityCode", (Object)ap.getCommunityCode());
            } else {
                context.put("communityCode", (Object)("Unknown" + new Date()));
            }
            if (ap.getWaterForPeopleProjectFlag() != null) {
                context.put("waterForPeopleProject", (Object)this.encodeBooleanDisplay(ap.getWaterForPeopleProjectFlag()));
            } else {
                context.put("waterForPeopleProject", (Object)"null");
            }
            if (ap.getCurrentProblem() != null) {
                context.put("currentProblem", (Object)ap.getCurrentProblem());
            } else {
                context.put("currentProblem", (Object)ap.getCurrentProblem());
            }
            if (ap.getWaterForPeopleRole() != null) {
                context.put("waterForPeopleRole", (Object)ap.getWaterForPeopleRole());
            } else {
                context.put("waterForPeopleRole", (Object)"null");
            }
            if (ap.getPhotoURL() != null && ap.getPhotoURL().trim() != "") {
                context.put("photoUrl", (Object)ap.getPhotoURL());
            } else {
                context.put("photoUrl", (Object)"http://waterforpeople.s3.amazonaws.com/images/wfplogo.jpg");
            }
            if (ap.getPointType() != null) {
                if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.WATER_POINT)) {
                    context.put("typeOfPoint", (Object)"Water");
                    context.put("type", (Object)"water");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.SANITATION_POINT)) {
                    context.put("typeOfPoint", (Object)"Sanitation");
                    context.put("type", (Object)"sanitation");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.PUBLIC_INSTITUTION)) {
                    context.put("typeOfPoint", (Object)"Public Institutions");
                    context.put("type", (Object)"public_institutions");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.HEALTH_POSTS)) {
                    context.put("typeOfPoint", (Object)"Health Posts");
                    context.put("type", (Object)"health_posts");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.SCHOOL)) {
                    context.put("typeOfPoint", (Object)"School");
                    context.put("type", (Object)"school");
                }
            } else {
                context.put("typeOfPoint", (Object)"Water");
                context.put("type", (Object)"water");
            }
            if (ap.getTypeTechnologyString() == null) {
                context.put("primaryTypeTechnology", (Object)"Unknown");
            } else {
                context.put("primaryTypeTechnology", (Object)ap.getTypeTechnologyString());
            }
            if (ap.getHasSystemBeenDown1DayFlag() == null) {
                context.put("down1DayFlag", (Object)"Unknown");
            } else {
                context.put("down1DayFlag", (Object)this.encodeBooleanDisplay(ap.getHasSystemBeenDown1DayFlag()));
            }
            if (ap.getInstitutionName() == null) {
                context.put("institutionName", (Object)"Unknown");
            } else {
                context.put("institutionName", (Object)ap.getInstitutionName());
            }
            if (ap.getExtimatedPopulation() != null) {
                context.put("estimatedPopulation", (Object)ap.getExtimatedPopulation());
            } else {
                context.put("estimatedPopulation", (Object)"null");
            }
            if (ap.getConstructionDateYear() == null || ap.getConstructionDateYear().trim().equals("")) {
                context.put("constructionDateOfWaterPoint", (Object)"Unknown");
            } else {
                String constructionDateYear = ap.getConstructionDateYear();
                if (constructionDateYear.contains(".0")) {
                    constructionDateYear = constructionDateYear.replace(".0", "");
                }
                context.put("constructionDateOfWaterPoint", (Object)constructionDateYear);
            }
            if (ap.getNumberOfHouseholdsUsingPoint() != null) {
                context.put("numberOfHouseholdsUsingWaterPoint", (Object)ap.getNumberOfHouseholdsUsingPoint());
            } else {
                context.put("numberOfHouseholdsUsingWaterPoint", (Object)"null");
            }
            if (ap.getCostPer() == null) {
                context.put("costPer", (Object)"N/A");
            } else {
                context.put("costPer", (Object)ap.getCostPer());
            }
            if (ap.getFarthestHouseholdfromPoint() == null || ap.getFarthestHouseholdfromPoint().trim().equals("")) {
                context.put("farthestHouseholdfromWaterPoint", (Object)"N/A");
            } else {
                context.put("farthestHouseholdfromWaterPoint", (Object)ap.getFarthestHouseholdfromPoint());
            }
            if (ap.getCurrentManagementStructurePoint() == null) {
                context.put("currMgmtStructure", (Object)"N/A");
            } else {
                context.put("currMgmtStructure", (Object)ap.getCurrentManagementStructurePoint());
            }
            if (ap.getPointPhotoCaption() == null || ap.getPointPhotoCaption().trim().equals("")) {
                context.put("waterPointPhotoCaption", (Object)defaultPhotoCaption);
            } else {
                context.put("waterPointPhotoCaption", (Object)ap.getPointPhotoCaption());
            }
            if (ap.getCommunityName() == null) {
                context.put("communityName", (Object)"Unknown");
            } else {
                context.put("communityName", (Object)ap.getCommunityName());
            }
            if (ap.getHeader() == null) {
                context.put("header", (Object)"Water For People");
            } else {
                context.put("header", (Object)ap.getHeader());
            }
            if (ap.getFooter() == null) {
                context.put("footer", (Object)"Water For People");
            } else {
                context.put("footer", (Object)ap.getFooter());
            }
            if (ap.getPhotoName() == null) {
                context.put("photoName", (Object)"Water For People");
            } else {
                context.put("photoName", (Object)ap.getPhotoName());
            }
            if (ap.getMeetGovtQualityStandardFlag() == null) {
                context.put("meetGovtQualityStandardFlag", (Object)"N/A");
            } else {
                context.put("meetGovtQualityStandardFlag", (Object)this.encodeBooleanDisplay(ap.getMeetGovtQualityStandardFlag()));
            }
            if (ap.getMeetGovtQuantityStandardFlag() == null) {
                context.put("meetGovtQuantityStandardFlag", (Object)"N/A");
            } else {
                context.put("meetGovtQuantityStandardFlag", (Object)this.encodeBooleanDisplay(ap.getMeetGovtQuantityStandardFlag()));
            }
            if (ap.getWhoRepairsPoint() == null) {
                context.put("whoRepairsPoint", (Object)"N/A");
            } else {
                context.put("whoRepairsPoint", (Object)ap.getWhoRepairsPoint());
            }
            if (ap.getSecondaryTechnologyString() == null) {
                context.put("secondaryTypeTechnology", (Object)"N/A");
            } else {
                context.put("secondaryTypeTechnology", (Object)ap.getSecondaryTechnologyString());
            }
            if (ap.getProvideAdequateQuantity() == null) {
                context.put("provideAdequateQuantity", (Object)"N/A");
            } else {
                context.put("provideAdequateQuantity", (Object)this.encodeBooleanDisplay(ap.getProvideAdequateQuantity()));
            }
            if (ap.getBalloonTitle() == null) {
                context.put("title", (Object)"Water For People");
            } else {
                context.put("title", (Object)ap.getBalloonTitle());
            }
            if (ap.getProvideAdequateQuantity() == null) {
                context.put("provideAdequateQuantity", (Object)"N/A");
            } else {
                context.put("provideAdequateQuantity", (Object)this.encodeBooleanDisplay(ap.getProvideAdequateQuantity()));
            }
            if (ap.getQualityDescription() != null) {
                context.put("qualityDescription", (Object)ap.getQualityDescription());
            }
            if (ap.getQuantityDescription() != null) {
                context.put("quantityDescription", (Object)ap.getQuantityDescription());
            }
            if (ap.getSub1() != null) {
                context.put("sub1", (Object)ap.getSub1());
            }
            if (ap.getSub2() != null) {
                context.put("sub2", (Object)ap.getSub2());
            }
            if (ap.getSub3() != null) {
                context.put("sub3", (Object)ap.getSub3());
            }
            if (ap.getSub4() != null) {
                context.put("sub4", (Object)ap.getSub4());
            }
            if (ap.getSub5() != null) {
                context.put("sub5", (Object)ap.getSub5());
            }
            if (ap.getSub6() != null) {
                context.put("sub6", (Object)ap.getSub6());
            }
            if (ap.getAccessPointCode() != null) {
                context.put("accessPointCode", (Object)ap.getAccessPointCode());
            }
            if (ap.getAccessPointUsage() != null) {
                context.put("accessPointUsage", (Object)ap.getAccessPointUsage());
            }
            if (ap.getDescription() != null) {
                context.put("description", (Object)ap.getDescription());
            } else {
                context.put("description", (Object)"Unknown");
            }
            if (ap.getPointType() != null) {
                if (Boolean.parseBoolean(PropertyUtil.getProperty(DYNAMIC_SCORING_FLAG))) {
                    TreeMap<String, String> combinedScore = this.fetchLevelOfServiceScoreStatus(ap);
                    for (Map.Entry<String, String> entry : combinedScore.entrySet()) {
                        context.put(entry.getKey(), (Object)entry.getValue());
                        String style = null;
                        if (standardType != null) {
                            if (standardType.equals((Object)Standard.StandardType.WaterPointLevelOfService) && entry.getKey().equals(Standard.StandardType.WaterPointLevelOfService.toString() + "-pinStyle")) {
                                style = entry.getValue();
                            } else if (standardType.equals((Object)Standard.StandardType.WaterPointSustainability) && entry.getKey().equals(Standard.StandardType.WaterPointSustainability.toString() + "-pinStyle")) {
                                style = entry.getValue();
                            }
                        }
                        context.put("pinStyle", style);
                    }
                } else {
                    this.encodeStatusString(ap, context);
                    context.put("pinStyle", (Object)KMLGenerator.encodePinStyle(ap.getPointType(), ap.getPointStatus()));
                }
            } else {
                context.put("pinStyle", (Object)"waterpushpinblk");
            }
            String output = this.mergeContext(context, vmName);
            context = null;
            return output;
        }
        return null;
    }

    private TreeMap<String, String> fetchLevelOfServiceScoreStatus(AccessPoint ap) {
        TreeMap<String, String> losStyles = new TreeMap<String, String>();
        LevelOfServiceScoreDao losScoreDao = new LevelOfServiceScoreDao();
        List<LevelOfServiceScore> losList = losScoreDao.listByAccessPoint(ap.getKey());
        LOSScoreToStatusMappingDao losScoreToStatusMappingDao = new LOSScoreToStatusMappingDao();
        for (LevelOfServiceScore losItem : losList) {
            LOSScoreToStatusMapping losScoreToStatusMapping = losScoreToStatusMappingDao.findByLOSScoreTypeAndScore(losItem.getScoreType(), losItem.getScore());
            losStyles.put(losScoreToStatusMapping.getLevelOfServiceScoreType().toString() + "-color", losScoreToStatusMapping.getColor().toString());
            losStyles.put(losScoreToStatusMapping.getLevelOfServiceScoreType().toString() + "-desc", losScoreToStatusMapping.getDescription());
            losStyles.put(losScoreToStatusMapping.getLevelOfServiceScoreType().toString() + "-score", losItem.getScore().toString());
            losStyles.put(losScoreToStatusMapping.getLevelOfServiceScoreType().toString() + "-pinstyle", losScoreToStatusMapping.getIconStyle());
            losStyles.put(losScoreToStatusMapping.getLevelOfServiceScoreType().toString() + "-iconSmallUrl", losScoreToStatusMapping.getIconSmallUrl());
        }
        return losStyles;
    }

    public String generateRegionOutlines(String vmName) {
        StringBuilder sb = new StringBuilder();
        GeoRegionDAO grDAO = new GeoRegionDAO();
        List<GeoRegion> grList = grDAO.list();
        try {
            if (grList != null && grList.size() > 0) {
                String currUUID = grList.get(0).getUuid();
                VelocityContext context = new VelocityContext();
                StringBuilder sbCoor = new StringBuilder();
                for (int i = 0; i < grList.size(); ++i) {
                    GeoRegion gr = grList.get(i);
                    if (currUUID.equals(gr.getUuid())) {
                        sbCoor.append(gr.getLongitude() + "," + gr.getLatitiude() + "," + 0 + "\n");
                        continue;
                    }
                    currUUID = gr.getUuid();
                    context.put("coordinateString", (Object)sbCoor.toString());
                    sb.append(this.mergeContext(context, vmName));
                    context = new VelocityContext();
                    sbCoor = new StringBuilder();
                    sbCoor.append(gr.getLongitude() + "," + gr.getLatitiude() + "," + 0 + "\n");
                }
                context.put("coordinateString", (Object)sbCoor.toString());
                sb.append(this.mergeContext(context, vmName));
                return sb.toString();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error generating region outlines", e);
        }
        return "";
    }

    private String encodeBooleanDisplay(Boolean value) {
        if (value.booleanValue()) {
            return "Yes";
        }
        return "No";
    }

    public LOSScoreToStatusMapping encodePinStyle(Key accessPointKey, Standard.StandardType standardType) {
        LevelOfServiceScoreDao losScoreDao = new LevelOfServiceScoreDao();
        LevelOfServiceScore losScore = losScoreDao.findByAccessPoint(accessPointKey, standardType);
        LOSScoreToStatusMappingDao losMapDao = new LOSScoreToStatusMappingDao();
        LOSScoreToStatusMapping losMapItem = losMapDao.findByLOSScoreTypeAndScore(standardType, losScore.getScore());
        return losMapItem;
    }

    public static String encodePinStyle(AccessPoint.AccessPointType type, AccessPoint.Status status) {
        String prefix = "water";
        if (AccessPoint.AccessPointType.SANITATION_POINT == type) {
            prefix = "sani";
        } else if (AccessPoint.AccessPointType.SCHOOL == type) {
            prefix = "schwater";
        } else if (AccessPoint.AccessPointType.PUBLIC_INSTITUTION == type || AccessPoint.AccessPointType.HEALTH_POSTS == type) {
            prefix = "pubwater";
        }
        if (AccessPoint.Status.FUNCTIONING_HIGH == status) {
            return prefix + "pushpingreen";
        }
        if (AccessPoint.Status.FUNCTIONING_OK == status || AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS == status) {
            return prefix + "pushpinyellow";
        }
        if (AccessPoint.Status.BROKEN_DOWN == status) {
            return prefix + "pushpinred";
        }
        if (AccessPoint.Status.NO_IMPROVED_SYSTEM == status) {
            return prefix + "pushpinblk";
        }
        return prefix + "pushpinblk";
    }

    public static String encodePinStyle(String type, String status) {
        String prefix = "water";
        if (type != null) {
            if ("SanitationPoint".equalsIgnoreCase(type)) {
                prefix = "sani";
            } else if ("School".equalsIgnoreCase(type)) {
                prefix = "schwater";
            } else if ("PublicInstitution".equalsIgnoreCase(type)) {
                prefix = "pubwater";
            }
        }
        if ("FUNCTIONING_HIGH".equalsIgnoreCase(status)) {
            return prefix + "pushpingreen";
        }
        if ("FUNCTIONING_OK".equalsIgnoreCase(status) || "FUNCTIONING_WITH_PROBLEMS".equalsIgnoreCase(status)) {
            return prefix + "pushpinyellow";
        }
        if ("BROKEN_DOWN".equalsIgnoreCase(status)) {
            return prefix + "pushpinred";
        }
        if ("NO_IMPROVED_SYSTEM".equalsIgnoreCase(status)) {
            return prefix + "pushpinblk";
        }
        return prefix + "pushpinblk";
    }

    private String encodeStatusString(AccessPoint ap, VelocityContext context) {
        AccessPoint.Status status = ap.getPointStatus();
        if (ap.getCollectionDate() == null || ap.getCollectionDate().before(new Date("01/01/2011")) || !useScore.booleanValue()) {
            if (status != null) {
                if (AccessPoint.Status.FUNCTIONING_HIGH == status) {
                    context.put("waterSystemStatus", (Object)"Meets Government Standards");
                    return "System Functioning and Meets Government Standards";
                }
                if (AccessPoint.Status.FUNCTIONING_OK == status || AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS == status) {
                    context.put("waterSystemStatus", (Object)"Functioning but with Problems");
                    return "Functioning but with Problems";
                }
                if (AccessPoint.Status.BROKEN_DOWN == status) {
                    context.put("waterSystemStatus", (Object)"Broken-down system");
                    return "Broken-down system";
                }
                if (AccessPoint.Status.NO_IMPROVED_SYSTEM == status) {
                    context.put("waterSystemStatus", (Object)"No Improved System");
                    return "No Improved System";
                }
                context.put("waterSystemStatus", (Object)"Unknown");
                return "Unknown";
            }
            context.put("waterSystemStatus", (Object)"Unknown");
            return "Unknown";
        }
        String statusString = null;
        try {
            statusString = this.encodeStatusUsingScore(ap);
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Couldn't score  ap: " + ap.toString() + " " + ex);
        }
        if (statusString == null) {
            statusString = "Unknown";
        }
        context.put("waterSystemStatus", (Object)statusString);
        AccessPointDao apDao = new AccessPointDao();
        apDao.save(ap);
        return statusString;
    }

    private String encodeStatusString(AccessPoint.Status status) {
        if (status == null) {
            return "Unknown";
        }
        if (status.equals((Object)AccessPoint.Status.FUNCTIONING_HIGH)) {
            return "System Functioning and Meets Government Standards";
        }
        if (status.equals((Object)AccessPoint.Status.FUNCTIONING_OK) || status.equals((Object)AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS)) {
            return "Functioning but with Problems";
        }
        if (status.equals((Object)AccessPoint.Status.BROKEN_DOWN)) {
            return "Broken-down system";
        }
        if (status.equals((Object)AccessPoint.Status.NO_IMPROVED_SYSTEM)) {
            return "No Improved System";
        }
        return "Unknown";
    }

    public String encodeStatusUsingScore(AccessPoint ap) throws InvocationTargetException, NoSuchMethodException {
        Integer score = AccessPointHelper.scoreAccessPoint(ap).getScore();
        new AccessPointHelper().scoreAccessPointDynamic(ap).getScore();
        if (score == 0) {
            return "No Improved System";
        }
        if (score >= 1 && score <= 2) {
            return "Basic Level Service";
        }
        if (score >= 3 && score <= 4) {
            return "Intermediate Level Service";
        }
        if (score >= 5) {
            return "High Level Service";
        }
        return "Unknown";
    }

    static {
        IMAGE_PREFIX = PropertyUtil.getProperty(IMAGE_ROOT);
        defaultPhotoCaption = PropertyUtil.getProperty("defaultPhotoCaption");
        ICON_TYPE_MAPPING = new HashMap<String, String>();
        ICON_TYPE_MAPPING.put("WaterPoint", "glass");
        ICON_TYPE_MAPPING.put("PublicInstitution", "house");
        ICON_TYPE_MAPPING.put("Household", "house");
        ICON_TYPE_MAPPING.put("School", "pencil");
        ICON_TYPE_MAPPING.put("Trawler", "glass");
        ICON_TYPE_MAPPING.put(DEFAULT, "glass");
        ICON_COLOR_MAPPING = new HashMap<String, String>();
        ICON_COLOR_MAPPING.put(DEFAULT, "Black36.png");
        ICON_COLOR_MAPPING.put("FUNCTIONING_OK", "Green36.png");
        ICON_COLOR_MAPPING.put("FUNCTIONING_HIGH", "Green36.png");
        ICON_COLOR_MAPPING.put("FUNCTIONING_OK", "Yellow36.png");
        ICON_COLOR_MAPPING.put("FUNCTIONING_WITH_PROBLEMS", "Yellow36.png");
        ICON_COLOR_MAPPING.put("BROKEN_DOWN", "Black36.png");
        ICON_COLOR_MAPPING.put("NO_IMPROVED_SYSTEM", "Black36.png");
        useLongDates = PropertyUtil.getProperty("useLongDates");
    }
}

