/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.gis.map.dao.OGRFeatureDao;
import com.gallatinsystems.gis.map.domain.OGRFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.waterforpeople.mapping.analytics.domain.AccessPointMetricSummary;

public class AccessPointMetricSummaryDao
extends BaseDAO<AccessPointMetricSummary> {
    private static final int NUM_SHARDS = 11;

    public AccessPointMetricSummaryDao() {
        super(AccessPointMetricSummary.class);
    }

    public List<AccessPointMetricSummary> listMetrics(AccessPointMetricSummary prototype) {
        return this.listMetrics(prototype, true);
    }

    public List<AccessPointMetricSummary> listMetrics(AccessPointMetricSummary prototype, boolean fetchCentroid) {
        List<AccessPointMetricSummary> summaries = this.listMetrics(prototype, null);
        HashMap<String, AccessPointMetricSummary> rollups = new HashMap<String, AccessPointMetricSummary>();
        if (summaries != null) {
            for (AccessPointMetricSummary s : summaries) {
                AccessPointMetricSummary rollup = (AccessPointMetricSummary)rollups.get(s.identifierString());
                if (rollup == null) {
                    rollup = new AccessPointMetricSummary();
                    rollup.setCount(s.getCount() != null ? s.getCount() : 0L);
                    rollup.setCountry(s.getCountry());
                    rollup.setLastUpdateDateTime(s.getLastUpdateDateTime());
                    rollup.setMetricGroup(s.getMetricGroup());
                    rollup.setMetricName(s.getMetricName());
                    rollup.setMetricValue(s.getMetricValue());
                    rollup.setOrganization(s.getOrganization());
                    rollup.setSubLevel(s.getSubLevel());
                    rollup.setSubLevelName(s.getSubLevelName());
                    rollup.setSubValue(s.getSubValue());
                    rollup.setPeriodType(s.getPeriodType());
                    rollup.setPeriodValue(s.getPeriodValue());
                    rollups.put(s.identifierString(), rollup);
                    rollup.setParentSubName(s.getParentSubName());
                    continue;
                }
                rollup.setCount(rollup.getCount() + (s.getCount() != null ? s.getCount() : 0L));
            }
        }
        ArrayList<AccessPointMetricSummary> rollupList = new ArrayList<AccessPointMetricSummary>();
        rollupList.addAll(rollups.values());
        if (fetchCentroid) {
            OGRFeatureDao ogrFeatureDao = new OGRFeatureDao();
            for (AccessPointMetricSummary item : rollupList) {
                if (item.getSubValue() == null) continue;
                List<OGRFeature> ogr = ogrFeatureDao.listBySubLevelCountryName(item.getCountry(), prototype.getSubLevel(), item.getSubValue(), "all", item.getParentSubName());
                for (OGRFeature ogrItem : ogr) {
                    item.setLatitude(ogrItem.getCentroidLat());
                    item.setLongitude(ogrItem.getCentroidLon());
                }
            }
        }
        return rollupList;
    }

    public List<AccessPointMetricSummary> listMetrics(AccessPointMetricSummary prototype, Integer shardNum) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        this.appendNonNullParam("organization", filterString, paramString, "String", prototype.getOrganization(), paramMap);
        this.appendNonNullParam("country", filterString, paramString, "String", prototype.getCountry(), paramMap);
        this.appendNonNullParam("subLevel", filterString, paramString, "Integer", prototype.getSubLevel(), paramMap);
        this.appendNonNullParam("subValue", filterString, paramString, "String", prototype.getSubValue(), paramMap);
        this.appendNonNullParam("metricName", filterString, paramString, "String", prototype.getMetricName(), paramMap);
        this.appendNonNullParam("metricGroup", filterString, paramString, "String", prototype.getMetricGroup(), paramMap);
        this.appendNonNullParam("metricValue", filterString, paramString, "String", prototype.getMetricValue(), paramMap);
        this.appendNonNullParam("shardNum", filterString, paramString, "Integer", shardNum, paramMap);
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(AccessPointMetricSummary.class);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        return (List)query.executeWithMap(paramMap);
    }

    public static synchronized void incrementCount(AccessPointMetricSummary metric, int unit) {
        AccessPointMetricSummaryDao dao = new AccessPointMetricSummaryDao();
        Random generator = new Random();
        int shardNum = generator.nextInt(11);
        List<AccessPointMetricSummary> results = dao.listMetrics(metric, shardNum);
        AccessPointMetricSummary summary = null;
        if ((results == null || results.size() == 0) && unit > 0) {
            metric.setCount(new Long(unit));
            metric.setShardNum(shardNum);
            summary = metric;
        } else if (results != null && results.size() > 0) {
            summary = results.get(0);
            summary.setCount(summary.getCount() + (long)unit);
        }
        if (summary != null) {
            if (summary.getCount() > 0L) {
                dao.save(summary);
            } else if (summary.getKey() != null) {
                dao.delete(summary);
            }
        }
    }
}

