/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyalValue;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.Entity;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.domain.DataUtils;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.waterforpeople.mapping.analytics.dao.AccessPointStatusSummaryDao;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.analytics.domain.AccessPointStatusSummary;
import org.waterforpeople.mapping.analytics.domain.SurveyQuestionSummary;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.QuestionAnswerStoreDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.dto.DataBackoutRequest;
import org.waterforpeople.mapping.app.web.dto.QuestionAnswerResponse;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class DataBackoutServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 4608959174864994769L;
    private QuestionDao qDao;
    private SurveyQuestionSummaryDao questionSummaryDao;
    private SurveyInstanceDAO instanceDao;
    private AccessPointDao accessPointDao;
    private SurveyedLocaleDao localeDao;
    private AccessPointStatusSummaryDao apSummaryDao;
    private static final ThreadLocal<DateFormat> OUT_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss z");
        }
    };

    public DataBackoutServlet() {
        this.setMode("TEXT");
        this.qDao = new QuestionDao();
        this.localeDao = new SurveyedLocaleDao();
        this.questionSummaryDao = new SurveyQuestionSummaryDao();
        this.instanceDao = new SurveyInstanceDAO();
        this.accessPointDao = new AccessPointDao();
        this.apSummaryDao = new AccessPointStatusSummaryDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataBackoutRequest restRequest = new DataBackoutRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DataBackoutRequest boReq = (DataBackoutRequest)req;
        RestResponse response = new RestResponse();
        if ("getQuestions".equals(boReq.getAction())) {
            response.setMessage(this.listQuestionIds(boReq.getSurveyId()));
        } else if ("deleteQuestionSummary".equals(boReq.getAction())) {
            this.deleteQuestionSummary(boReq.getQuestionId());
        } else if ("listInstance".equals(boReq.getAction())) {
            response.setMessage(this.listSurveyInstance(boReq.getSurveyId(), boReq.includeDate(), boReq.getLastCollection(), boReq.getFromDate(), boReq.getToDate(), boReq.getLimit()));
        } else if ("deleteQuestionAnswer".equals(boReq.getAction())) {
            this.deleteSurveyInstance(boReq.getSurveyInstanceId());
        } else if ("deleteAccessPoint".equals(boReq.getAction())) {
            response.setMessage("" + this.deleteAccessPoint(boReq.getCountryCode(), boReq.getToDate()));
        } else if ("deleteAPSummary".equals(boReq.getAction())) {
            response.setMessage("" + this.deleteAccessPointSummary(boReq.getCountryCode(), boReq.getToDate()));
        } else if ("listInstanceResponse".equals(boReq.getAction())) {
            response.setMessage(this.listResponses(boReq.getSurveyInstanceId()));
        } else if ("listQuestionResponse".equals(boReq.getAction())) {
            response = this.listQuestionResponse(boReq.getQuestionId(), boReq.getCursor());
        }
        return response;
    }

    private QuestionAnswerResponse listQuestionResponse(Long questionId, String cursor) {
        List<QuestionAnswerStore> answers = this.instanceDao.listQuestionAnswerStoreForQuestion(questionId.toString(), cursor);
        return this.convertToAnswerResponse(answers, SurveyInstanceDAO.getCursor(answers));
    }

    private String listResponses(Long surveyInstanceId) {
        List<QuestionAnswerStore> qasList;
        StringBuilder result = new StringBuilder();
        if (surveyInstanceId != null && (qasList = this.instanceDao.listQuestionAnswerStore(surveyInstanceId, null)) != null) {
            boolean isFirst = true;
            for (QuestionAnswerStore qas : qasList) {
                if (!isFirst) {
                    result.append("\n");
                } else {
                    isFirst = false;
                }
                String questionId = qas.getQuestionID();
                Integer iteration = qas.getIteration();
                iteration = iteration == null ? 0 : iteration;
                String value = qas.getValue();
                if (Question.Type.SIGNATURE.toString().equals(qas.getType())) {
                    value = DataUtils.parseSignatory(value);
                }
                value = value == null ? "" : value;
                result.append(questionId).append(",").append(iteration).append(",").append(Base64.encodeBase64URLSafeString((byte[])value.getBytes(StandardCharsets.UTF_8)));
            }
        }
        return result.toString();
    }

    private boolean deleteAccessPointSummary(String country, Date creationDate) {
        boolean hasMore = false;
        List<AccessPointStatusSummary> apList = this.apSummaryDao.listByCountryAndCreationDate(country, creationDate, null);
        if (apList != null) {
            if (apList.size() == 20) {
                hasMore = true;
            }
            this.accessPointDao.delete(apList);
        }
        return hasMore;
    }

    private boolean deleteAccessPoint(String country, Date collectionDateFrom) {
        boolean hasMore = false;
        List<AccessPoint> apList = this.accessPointDao.searchAccessPoints(country, null, collectionDateFrom, null, null, null, null, null, null, null, null, null);
        if (apList != null) {
            if (apList.size() == 20) {
                hasMore = true;
            }
            this.accessPointDao.delete(apList);
        }
        return hasMore;
    }

    private String listSurveyInstance(Long surveyId, boolean includeDate, boolean lastCollection, Date fromDate, Date toDate, Integer limit) {
        boolean keysOnly = true;
        if (includeDate || lastCollection) {
            keysOnly = false;
        }
        Iterable<Entity> instances = this.instanceDao.listRawEntity(keysOnly, fromDate, toDate, limit, surveyId);
        StringBuilder buffer = new StringBuilder();
        ArrayList<Long> processed = new ArrayList<Long>();
        if (instances != null) {
            boolean isFirst = true;
            for (Entity result : instances) {
                if (lastCollection && processed.contains((Long)result.getProperty("surveyedLocaleId"))) continue;
                if (!isFirst) {
                    buffer.append(",");
                } else {
                    isFirst = false;
                }
                buffer.append(result.getKey().getId());
                if (includeDate && result.getProperty("collectionDate") != null) {
                    buffer.append("|").append(OUT_FMT.get().format(result.getProperty("collectionDate")));
                }
                if (!lastCollection) continue;
                processed.add((Long)result.getProperty("surveyedLocaleId"));
            }
        }
        return buffer.toString();
    }

    private void deleteSurveyInstance(Long surveyInstanceId) {
        List<SurveyalValue> vals;
        SurveyInstance instance;
        List<QuestionAnswerStore> questions = this.instanceDao.listQuestionAnswerStore(surveyInstanceId, null);
        if (questions != null) {
            this.instanceDao.delete(questions);
        }
        if ((instance = (SurveyInstance)this.instanceDao.getByKey(surveyInstanceId)) != null) {
            this.instanceDao.delete(instance);
        }
        if ((vals = this.localeDao.listSurveyalValuesByInstance(surveyInstanceId)) != null && vals.size() > 0) {
            Long localeId = vals.get(0).getSurveyedLocaleId();
            this.localeDao.delete(vals);
            List<SurveyalValue> otherVals = this.localeDao.listValuesByLocale(localeId);
            if (otherVals == null || otherVals.size() == 0) {
                SurveyedLocale l = (SurveyedLocale)this.localeDao.getByKey(localeId);
                this.localeDao.delete(l);
            }
        }
    }

    private void deleteQuestionSummary(Long questionId) {
        List<SurveyQuestionSummary> summaries = this.questionSummaryDao.listByQuestion(questionId.toString());
        if (summaries != null) {
            this.questionSummaryDao.delete(summaries);
        }
    }

    private String listQuestionIds(Long surveyId) {
        List<Question> questions = this.qDao.listQuestionsBySurvey(surveyId);
        StringBuilder buffer = new StringBuilder();
        if (questions != null) {
            boolean isFirst = true;
            for (Question q : questions) {
                if (!isFirst) {
                    buffer.append(",");
                } else {
                    isFirst = false;
                }
                buffer.append(q.getKey().getId());
            }
        }
        return buffer.toString();
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        if (resp instanceof QuestionAnswerResponse) {
            QuestionAnswerResponse ansResponse = (QuestionAnswerResponse)resp;
            JSONObject result = new JSONObject((Object)ansResponse);
            this.getResponse().getWriter().println(result.toString());
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }

    protected QuestionAnswerResponse convertToAnswerResponse(List<QuestionAnswerStore> answerList, String cursor) {
        QuestionAnswerResponse resp = new QuestionAnswerResponse();
        if (answerList != null) {
            ArrayList<QuestionAnswerStoreDto> dtoList = new ArrayList<QuestionAnswerStoreDto>();
            for (QuestionAnswerStore ans : answerList) {
                QuestionAnswerStoreDto qasDto = new QuestionAnswerStoreDto();
                DtoMarshaller.copyToDto(ans, qasDto);
                dtoList.add(qasDto);
            }
            resp.setAnswers(dtoList);
        }
        resp.setCursor(cursor);
        return resp;
    }
}

