/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceFileJobQueue;
import com.gallatinsystems.messaging.dao.MessageDao;
import com.gallatinsystems.messaging.domain.Message;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ProcessorServlet
extends HttpServlet {
    private static final long serialVersionUID = -7062679258542909086L;
    private static final Logger log = Logger.getLogger(ProcessorServlet.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("action") == null) {
            log.info("No action specified for processor");
            return;
        }
        String action = StringUtils.trim((String)req.getParameter("action"));
        String fileName = StringUtils.trim((String)req.getParameter("fileName"));
        String phoneNumber = StringUtils.trim((String)req.getParameter("phoneNumber"));
        String androidId = StringUtils.trim((String)req.getParameter("androidId"));
        String imei = StringUtils.trim((String)req.getParameter("imei"));
        String checksum = StringUtils.trim((String)req.getParameter("checksum"));
        log.info("\tProcessorServlet->action->" + action);
        if (action.equals("submit")) {
            SurveyDAO surveyDAO;
            if (fileName == null) {
                log.info("Request for processing without filename: phoneNumber=(" + phoneNumber + "); IMEI=(" + imei + ")");
                resp.setStatus(400);
                return;
            }
            Long formID = this.parseFormID(req);
            if (formID != null && (surveyDAO = new SurveyDAO()).getById(formID) == null) {
                log.warning("Form " + formID + " doesn't exist in the datastore");
                resp.setStatus(404);
                return;
            }
            log.info("  ProcessorServlet->filename->" + fileName);
            log.info("about to submit task for fileName: " + fileName);
            Queue queue = QueueFactory.getDefaultQueue();
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/task").param("action", "processFile").param("fileName", fileName);
            if (androidId != null) {
                options.param("androidId", androidId);
            }
            if (phoneNumber != null) {
                options.param("phoneNumber", phoneNumber);
            }
            if (imei != null) {
                options.param("imei", imei);
            }
            if (checksum != null) {
                options.param("checksum", checksum);
            }
            queue.add(options);
            log.info("submiting task for fileName: " + fileName);
        } else if (action.equals("image")) {
            Device d = null;
            DeviceDAO dao = new DeviceDAO();
            d = dao.getDevice(androidId, imei, phoneNumber);
            if (d == null) {
                log.severe(String.format("No device found with imei %s or phoneNumber %s", imei, phoneNumber));
                return;
            }
            DeviceFileJobQueueDAO dfDao = new DeviceFileJobQueueDAO();
            List<DeviceFileJobQueue> missing = dfDao.listByDeviceAndFile(d.getKey().getId(), fileName);
            log.info(String.format("Deleting %s entities matching the fileName %s", missing.size(), fileName));
            dfDao.delete(missing);
        } else if (action.equals("cascade")) {
            Long crId = null;
            String status = req.getParameter("status");
            CascadeResourceDao crDao = new CascadeResourceDao();
            try {
                crId = Long.valueOf(req.getParameter("cascadeResourceId"));
            }
            catch (NumberFormatException missing) {
                // empty catch block
            }
            if (crId == null || status == null) {
                return;
            }
            CascadeResource cr = (CascadeResource)crDao.getByKey(crId);
            if (cr == null) {
                return;
            }
            MessageDao mDao = new MessageDao();
            Message m = new Message();
            m.setActionAbout("cascadePublish");
            if ("published".equals(status)) {
                cr.setStatus(CascadeResource.Status.PUBLISHED);
                cr.setVersion(cr.getVersion() + 1);
                m.setShortMessage("Cascade resource " + cr.getName() + " successfully published");
            } else {
                cr.setStatus(CascadeResource.Status.NOT_PUBLISHED);
                m.setShortMessage("Failed to publish cascade resource " + cr.getName());
            }
            crDao.save(cr);
            mDao.save(m);
        }
    }

    private Long parseFormID(HttpServletRequest req) {
        String formID = StringUtils.trim((String)req.getParameter("formID"));
        if (StringUtils.isNotBlank((String)formID)) {
            try {
                return Long.valueOf(formID);
            }
            catch (NumberFormatException e) {
                log.warning("Form ID is not a valid number: " + formID);
            }
        }
        return null;
    }
}

