/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.dao.DeviceGroupDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.device.DeviceDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.DevicePayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/devices"})
public class DeviceRestService {
    private DeviceDAO deviceDao = new DeviceDAO();
    private DeviceGroupDAO deviceGroupDao = new DeviceGroupDAO();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<DeviceDto>> listDevices(@RequestParam(value="ids[]", defaultValue="") Long[] ids) {
        HashMap<String, List<DeviceDto>> response = new HashMap<String, List<DeviceDto>>();
        ArrayList<DeviceDto> deviceList = new ArrayList<DeviceDto>();
        List devices = null;
        devices = ids[0] == null ? this.deviceDao.list("all") : this.deviceDao.listByKeys(ids);
        if (devices != null) {
            List deviceGroups = this.deviceGroupDao.list("all");
            HashMap<String, String> dgNames = new HashMap<String, String>();
            for (DeviceGroup dg : deviceGroups) {
                dgNames.put(Long.toString(dg.getKey().getId()), dg.getCode());
            }
            for (Device d : devices) {
                DeviceDto deviceDto = new DeviceDto(d);
                String deviceGroupName = "";
                if (d.getDeviceGroup() != null) {
                    deviceGroupName = (String)dgNames.get(d.getDeviceGroup().trim());
                }
                deviceDto.setDeviceGroupName(deviceGroupName);
                deviceDto.setLastPositionDate(d.getLastLocationBeaconTime());
                deviceList.add(deviceDto);
            }
        }
        response.put("devices", deviceList);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, DeviceDto> findDevice(@PathVariable(value="id") Long id) {
        HashMap<String, DeviceDto> response = new HashMap<String, DeviceDto>();
        Device d = (Device)this.deviceDao.getByKey(id);
        DeviceDto deviceDto = null;
        if (d != null) {
            DeviceGroup dg;
            deviceDto = new DeviceDto();
            DtoMarshaller.copyToDto(d, deviceDto);
            deviceDto.setLastPositionDate(d.getLastLocationBeaconTime());
            if (d.getDeviceGroup() != null && d.getDeviceGroup() != "" && (dg = (DeviceGroup)this.deviceGroupDao.getByKey(Long.parseLong(d.getDeviceGroup()))) != null) {
                deviceDto.setDeviceGroupName(dg.getCode());
            }
        }
        response.put("device", deviceDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingDevice(@RequestBody DevicePayload payLoad) {
        Device d;
        Long keyId;
        DeviceDto deviceDto = payLoad.getDevice();
        HashMap<String, Object> response = new HashMap<String, Object>();
        DeviceDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (deviceDto != null && (keyId = deviceDto.getKeyId()) != null && (d = (Device)this.deviceDao.getByKey(keyId)) != null) {
            DeviceGroup dg;
            BeanUtils.copyProperties((Object)deviceDto, (Object)d, (String[])new String[]{"createdDateTime", "lastPositionDate", "deviceGroupName"});
            d = this.deviceDao.save(d);
            dto = new DeviceDto();
            DtoMarshaller.copyToDto(d, dto);
            if (d.getDeviceGroup() != null && d.getDeviceGroup() != "" && (dg = (DeviceGroup)this.deviceGroupDao.getByKey(Long.parseLong(d.getDeviceGroup()))) != null) {
                deviceDto.setDeviceGroupName(dg.getCode());
            }
            dto.setLastPositionDate(d.getLastLocationBeaconTime());
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("device", dto);
        return response;
    }
}

