/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest.security;

import com.gallatinsystems.user.dao.UserDao;
import com.google.appengine.api.users.User;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;
import org.waterforpeople.mapping.app.web.rest.security.GaeUserAuthentication;
import org.waterforpeople.mapping.app.web.rest.security.user.GaeUser;

public class GoogleAccountsAuthenticationProvider
implements AuthenticationProvider,
MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private static final Logger log = Logger.getLogger(GoogleAccountsAuthenticationProvider.class.getName());
    private UserDao userDao = new UserDao();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        User googleUser = (User)authentication.getPrincipal();
        GaeUser user = this.findUser(googleUser.getEmail());
        if (user == null) {
            user = new GaeUser(googleUser.getNickname(), googleUser.getEmail());
        }
        if (!user.isEnabled()) {
            throw new DisabledException("Account is disabled");
        }
        return new GaeUserAuthentication(user, authentication.getDetails());
    }

    private GaeUser findUser(String email) {
        com.gallatinsystems.user.domain.User user = this.userDao.findUserByEmail(email);
        if (user == null) {
            return null;
        }
        int authority = this.getAuthorityLevel(user);
        EnumSet<AppRole> roles = EnumSet.noneOf(AppRole.class);
        if (authority == AppRole.NEW_USER.getLevel()) {
            roles.add(AppRole.NEW_USER);
        } else {
            for (AppRole r : AppRole.values()) {
                if (authority > r.getLevel()) continue;
                roles.add(r);
            }
        }
        return new GaeUser(user.getUserName(), user.getEmailAddress(), user.getKey().getId(), roles, true);
    }

    private int getAuthorityLevel(com.gallatinsystems.user.domain.User user) {
        if (user.isSuperAdmin().booleanValue()) {
            return AppRole.SUPER_ADMIN.getLevel();
        }
        try {
            int level = Integer.parseInt(user.getPermissionList());
            return level;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error getting role level, setting USER role", e);
            return AppRole.USER.getLevel();
        }
    }

    public final boolean supports(Class<?> authentication) {
        return PreAuthenticatedAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }
}

