/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.waterforpeople.mapping.app.web.TestHarnessServlet;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class AccessPointTest {
    private static Logger log = Logger.getLogger(TestHarnessServlet.class.getName());

    public void loadLots(HttpServletResponse resp, Integer numToCreate) {
        try {
            AccessPointHelper aph = new AccessPointHelper();
            ArrayList<AccessPoint> apList = new ArrayList<AccessPoint>();
            for (int j = 0; j < 1; ++j) {
                for (int i = 0; i < numToCreate; ++i) {
                    double lon = -68.1;
                    double lat = -16.4;
                    lon = this.getRandomBoolean().booleanValue() ? (lon += new Random().nextDouble() * (double)new Random().nextInt(10)) : (lon -= new Random().nextDouble() * (double)new Random().nextInt(10));
                    lat = this.getRandomBoolean().booleanValue() ? (lat += new Random().nextDouble() * (double)new Random().nextInt(10)) : (lat -= new Random().nextDouble() * (double)new Random().nextInt(10));
                    GregorianCalendar calendar = new GregorianCalendar(2010, 0, 1);
                    Integer sign = null;
                    sign = new Random().nextInt(3) % 2 == 0 ? Integer.valueOf(-1) : Integer.valueOf(1);
                    ((Calendar)calendar).add(2, sign * new Random().nextInt(100));
                    log.info(i + ":");
                    AccessPoint ap = new AccessPoint();
                    ap.setLatitude(lat);
                    ap.setLongitude(lon);
                    ap.setCountryCode("BO");
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setWhoRepairsPoint("No One");
                    } else {
                        ap.setWhoRepairsPoint("Dru");
                    }
                    System.out.println("AP: " + ap.getLatitude() + "/" + ap.getLongitude() + "Date: " + calendar.getTime());
                    ap.setAltitude(0.0);
                    ap.setCommunityCode("test" + new Date());
                    ap.setCommunityName("test" + new Date());
                    ap.setPhotoURL("http://waterforpeople.s3.amazonaws.com/images/peru/pc28water.jpg");
                    ap.setImprovedWaterPointFlag(this.getRandomBoolean());
                    ap.setProvideAdequateQuantity(this.getRandomBoolean());
                    ap.setHasSystemBeenDown1DayFlag(this.getRandomBoolean());
                    ap.setMeetGovtQualityStandardFlag(this.getRandomBoolean());
                    ap.setMeetGovtQuantityStandardFlag(this.getRandomBoolean());
                    ap.setWaterForPeopleProjectFlag(this.getRandomBoolean());
                    ap.setWaterAvailableDayVisitFlag(this.getRandomBoolean());
                    ap.setEstimatedPeoplePerHouse(new Random().nextLong());
                    ap.setCollectTariffFlag(this.getRandomBoolean());
                    ap.setCurrentManagementStructurePoint("Community Board");
                    ap.setDescription("Waterpoint");
                    ap.setDistrict("test district");
                    ap.setEstimatedHouseholds(new Random().nextLong());
                    ap.setFarthestHouseholdfromPoint("Yes");
                    ap.setNumberOfHouseholdsUsingPoint(new Random().nextLong());
                    Integer year = new Random().nextInt(2011);
                    ap.setConstructionDateYear(year.toString());
                    ap.setCostPer(1.0);
                    ap.setCollectionDate(calendar.getTime());
                    ((Calendar)calendar).add(1, -5);
                    ap.setConstructionDate(calendar.getTime());
                    ap.setPhotoName("Water point");
                    ap.setNumberOfHouseholdsUsingPoint(new Random().nextLong());
                    ap.setProvideAdequateQuantity(this.getRandomBoolean());
                    ap.setPpmFecalColiform(new Random().nextDouble());
                    ap.setNumberOfLitersPerPersonPerDay(new Random().nextInt());
                    ap.setExtimatedPopulation(new Random().nextLong());
                    ap.setPositiveBalance(this.getRandomBoolean());
                    ap.setFinancialRecordsAvailableDayOfVisitFlag(this.getRandomBoolean());
                    ap.setSparePartsOnHand(this.getRandomBoolean());
                    ap.setLocalSparePartsFlag(this.getRandomBoolean());
                    AccessPoint.LocationType locationType = null;
                    Integer locationRandom = new Random().nextInt(3);
                    ap.setSystemExpansion("Yes");
                    locationType = locationRandom == 3 ? AccessPoint.LocationType.PERIURBAN : (locationRandom == 1 ? AccessPoint.LocationType.RURAL : (locationRandom == 0 ? AccessPoint.LocationType.URBAN : AccessPoint.LocationType.OTHER));
                    ap.setLocationType(locationType);
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setCurrentProblem("Yes");
                    }
                    ap.setPointType(AccessPoint.AccessPointType.WATER_POINT);
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setTypeTechnologyString("Kiosk");
                    } else {
                        ap.setTypeTechnologyString("Afridev Handpump");
                    }
                    apList.add(ap);
                    if (i % 50 == 0) {
                        log.log(Level.INFO, "Loaded to " + i);
                    }
                    aph.saveAccessPoint(ap);
                }
                resp.getWriter().println("About to save APs");
                resp.getWriter().println("Finished saving APs");
            }
            resp.getWriter().println("Finished loading APs");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Boolean getRandomBoolean() {
        Integer seed = new Random().nextInt(2);
        if (seed == 0) {
            return false;
        }
        return true;
    }

    public void loadWPDistanceTestData(HttpServletResponse resp) {
        try {
            AccessPointHelper aph = new AccessPointHelper();
            ArrayList<AccessPoint> apList = new ArrayList<AccessPoint>();
            for (int j = 0; j < 1; ++j) {
                for (int i = 0; i < 100; ++i) {
                    double lon = 35.0 + new Random().nextDouble() / (double)new Random().nextInt(10);
                    double lat = -15.0 + new Random().nextDouble() / (double)new Random().nextInt(10);
                    lon = this.getRandomBoolean().booleanValue() ? (lon += new Random().nextDouble() * (double)new Random().nextInt(10)) : (lon -= new Random().nextDouble() * (double)new Random().nextInt(10));
                    lat = this.getRandomBoolean().booleanValue() ? (lat += new Random().nextDouble() * (double)new Random().nextInt(10)) : (lat -= new Random().nextDouble() * (double)new Random().nextInt(10));
                    GregorianCalendar calendar = new GregorianCalendar(2010, 0, 1);
                    Integer sign = null;
                    sign = new Random().nextInt(3) % 2 == 0 ? Integer.valueOf(-1) : Integer.valueOf(1);
                    ((Calendar)calendar).add(2, sign * new Random().nextInt(100));
                    log.info(i + ":");
                    AccessPoint ap = new AccessPoint();
                    ap.setLatitude(lat);
                    ap.setLongitude(lon);
                    ap.setCountryCode("US");
                    System.out.println("AP: " + ap.getLatitude() + "/" + ap.getLongitude() + "Date: " + calendar.getTime());
                    ap.setAltitude(0.0);
                    ap.setCommunityCode(String.valueOf(i));
                    ap.setCommunityName(String.valueOf(i));
                    ap.setPhotoURL("http://waterforpeople.s3.amazonaws.com/images/peru/pc28water.jpg");
                    ap.setImprovedWaterPointFlag(this.getRandomBoolean());
                    ap.setProvideAdequateQuantity(this.getRandomBoolean());
                    ap.setHasSystemBeenDown1DayFlag(this.getRandomBoolean());
                    ap.setMeetGovtQualityStandardFlag(this.getRandomBoolean());
                    ap.setMeetGovtQuantityStandardFlag(this.getRandomBoolean());
                    ap.setWaterForPeopleProjectFlag(this.getRandomBoolean());
                    ap.setWaterAvailableDayVisitFlag(this.getRandomBoolean());
                    ap.setEstimatedPeoplePerHouse(new Random().nextLong());
                    ap.setCollectTariffFlag(this.getRandomBoolean());
                    ap.setCurrentManagementStructurePoint("Community Board");
                    ap.setDescription("Waterpoint");
                    ap.setDistrict("test district");
                    ap.setEstimatedHouseholds(new Random().nextLong());
                    ap.setFarthestHouseholdfromPoint("Yes");
                    ap.setNumberOfHouseholdsUsingPoint(new Random().nextLong());
                    Integer year = new Random().nextInt(2011);
                    ap.setConstructionDateYear(year.toString());
                    ap.setCostPer(1.0);
                    ap.setCollectionDate(calendar.getTime());
                    ((Calendar)calendar).add(1, -5);
                    ap.setConstructionDate(calendar.getTime());
                    ap.setPhotoName("Water point");
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setCurrentProblem("Yes");
                    }
                    ap.setPointType(AccessPoint.AccessPointType.WATER_POINT);
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setTypeTechnologyString("Kiosk");
                    } else {
                        ap.setTypeTechnologyString("Afridev Handpump");
                    }
                    apList.add(ap);
                    if (i % 50 == 0) {
                        log.log(Level.INFO, "Loaded to " + i);
                    }
                    aph.saveAccessPoint(ap);
                }
                resp.getWriter().println("Finished saving APs");
            }
            resp.getWriter().println("Finished loading APs");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadHHDistanceTestData(HttpServletResponse resp) {
        try {
            AccessPointHelper aph = new AccessPointHelper();
            ArrayList<AccessPoint> apList = new ArrayList<AccessPoint>();
            for (int j = 0; j < 1; ++j) {
                for (int i = 0; i < 100; ++i) {
                    double lon = 35.0 + new Random().nextDouble() / (double)new Random().nextInt(10);
                    double lat = -15.0 + new Random().nextDouble() / (double)new Random().nextInt(10);
                    lon = this.getRandomBoolean().booleanValue() ? (lon += new Random().nextDouble() * (double)new Random().nextInt(10)) : (lon -= new Random().nextDouble() * (double)new Random().nextInt(10));
                    lat = this.getRandomBoolean().booleanValue() ? (lat += new Random().nextDouble() * (double)new Random().nextInt(10)) : (lat -= new Random().nextDouble() * (double)new Random().nextInt(10));
                    GregorianCalendar calendar = new GregorianCalendar(2010, 0, 1);
                    Integer sign = null;
                    sign = new Random().nextInt(3) % 2 == 0 ? Integer.valueOf(-1) : Integer.valueOf(1);
                    ((Calendar)calendar).add(2, sign * new Random().nextInt(100));
                    log.info(i + ":");
                    AccessPoint ap = new AccessPoint();
                    ap.setLatitude(lat);
                    ap.setLongitude(lon);
                    ap.setCountryCode("US");
                    System.out.println("AP: " + ap.getLatitude() + "/" + ap.getLongitude() + "Date: " + calendar.getTime());
                    ap.setAltitude(0.0);
                    ap.setCommunityCode(String.valueOf(i));
                    ap.setCommunityName(String.valueOf(i));
                    ap.setPhotoURL("http://waterforpeople.s3.amazonaws.com/images/peru/pc28water.jpg");
                    ap.setImprovedWaterPointFlag(this.getRandomBoolean());
                    ap.setProvideAdequateQuantity(this.getRandomBoolean());
                    ap.setHasSystemBeenDown1DayFlag(this.getRandomBoolean());
                    ap.setMeetGovtQualityStandardFlag(this.getRandomBoolean());
                    ap.setMeetGovtQuantityStandardFlag(this.getRandomBoolean());
                    ap.setWaterForPeopleProjectFlag(this.getRandomBoolean());
                    ap.setWaterAvailableDayVisitFlag(this.getRandomBoolean());
                    ap.setEstimatedPeoplePerHouse(new Random().nextLong());
                    ap.setExtimatedPopulation(new Random().nextLong());
                    ap.setCollectTariffFlag(this.getRandomBoolean());
                    ap.setCurrentManagementStructurePoint("Community Board");
                    ap.setDescription("Household");
                    ap.setDistrict("test district");
                    ap.setEstimatedHouseholds(new Random().nextLong());
                    ap.setFarthestHouseholdfromPoint("Yes");
                    Integer year = new Random().nextInt(2011);
                    ap.setConstructionDateYear(year.toString());
                    ap.setCostPer(1.0);
                    ap.setCollectionDate(calendar.getTime());
                    ((Calendar)calendar).add(1, -5);
                    ap.setConstructionDate(calendar.getTime());
                    ap.setPhotoName("Water point");
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setCurrentProblem("Yes");
                    }
                    ap.setPointType(AccessPoint.AccessPointType.HOUSEHOLD);
                    if (this.getRandomBoolean().booleanValue()) {
                        ap.setTypeTechnologyString("Kiosk");
                    } else {
                        ap.setTypeTechnologyString("Afridev Handpump");
                    }
                    apList.add(ap);
                    if (i % 50 == 0) {
                        log.log(Level.INFO, "Loaded to " + i);
                    }
                    aph.saveAccessPoint(ap);
                }
                resp.getWriter().println("Finished saving APs");
            }
            resp.getWriter().println("Finished loading APs");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

