/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.helper;

import com.gallatinsystems.common.util.StringUtil;
import com.gallatinsystems.standards.dao.CompoundStandardDao;
import com.gallatinsystems.standards.dao.StandardDao;
import com.gallatinsystems.standards.domain.CompoundStandard;
import com.gallatinsystems.standards.domain.LevelOfServiceScore;
import com.gallatinsystems.standards.domain.Standard;
import com.gallatinsystems.standards.domain.StandardDef;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.waterforpeople.mapping.domain.AccessPoint;

public class ScoringHelper {
    private static Logger log = Logger.getLogger(ScoringHelper.class.getName());

    public LevelOfServiceScore scoreWaterPointByLevelOfService(AccessPoint ap, Standard.StandardType scoreType) {
        LevelOfServiceScore los = new LevelOfServiceScore();
        los.setScoreType(scoreType);
        los.setObjectKey(ap.getKey());
        los.setScoreObject(LevelOfServiceScore.ScoreObject.AccessPoint);
        if (ap.getImprovedWaterPointFlag().booleanValue()) {
            ScoreDetailContainer sdc = this.scoreStandard(ap, scoreType);
            los.setScore(sdc.getScore());
            if (sdc.getDetails() != null) {
                los.setScoreDetails(sdc.getDetails());
            }
            sdc = this.scoreCompound(ap, scoreType);
            los.setScore(los.getScore() + sdc.getScore());
            if (los.getScoreDetails() != null && sdc.getDetails() != null) {
                ArrayList<String> temp = los.getScoreDetails();
                temp.addAll(sdc.getDetails());
                los.setScoreDetails(temp);
            }
        } else {
            los.setScore(0);
            los.addScoreDetail("0 not improved waterpoint");
        }
        return los;
    }

    private ScoreDetailContainer scoreCompound(AccessPoint ap, Standard.StandardType scoreType) {
        ScoreDetailContainer sdc = new ScoreDetailContainer();
        CompoundStandardDao csdao = new CompoundStandardDao();
        List<CompoundStandard> csList = csdao.listByType(scoreType);
        for (CompoundStandard item : csList) {
            StandardDef left = item.getStandardLeft();
            StandardDef right = item.getStandardRight();
            ScoreDetailContainer sdcLeft = this.processStandard(left, ap);
            ScoreDetailContainer sdcRight = this.processStandard(right, ap);
            if (item.getOperator().equals((Object)CompoundStandard.Operator.AND)) {
                if (sdcLeft.getScore().equals(1) && sdcRight.getScore().equals(1)) {
                    sdc.setScore(sdc.getScore() + 1);
                    sdc.add("Plus 1 for compound rule" + item.toString());
                    continue;
                }
                sdc.setScore(sdc.getScore() + 0);
                sdc.add("Plus 0 for compound Rule: " + item.toString());
                continue;
            }
            if (!item.getOperator().equals((Object)CompoundStandard.Operator.OR)) continue;
            if (sdcLeft.getScore().equals(1) || sdcRight.getScore().equals(1)) {
                sdc.setScore(sdc.getScore() + 1);
                sdc.add("Plus 1 for compound rule");
                continue;
            }
            sdc.setScore(sdc.getScore() + 0);
            sdc.add("Plus 0 for compound Rule: " + item);
        }
        return sdc;
    }

    private String formScoreDetailMessage(Integer score, String desc, String type, String attribute, String value, String operator, String compareTo) {
        return "Plus " + score + " for " + desc + " " + type + " " + attribute + " Value " + value + " " + operator + " " + compareTo;
    }

    public void scoreWaterPointSustainability(AccessPoint ap) {
    }

    public void scorePILevelOfService(AccessPoint ap) {
    }

    public void scorePISustainability(AccessPoint ap) {
    }

    private String getAccessPointFieldValue(AccessPoint ap, String accessPointAttribute) {
        String value = null;
        try {
            Method m = AccessPoint.class.getMethod("get" + StringUtil.capitalizeFirstCharacterString(accessPointAttribute), null);
            value = !m.getReturnType().getName().equals("java.lang.String") ? m.invoke((Object)ap, (Object[])null).toString() : (String)m.invoke((Object)ap, (Object[])null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            log.info("AccessPoint Attribute: " + accessPointAttribute);
            e.printStackTrace();
            return null;
        }
        return value;
    }

    private Boolean compareBoolean(String uncastvalue, Boolean compareTo) {
        Boolean answer = null;
        Boolean value = Boolean.parseBoolean(uncastvalue);
        answer = value.equals(compareTo) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return answer;
    }

    public static void main(String[] args) {
    }

    private Boolean compareStrings(String apvalue, ArrayList<String> valueList, Standard.StandardComparisons operator) {
        if (operator.equals((Object)Standard.StandardComparisons.equal)) {
            for (String item : valueList) {
                if (!item.trim().equalsIgnoreCase(apvalue.trim())) continue;
                return true;
            }
            return false;
        }
        if (operator.equals((Object)Standard.StandardComparisons.notequal)) {
            for (String item : valueList) {
                if (!item.trim().equalsIgnoreCase(apvalue.trim())) continue;
                return false;
            }
            return true;
        }
        log.warning("Operator " + (Object)((Object)operator) + " not implemented for a string in a list of strings (returning false)");
        return false;
    }

    private Boolean compareDouble(Standard.StandardComparisons standardComparisons, String apvalue, Double compareTo) {
        Boolean answer = false;
        if (standardComparisons.equals((Object)Standard.StandardComparisons.lessthan)) {
            if (Double.parseDouble(apvalue) < compareTo) {
                answer = true;
            }
        } else if (standardComparisons.equals((Object)Standard.StandardComparisons.lessthanorequal)) {
            if (Double.parseDouble(apvalue) <= compareTo) {
                answer = true;
            }
        } else if (standardComparisons.equals((Object)Standard.StandardComparisons.greaterthan)) {
            if (Double.parseDouble(apvalue) > compareTo) {
                answer = true;
            }
        } else if (standardComparisons.equals((Object)Standard.StandardComparisons.greaterthanorequal)) {
            if (Double.parseDouble(apvalue) >= compareTo) {
                answer = true;
            }
        } else if (standardComparisons.equals((Object)Standard.StandardComparisons.equal) && Double.parseDouble(apvalue) == compareTo) {
            answer = true;
        }
        return answer;
    }

    private ScoreDetailContainer scoreStandard(AccessPoint ap, Standard.StandardType scoreType) {
        ArrayList<String> scoreDetails = new ArrayList<String>();
        Integer score = 0;
        ScoreDetailContainer sdc = new ScoreDetailContainer();
        StandardDao standardDao = new StandardDao();
        List<Standard> standardList = standardDao.listByAccessPointTypeAndStandardType(AccessPoint.AccessPointType.WATER_POINT, scoreType);
        if (standardList != null) {
            for (Standard standard : standardList) {
                sdc = this.processStandard(standard, ap);
                score = score + sdc.getScore();
                scoreDetails.addAll(sdc.getDetails());
            }
            sdc.setDetails(scoreDetails);
            sdc.setScore(score);
            return sdc;
        }
        return null;
    }

    private ScoreDetailContainer processStandard(StandardDef standard, AccessPoint ap) {
        ScoreDetailContainer sdc = new ScoreDetailContainer();
        if (standard.getStandardScope().equals((Object)Standard.StandardScope.Global) || standard.getStandardScope().equals((Object)Standard.StandardScope.Local) && ((Standard)standard).getCountry().equals(ap.getCountryCode())) {
            String value = this.getAccessPointFieldValue(ap, ((Standard)standard).getAccessPointAttribute());
            if (value == null) {
                sdc.add("Could not score attribute " + ((Standard)standard).getAccessPointAttribute());
                sdc.setScore(0);
            }
            if (((Standard)standard).getAcessPointAttributeType().equals((Object)Standard.StandardValueType.Boolean)) {
                sdc = this.scoreBoolean((Standard)standard, value);
            } else if (((Standard)standard).getAcessPointAttributeType().equals((Object)Standard.StandardValueType.String)) {
                sdc = this.scoreString((Standard)standard, value);
            } else if (((Standard)standard).getAcessPointAttributeType().equals((Object)Standard.StandardValueType.Number)) {
                sdc = this.scoreDouble((Standard)standard, value);
            }
        }
        return sdc;
    }

    private ScoreDetailContainer scoreBoolean(Standard standard, String value) {
        ScoreDetailContainer sdc = new ScoreDetailContainer();
        if (standard.getAcessPointAttributeType().equals((Object)Standard.StandardValueType.Boolean)) {
            if (this.compareBoolean(value, Boolean.parseBoolean(standard.getPositiveValues().get(0))).booleanValue()) {
                sdc.setScore(sdc.getScore() + 1);
                sdc.add(this.formScoreDetailMessage(1, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), value, standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
            } else {
                sdc.setScore(sdc.getScore() + 1);
                sdc.add(this.formScoreDetailMessage(0, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), value, standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
            }
        }
        return sdc;
    }

    private ScoreDetailContainer scoreString(Standard standard, String value) {
        ScoreDetailContainer sdc = new ScoreDetailContainer();
        if (standard.getAcessPointAttributeType().equals((Object)Standard.StandardValueType.String) && value != null) {
            if (this.compareStrings(value, standard.getPositiveValues(), standard.getStandardComparison()).booleanValue()) {
                sdc.setScore(sdc.getScore() + 1);
                sdc.add(this.formScoreDetailMessage(1, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), value, standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
            } else {
                sdc.setScore(sdc.getScore() + 0);
                sdc.add(this.formScoreDetailMessage(0, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), value, standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
            }
        } else {
            sdc.setScore(sdc.getScore() + 0);
            sdc.add(this.formScoreDetailMessage(0, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), "Null", standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
        }
        return sdc;
    }

    private ScoreDetailContainer scoreDouble(Standard standard, String value) {
        ScoreDetailContainer sdc = new ScoreDetailContainer();
        if (this.compareDouble(standard.getStandardComparison(), value, Double.parseDouble(standard.getPositiveValues().get(0))).booleanValue()) {
            sdc.setScore(sdc.getScore() + 1);
            sdc.add(this.formScoreDetailMessage(1, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), value, standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
        } else {
            sdc.setScore(sdc.getScore() + 0);
            sdc.add(this.formScoreDetailMessage(0, standard.getStandardDescription(), " WaterPoint ", standard.getAccessPointAttribute(), value, standard.getStandardComparison().toString(), standard.getPositiveValues().toString()));
        }
        return sdc;
    }

    private class ScoreDetailContainer {
        private Integer score = 0;
        private ArrayList<String> details = null;

        private ScoreDetailContainer() {
        }

        public Integer getScore() {
            return this.score;
        }

        public void setScore(Integer score) {
            this.score = score;
        }

        public ArrayList<String> getDetails() {
            return this.details;
        }

        public void setDetails(ArrayList<String> details) {
            this.details = details;
        }

        public void add(String message) {
            if (this.details == null) {
                this.details = new ArrayList();
            }
            this.details.add(message);
        }
    }
}

