/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.helper;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.waterforpeople.mapping.dao.GeoIndexDao;
import org.waterforpeople.mapping.domain.AccessPoint;

public class MappingSummarizationHelper {
    private BaseDAO<AccessPoint> accessPointDao = new BaseDAO<AccessPoint>(AccessPoint.class);
    private GeoIndexDao geoIndexDao = new GeoIndexDao();
    private Map<String, StringBuilder> regionMap;
    private Map<String, String> firstPositionInPolys;

    public void addPointToRegion(String uuid, String lat, String lon) {
        StringBuilder buf;
        if (this.regionMap == null) {
            this.resetPoly();
        }
        if ((buf = this.regionMap.get(uuid)) == null) {
            buf = new StringBuilder();
            buf.append(lat + " " + lon);
            this.regionMap.put(uuid, buf);
            this.firstPositionInPolys.put(uuid, lat + " " + lon);
        } else {
            buf.append("," + lat + " " + lon);
        }
    }

    public void saveRegions() {
        if (this.regionMap != null) {
            GeoIndexDao indexDao = new GeoIndexDao();
            HashMap<String, String> regionStrings = new HashMap<String, String>();
            for (String region : this.regionMap.keySet()) {
                regionStrings.put(region, "POLYGON((" + this.regionMap.get(region) + "," + this.firstPositionInPolys.get(region) + "))");
            }
            indexDao.saveRegionIndex(regionStrings);
            this.resetPoly();
        }
    }

    public void resetPoly() {
        this.regionMap = new HashMap<String, StringBuilder>();
        this.firstPositionInPolys = new HashMap<String, String>();
    }

    public String processSummarization(String regionUUID, String type) {
        String result = null;
        List<AccessPoint> accessPoints = this.findPointsInRegion(regionUUID);
        if (accessPoints != null && accessPoints.size() > 0) {
            int functionalCount = 0;
            for (AccessPoint ap : accessPoints) {
                if (AccessPoint.Status.FUNCTIONING_HIGH != ap.getPointStatus()) continue;
                ++functionalCount;
            }
            double pctFunctional = functionalCount / accessPoints.size();
            result = pctFunctional >= 0.75 ? "GREEN" : (pctFunctional >= 0.5 ? "YELLOW" : "RED");
        }
        return result;
    }

    public List<AccessPoint> findPointsInRegion(String regionUUID) {
        STRtree regionIndex = this.geoIndexDao.findGeoIndex(regionUUID);
        List<AccessPoint> accessPoints = this.accessPointDao.list("all");
        ArrayList<AccessPoint> pointsInRegion = new ArrayList<AccessPoint>();
        if (accessPoints != null && regionIndex != null) {
            GeometryFactory geomFactory = new GeometryFactory();
            for (AccessPoint p : accessPoints) {
                Point point = geomFactory.createPoint(new Coordinate(p.getLatitude().doubleValue(), p.getLongitude().doubleValue()));
                if (regionIndex.query(point.getEnvelopeInternal()).isEmpty()) continue;
                pointsInRegion.add(p);
            }
        }
        return pointsInRegion;
    }
}

