/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.gis.location.GeoLocationService;
import com.gallatinsystems.gis.location.GeoLocationServiceGeonamesImpl;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.gwt.client.location.PointOfInterestDto;
import org.waterforpeople.mapping.app.web.dto.PointOfInterestRequest;
import org.waterforpeople.mapping.app.web.dto.PointOfInterestResponse;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.domain.AccessPoint;

public class PointOfInterestServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 8748650927754433019L;
    private static final int MAX_DISTANCE_METERS = 10000;
    private AccessPointDao accessPointDao;
    private GeoLocationService geoService;

    public PointOfInterestServlet() {
        this.setMode("JSON");
        this.accessPointDao = new AccessPointDao();
        this.geoService = new GeoLocationServiceGeonamesImpl();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        PointOfInterestRequest restRequest = new PointOfInterestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        PointOfInterestRequest piReq = (PointOfInterestRequest)req;
        List<AccessPoint> results = this.accessPointDao.listNearbyAccessPoints(piReq.getLat(), piReq.getLon(), piReq.getCountry() != null ? piReq.getCountry() : this.geoService.getCountryCodeForPoint(piReq.getLat().toString(), piReq.getLon().toString()), 10000.0, piReq.getCursor());
        return this.convertToResponse(results, AccessPointDao.getCursor(results));
    }

    protected PointOfInterestResponse convertToResponse(List<AccessPoint> apList, String cursor) {
        PointOfInterestResponse resp = new PointOfInterestResponse();
        if (apList != null) {
            ArrayList<PointOfInterestDto> dtoList = new ArrayList<PointOfInterestDto>();
            for (AccessPoint ap : apList) {
                PointOfInterestDto dto = new PointOfInterestDto();
                dto.setId(ap.getKey().getId());
                dto.setName(ap.getCommunityCode());
                dto.setType(ap.getPointType() != null ? ap.getPointType().toString() : "AccessPoint");
                dto.setLatitude(ap.getLatitude());
                dto.setLongitude(ap.getLongitude());
                dto.setCountry(ap.getCountryCode());
                dto.addProperty("status", ap.getPointStatus() != null ? ap.getPointStatus().toString() : "unknown");
                dtoList.add(dto);
            }
            resp.setPointsOfInterest(dtoList);
        }
        resp.setCursor(cursor);
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        PointOfInterestResponse piResp = (PointOfInterestResponse)resp;
        JSONObject result = new JSONObject((Object)piResp);
        JSONArray arr = result.getJSONArray("pointsOfInterest");
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                ((JSONObject)arr.get(i)).put("propertyValues", piResp.getPointsOfInterest().get(i).getPropertyValues());
                ((JSONObject)arr.get(i)).put("propertyNames", piResp.getPointsOfInterest().get(i).getPropertyNames());
            }
        }
        this.getResponse().getWriter().println(result.toString());
    }
}

