/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest.dto;

import com.gallatinsystems.framework.gwt.dto.client.BaseDto;
import com.gallatinsystems.user.domain.UserAuthorization;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.springframework.security.core.context.SecurityContextHolder;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;

public class UserAuthorizationPayload
extends BaseDto {
    private static final long serialVersionUID = -2483907342483369954L;
    private UserAuthorization userAuthorization;

    public UserAuthorizationPayload(UserAuthorization userAuthorization) {
        this.userAuthorization = userAuthorization;
        if (userAuthorization.getKey() != null) {
            this.setKeyId(userAuthorization.getKey().getId());
        }
    }

    public UserAuthorizationPayload() {
        this.userAuthorization = new UserAuthorization();
    }

    public Long getUserId() {
        return this.userAuthorization.getUserId();
    }

    public void setUserId(Long userId) {
        if (userId == null) {
            throw new IllegalArgumentException("Invalid userId (" + userId + ")");
        }
        this.userAuthorization.setUserId(userId);
    }

    public Long getRoleId() {
        return this.userAuthorization.getRoleId();
    }

    public void setRoleId(Long roleId) {
        if (roleId == null) {
            throw new IllegalArgumentException("Invalid roleId (" + roleId + ")");
        }
        this.userAuthorization.setRoleId(roleId);
    }

    public String getObjectPath() {
        return this.userAuthorization.getObjectPath();
    }

    public void setObjectPath(String objectPath) {
        if (!this.isAcceptablePath(objectPath)) {
            throw new IllegalArgumentException("The specified path is not acceptable (" + objectPath + ")");
        }
        this.userAuthorization.setObjectPath(objectPath);
    }

    public Long getSecuredObjectId() {
        return this.userAuthorization.getSecuredObjectId();
    }

    public void setSecuredObjectId(Long objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Invalid objectId (" + objectId + ")");
        }
        this.userAuthorization.setSecuredObjectId(objectId);
    }

    private boolean isAcceptablePath(String objectPath) {
        if (StringUtils.isNotBlank((String)objectPath)) {
            if ("/".equals(objectPath)) {
                Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
                return authorities.contains((Object)AppRole.SUPER_ADMIN) || authorities.contains((Object)AppRole.ADMIN);
            }
            return true;
        }
        return false;
    }

    @JsonIgnore
    public UserAuthorization getUserAuthorisation() {
        return this.userAuthorization;
    }
}

