/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics;

import com.gallatinsystems.common.util.DateUtil;
import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.framework.domain.DataChangeRecord;
import java.util.logging.Logger;
import org.waterforpeople.mapping.analytics.AccessPointUpdater;
import org.waterforpeople.mapping.analytics.dao.AccessPointStatusSummaryDao;
import org.waterforpeople.mapping.domain.AccessPoint;

public class AccessPointStatusUpdater
implements DataSummarizer {
    private static Logger logger = Logger.getLogger(AccessPointUpdater.class.getName());

    @Override
    public String getCursor() {
        return null;
    }

    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        DataChangeRecord change = new DataChangeRecord(value);
        AccessPoint oldPoint = this.hydratePoint(change.getOldVal());
        AccessPoint newPoint = this.hydratePoint(change.getNewVal());
        AccessPointStatusSummaryDao.incrementCount(oldPoint, null, -1);
        AccessPointStatusSummaryDao.incrementCount(newPoint, null, 1);
        return true;
    }

    private AccessPoint hydratePoint(String packedString) {
        String[] vals = packedString.split("\\|");
        AccessPoint point = null;
        if (vals.length == 5) {
            point = new AccessPoint();
            point.setCountryCode(vals[0]);
            point.setCommunityCode(vals[1]);
            try {
                point.setPointType(AccessPoint.AccessPointType.valueOf(vals[2]));
            }
            catch (Throwable e) {
                logger.warning("unknown type value: " + vals[2]);
            }
            try {
                point.setPointStatus(AccessPoint.Status.valueOf(vals[3]));
            }
            catch (Throwable e) {
                logger.warning("unknown status value: " + vals[3]);
            }
            try {
                point.setCollectionDate(DateUtil.getYearOnlyDate(vals[4]));
            }
            catch (Throwable e) {
                logger.warning("bad date value: " + vals[4]);
            }
        }
        return point;
    }
}

