/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics.dao;

import com.gallatinsystems.common.util.DateUtil;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.waterforpeople.mapping.analytics.domain.SurveyInstanceSummary;

public class SurveyInstanceSummaryDao
extends BaseDAO<SurveyInstanceSummary> {
    public SurveyInstanceSummaryDao() {
        super(SurveyInstanceSummary.class);
    }

    public static synchronized void incrementCount(String community, String country, Date collectionDate, int delta) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyInstanceSummary.class);
        Date colDate = DateUtil.getDateNoTime(collectionDate);
        query.setFilter("countryCode == countryCodeParam && communityCode == communityCodeParam && collectionDate == collectionDateParam");
        query.declareParameters("String countryCodeParam, String communityCodeParam, Date collectionDateParam");
        query.declareImports("import java.util.Date");
        List results = (List)query.execute((Object)country, (Object)community, (Object)colDate);
        SurveyInstanceSummary summary = null;
        SurveyInstanceSummaryDao thisDao = new SurveyInstanceSummaryDao();
        if (results == null || results.size() == 0) {
            summary = new SurveyInstanceSummary();
            summary.setCount(1L);
            summary.setCommunityCode(community);
            summary.setCountryCode(country);
            summary.setCollectionDate(colDate);
            thisDao.save(summary);
        } else {
            summary = (SurveyInstanceSummary)results.get(0);
            summary.setCount(summary.getCount() + (long)delta);
            if (summary.getCount() == 0L) {
                thisDao.delete(summary);
            } else {
                thisDao.save(summary);
            }
        }
    }

    public List<SurveyInstanceSummary> listByLocation(String countryCode, String communityCode) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyInstanceSummary.class);
        List results = null;
        if (countryCode != null || communityCode != null) {
            StringBuilder filter = new StringBuilder();
            StringBuilder param = new StringBuilder();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            this.appendNonNullParam("countryCode", filter, param, "String", countryCode, paramMap);
            this.appendNonNullParam("communityCode", filter, param, "String", communityCode, paramMap);
            query.setFilter(filter.toString());
            query.declareParameters(param.toString());
            results = (List)query.executeWithMap(paramMap);
        } else {
            results = this.list("all");
        }
        return results;
    }

    public SurveyInstanceSummary findBySurveyId(Long surveyId) {
        return (SurveyInstanceSummary)this.findByProperty("surveyId", surveyId, "Long");
    }
}

