/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.QuestionHelpMediaDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.dto.SurveyTaskRequest;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class SurveyTaskServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(SurveyTaskServlet.class.getName());
    private static final long serialVersionUID = -9064136783930675167L;
    private AccessPointHelper aph = new AccessPointHelper();
    private SurveyInstanceDAO siDao = new SurveyInstanceDAO();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyTaskRequest restRequest = new SurveyTaskRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        SurveyTaskRequest stReq = (SurveyTaskRequest)req;
        String action = stReq.getAction();
        Long id = stReq.getId();
        log.info("action: " + action + " id: " + id);
        if (action == null) {
            return null;
        }
        switch (action) {
            case "deleteSurvey": {
                SurveyDAO surveyDao = new SurveyDAO();
                Survey s = (Survey)surveyDao.getByKey(id);
                if (s == null) break;
                surveyDao.delete(s);
                break;
            }
            case "deleteQuestionGroup": {
                QuestionGroupDao qgDao = new QuestionGroupDao();
                QuestionGroup qg = (QuestionGroup)qgDao.getByKey(id);
                if (qg == null) break;
                qgDao.delete(qg);
                break;
            }
            case "deleteQuestion": {
                QuestionDao qDao = new QuestionDao();
                Question q = qDao.getByKey(id);
                if (q == null) break;
                qDao.delete(q);
                break;
            }
            case "deleteQuestionOptions": {
                QuestionOptionDao qoDao = new QuestionOptionDao();
                qoDao.delete(qoDao.getByKey(id));
                break;
            }
            case "deleteQuestionHelp": {
                QuestionHelpMediaDao qhDao = new QuestionHelpMediaDao();
                qhDao.delete(qhDao.getByKey(id));
                break;
            }
            case "deleteQuestionTranslation": {
                TranslationDao tDao = new TranslationDao();
                tDao.delete(tDao.getByKey(id));
                break;
            }
            case "deleteDeviceSurveyJobQueue": {
                DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
                dsjqDao.deleteJob(id);
                break;
            }
            case "deleteDeviceFileJobQueue": {
                DeviceFileJobQueueDAO dfjqDao = new DeviceFileJobQueueDAO();
                dfjqDao.delete(dfjqDao.getByKey(id));
                break;
            }
            case "reprocessMapSurveyInstance": {
                List<SurveyInstance> nextSet;
                String idList = stReq.getIdList();
                if (idList == null || idList.trim().length() <= 0) break;
                String[] ids = idList.split(",");
                log.log(Level.INFO, "action: " + stReq.getAction() + " idList: " + idList);
                for (int i = 0; i < ids.length; ++i) {
                    this.aph.processSurveyInstance(ids[i]);
                }
                if (stReq.getCursor() == null || (nextSet = this.siDao.listSurveyInstanceBySurveyId(stReq.getId(), stReq.getCursor())) == null || nextSet.size() <= 0) break;
                StringBuffer buffer = new StringBuffer();
                Queue queue = QueueFactory.getDefaultQueue();
                for (int i = 0; i < nextSet.size(); ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(nextSet.get(i).getKey().getId());
                }
                queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/surveytask").param("action", "reprocessMapSurveyInstance").param("id", stReq.getId().toString()).param("idList", buffer.toString()).param("cursor", SurveyInstanceDAO.getCursor(nextSet)));
                break;
            }
            default: {
                log.warning("Unknown action.");
            }
        }
        return null;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }
}

