/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics;

import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.waterforpeople.mapping.analytics.dao.AccessPointMetricSummaryDao;
import org.waterforpeople.mapping.analytics.domain.AccessPointMetricSummary;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.dao.AccessPointMetricMappingDao;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.AccessPointMetricMapping;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class AccessPointMetricSummarizer
implements DataSummarizer {
    Logger logger = Logger.getLogger(AccessPointMetricSummarizer.class.getName());

    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        AccessPoint ap;
        AccessPointMetricMappingDao mappingDao = new AccessPointMetricMappingDao();
        AccessPointDao apDao = new AccessPointDao();
        if (key != null && (ap = apDao.getByKey(Long.parseLong(key), AccessPoint.class)) != null) {
            List<AccessPointMetricMapping> mappingList;
            if (ap.getCountryCode() == null) {
                this.logger.log(Level.INFO, "During APMS Summarization ap was missing countryCode so try GeoLocation");
                AccessPointHelper aph = new AccessPointHelper();
                ap = aph.setGeoDetails(ap);
                apDao.save(ap);
                if (ap.getCountryCode() != null) {
                    this.logger.log(Level.INFO, "Mapped AP to " + ap.getCountryCode());
                }
            }
            if ((mappingList = mappingDao.findMappings(ap.getOrganization(), null, null)) != null) {
                for (AccessPointMetricMapping mapping : mappingList) {
                    String fieldValue = AccessPointHelper.getAccessPointFieldAsString(ap, mapping.getFieldName());
                    if (fieldValue == null || fieldValue.trim().length() <= 0) continue;
                    String valBucket = this.bucketizeValue(mapping, fieldValue);
                    String metricName = mapping.getMetricName() != null ? mapping.getMetricName() : mapping.getFieldName();
                    AccessPointMetricSummary metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                    metricSummary.setSubLevel(0);
                    metricSummary.setSubValue(ap.getCountryCode());
                    AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                    if (ap.getSub1() != null) {
                        metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                        metricSummary.setSubLevel(1);
                        metricSummary.setSubValue(ap.getSub1());
                        metricSummary.setParentSubName(ap.getCountryCode());
                        AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                    }
                    if (ap.getSub2() != null) {
                        metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                        metricSummary.setSubLevel(2);
                        metricSummary.setSubValue(ap.getSub2());
                        metricSummary.setParentSubName(ap.getCountryCode() + "/" + ap.getSub1());
                        AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                    }
                    if (ap.getSub3() != null) {
                        metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                        metricSummary.setSubLevel(3);
                        metricSummary.setSubValue(ap.getSub3());
                        metricSummary.setParentSubName(ap.getCountryCode() + "/" + ap.getSub1() + "/" + ap.getSub2());
                        AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                    }
                    if (ap.getSub4() != null) {
                        metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                        metricSummary.setSubLevel(4);
                        metricSummary.setSubValue(ap.getSub4());
                        metricSummary.setParentSubName(ap.getCountryCode() + "/" + ap.getSub1() + "/" + ap.getSub2() + "/" + ap.getSub3());
                        AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                    }
                    if (ap.getSub5() != null) {
                        metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                        metricSummary.setSubLevel(5);
                        metricSummary.setSubValue(ap.getSub5());
                        metricSummary.setParentSubName(ap.getCountryCode() + "/" + ap.getSub1() + "/" + ap.getSub2() + "/" + ap.getSub3() + "/" + ap.getSub4());
                        AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                    }
                    if (ap.getSub6() == null) continue;
                    metricSummary = this.constructBaseSummary(fieldValue, mapping.getMetricGroup(), metricName, ap.getOrganization(), ap.getCountryCode(), valBucket);
                    metricSummary.setSubLevel(6);
                    metricSummary.setSubValue(ap.getSub6());
                    metricSummary.setParentSubName(ap.getCountryCode() + "/" + ap.getSub1() + "/" + ap.getSub2() + "/" + ap.getSub3() + "/" + ap.getSub4() + "/" + ap.getSub5());
                    AccessPointMetricSummaryDao.incrementCount(metricSummary, 1);
                }
            }
        }
        return true;
    }

    private AccessPointMetricSummary constructBaseSummary(String fieldValue, String metricGroup, String metricName, String org, String country, String valueBucket) {
        AccessPointMetricSummary metricSummary = new AccessPointMetricSummary();
        metricSummary.setMetricValue(fieldValue);
        metricSummary.setMetricGroup(metricGroup);
        metricSummary.setMetricName(metricName);
        metricSummary.setOrganization(org);
        metricSummary.setCountry(country);
        metricSummary.setValueBucket(valueBucket);
        return metricSummary;
    }

    private String bucketizeValue(AccessPointMetricMapping mapping, String value) {
        String bucket = "UNKNOWN";
        if (mapping.getPositiveValues() != null) {
            if (mapping.getPositiveValues().contains(value)) {
                bucket = "POSITIVE";
            } else if (mapping.getNeutralValues().contains(value)) {
                bucket = "NEUTRAL";
            } else if (mapping.getNegativeValues().contains(value)) {
                bucket = "NEGATIVE";
            }
        }
        return bucket;
    }

    @Override
    public String getCursor() {
        return null;
    }
}

