/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.diagnostics.app.web;

import com.gallatinsystems.diagnostics.app.web.dto.RemoteExceptionRequest;
import com.gallatinsystems.diagnostics.dao.RemoteStacktraceDao;
import com.gallatinsystems.diagnostics.domain.RemoteStacktrace;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.framework.rest.exception.RestException;
import com.google.appengine.api.datastore.Text;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class RemoteExceptionRestServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 1831040260541847041L;
    private RemoteStacktraceDao stacktraceDao = new RemoteStacktraceDao();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        RemoteExceptionRequest exReq = new RemoteExceptionRequest();
        exReq.populateFromHttpRequest(req);
        return exReq;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse resp = new RestResponse();
        RemoteExceptionRequest exReq = (RemoteExceptionRequest)req;
        if (!"saveTrace".equals(req.getAction())) {
            throw new RestException(new RestError("5002", "Invalid data type", "Action: " + req.getAction() + " not supported"), "Bad Action value", null);
        }
        RemoteStacktrace trace = new RemoteStacktrace();
        trace.setErrorDate(exReq.getDate() != null ? exReq.getDate() : new Date());
        trace.setSoftwareVersion(exReq.getVersion());
        trace.setDeviceIdentifier(exReq.getDeviceIdent());
        trace.setPhoneNumber(exReq.getPhoneNumber());
        trace.setStackTrace(new Text(exReq.getStackTrace()));
        trace.setAndroidId(exReq.getAndroidId());
        this.stacktraceDao.save(trace);
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
    }
}

