/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.dto.DeleteTaskRequest;

public class ProcessAccessPointTaskServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 5116204674096200848L;
    private static final String OBJECT_TASK_URL = "/app_worker/processaccesspointtaskservlet";
    private static final String ACCESSPOINT_QUEUE_NAME = "accesspointqueue";

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DeleteTaskRequest restRequest = new DeleteTaskRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DeleteTaskRequest dtReq = (DeleteTaskRequest)req;
        String newCursor = null;
        if (dtReq.getKey().equals("secret")) {
            Integer taskcount;
            String tcs;
            String kind = dtReq.getObjectName();
            int deleted_count = 0;
            boolean is_finished = false;
            DatastoreService dss = DatastoreServiceFactory.getDatastoreService();
            Query query = new Query(kind);
            int limit = 10;
            if (dtReq.getCursor() != null) {
                limit = 150;
            }
            FetchOptions fetchOptions = FetchOptions.Builder.withLimit((int)limit);
            if (dtReq.getCursor() != null) {
                fetchOptions.startCursor(Cursor.fromWebSafeString((String)dtReq.getCursor()));
            }
            query.setKeysOnly();
            QueryResultList results = dss.prepare(query).asQueryResultList(fetchOptions);
            newCursor = results.getCursor().toWebSafeString();
            if (results.isEmpty()) {
                is_finished = true;
            } else {
                tcs = dtReq.getTaskCount();
                taskcount = tcs == null ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(tcs) + 1);
                for (Entity entity : results) {
                    Queue deleteQueue = QueueFactory.getQueue((String)"accesspointmetricsummqueue");
                    deleteQueue.add(TaskOptions.Builder.withUrl((String)"/app_worker/accesspointmetricprocessor").param("object", kind + "").param("key", String.valueOf(entity.getKey().getId())).param("cursor", newCursor).param("itemnum", String.valueOf(deleted_count)).param("taskCount", taskcount.toString()));
                    ++deleted_count;
                }
            }
            System.err.println("*** processed " + deleted_count + " entities form " + kind);
            if (is_finished) {
                System.err.println("*** process job for " + kind + " is completed.");
            } else {
                tcs = dtReq.getTaskCount();
                taskcount = tcs == null ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(tcs) + 1);
                Queue deleteQueue = QueueFactory.getQueue((String)ACCESSPOINT_QUEUE_NAME);
                deleteQueue.add(TaskOptions.Builder.withUrl((String)OBJECT_TASK_URL).param("object", kind + "").param("key", dtReq.getKey()).param("cursor", newCursor).param("taskCount", taskcount.toString()));
                System.err.println("*** process task # " + taskcount + " for " + kind + " is queued.");
            }
        }
        return null;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        if (resp != null) {
            this.getResponse().getWriter().println("ok");
        }
    }
}

