/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.exception.RestValidationException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class AccessPointRequest
extends RestRequest {
    private static final long serialVersionUID = 2511688888372190068L;
    private static final String LAT_PARAM = "lat";
    private static final String LON_PARAM = "lon";
    private static final String COUNTRY_PARAM = "country";
    private static final String COMM_PARAM = "community";
    private static final String CONST_DATE_FROM_PARAM = "constructionDateFrom";
    private static final String CONST_DATE_TO_PARAM = "constructionDateTo";
    private static final String COLL_DATE_FROM_PARAM = "collectionDateFrom";
    private static final String COLL_DATE_TO_PARAM = "collectionDateTo";
    private static final String TYPE_PARAM = "pointType";
    public static final String NEARBY_ACTION = "getnearby";
    public static final String SEARCH_ACTION = "search";
    private static final ThreadLocal<DateFormat> DATE_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateInstance();
        }
    };
    private Double lat;
    private Double lon;
    private String country;
    private String community;
    private Date constructionDateFrom;
    private Date constructionDateTo;
    private Date collectionDateFrom;
    private Date collectionDateTo;
    private String type;

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public Date getConstructionDateFrom() {
        return this.constructionDateFrom;
    }

    public void setConstructionDateFrom(Date constructionDateFrom) {
        this.constructionDateFrom = constructionDateFrom;
    }

    public Date getConstructionDateTo() {
        return this.constructionDateTo;
    }

    public void setConstructionDateTo(Date constructionDateTo) {
        this.constructionDateTo = constructionDateTo;
    }

    public Date getCollectionDateFrom() {
        return this.collectionDateFrom;
    }

    public void setCollectionDateFrom(Date collectionDateFrom) {
        this.collectionDateFrom = collectionDateFrom;
    }

    public Date getCollectionDateTo() {
        return this.collectionDateTo;
    }

    public void setCollectionDateTo(Date collectionDateTo) {
        this.collectionDateTo = collectionDateTo;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Override
    protected void populateErrors() {
        if (NEARBY_ACTION.equalsIgnoreCase(this.getAction())) {
            if (this.country == null && this.lat == null) {
                this.addError(new RestError("5001", "Missing mandatory parameter", "lat cannot be null if no country is supplied"));
            }
            if (this.country == null && this.lon == null) {
                this.addError(new RestError("5001", "Missing mandatory parameter", "lon cannot be null if no country is supplied"));
            }
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.country = req.getParameter(COUNTRY_PARAM);
        this.community = req.getParameter(COMM_PARAM);
        this.type = req.getParameter(TYPE_PARAM);
        if (this.country != null) {
            this.country = this.country.trim().toUpperCase();
            if (this.country.length() == 0) {
                this.country = null;
            }
        }
        try {
            if (req.getParameter(LAT_PARAM) != null && req.getParameter(LON_PARAM) != null) {
                this.lat = Double.parseDouble(req.getParameter(LAT_PARAM));
                this.lon = Double.parseDouble(req.getParameter(LON_PARAM));
            }
        }
        catch (NumberFormatException e) {
            throw new RestValidationException(new RestError("5002", "Invalid data type", "lat, lon must be doubles"), "Lat/lon must be doubles", (Exception)e);
        }
        try {
            this.collectionDateFrom = this.parseDate(req.getParameter(COLL_DATE_FROM_PARAM));
            this.collectionDateTo = this.parseDate(req.getParameter(COLL_DATE_TO_PARAM));
            this.constructionDateFrom = this.parseDate(req.getParameter(CONST_DATE_FROM_PARAM));
            this.constructionDateTo = this.parseDate(req.getParameter(CONST_DATE_TO_PARAM));
        }
        catch (Exception e) {
            throw new RestValidationException(new RestError("5002", "Invalid data type", "Cannot parse date"), "Cannot parse date", e);
        }
    }

    private Date parseDate(String val) throws ParseException {
        Date date = null;
        if (val != null && val.trim().length() > 0) {
            date = DATE_FMT.get().parse(val);
        }
        return date;
    }
}

