/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.device.domain.DeviceFileJobQueue;
import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.notification.helper.NotificationHelper;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyTaskUtil;
import com.google.appengine.api.datastore.Key;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.dao.ReportDao;
import org.akvo.flow.domain.persistent.Report;

public class CronCommanderServlet
extends HttpServlet {
    private static final int ONE_YEAR_AGO = -1;
    private static final int TWO_YEARS_AGO = -2;
    private static final long serialVersionUID = 2287175129835274533L;
    private static final Logger log = Logger.getLogger(CronCommanderServlet.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String action = req.getParameter("action");
        if (!"buildMap".equals(action)) {
            if ("purgeExpiredSurveys".equals(action)) {
                this.purgeExpiredSurveys();
            } else if ("purgeOrphanJobQueueRecords".equals(action)) {
                this.purgeOrphanJobQueueRecords();
            } else if ("generateNotifications".equals(action)) {
                this.generateNotifications();
            } else if ("purgeDeviceFileJobQueueRecords".equals(action)) {
                this.purgeDeviceFileJobQueueRecords();
            } else if ("purgeReportRecords".equals(action)) {
                this.purgeReportRecords();
            }
        }
    }

    private void purgeReportRecords() {
        Calendar deadline = Calendar.getInstance();
        deadline.add(1, -1);
        log.fine("Starting scan for Report entries, older than: " + deadline.getTime());
        ReportDao reportDao = new ReportDao();
        List<Report> reportList = reportDao.listAllCreatedBefore(deadline.getTime());
        log.fine("Attempting to retire " + reportList.size());
        for (Report item : reportList) {
            log.fine("Deleting old Report entry: " + item.getKey().getId());
            SurveyTaskUtil.spawnDeleteTask("deleteReport", item.getKey().getId());
        }
    }

    private void purgeDeviceFileJobQueueRecords() {
        Calendar deadline = Calendar.getInstance();
        deadline.add(1, -2);
        log.fine("Starting scan for DFJQ entries, fulfilled or older than: " + deadline.getTime());
        DeviceFileJobQueueDAO dfjqDao = new DeviceFileJobQueueDAO();
        List dfjqList = dfjqDao.list("all");
        int retirees = 0;
        for (DeviceFileJobQueue item : dfjqList) {
            if (item.getCreatedDateTime() != null && deadline.getTime().after(item.getCreatedDateTime())) {
                log.fine("Deleting old DFJQ entry: " + item.getKey().getId());
                SurveyTaskUtil.spawnDeleteTask("deleteDeviceFileJobQueue", item.getKey().getId());
                ++retirees;
                continue;
            }
            try {
                String bucket = PropertyUtil.getProperty("s3bucket");
                HttpURLConnection conn = (HttpURLConnection)S3Util.getConnection(bucket, "images/" + item.getFileName());
                log.fine("Checking for " + item.getFileName() + " : " + conn.getResponseCode() + " " + conn.getResponseMessage());
                if (conn.getResponseCode() != 200) continue;
                log.fine("Deleting fulfilled DFJQ entry: " + item.getKey().getId());
                SurveyTaskUtil.spawnDeleteTask("deleteDeviceFileJobQueue", item.getKey().getId());
                ++retirees;
            }
            catch (Exception e) {
                log.warning("Error while connecing to " + item.getFileName() + "\n" + e.getMessage());
            }
        }
        log.fine("Attempted to retire " + retirees + " of " + dfjqList.size());
    }

    private void generateNotifications() {
        NotificationHelper helper = new NotificationHelper("rawDataReport", null);
        helper.execute();
        NotificationHelper fieldReportHelper = new NotificationHelper("fieldStatusReport", null);
        fieldReportHelper.execute();
    }

    private void purgeExpiredSurveys() {
        DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
        List<DeviceSurveyJobQueue> dsjqList = dsjqDao.listAssignmentsWithEarlierExpirationDate(new Date());
        for (DeviceSurveyJobQueue item : dsjqList) {
            SurveyTaskUtil.spawnDeleteTask("deleteDeviceSurveyJobQueue", item.getAssignmentId());
        }
    }

    private void purgeOrphanJobQueueRecords() {
        DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
        SurveyDAO surveyDao = new SurveyDAO();
        List<Key> surveyIdList = surveyDao.listSurveyIds();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Key key : surveyIdList) {
            ids.add(key.getId());
        }
        for (DeviceSurveyJobQueue item : dsjqDao.listAllJobsInQueue()) {
            Long dsjqSurveyId = item.getSurveyID();
            Boolean found = ids.contains(dsjqSurveyId);
            if (found.booleanValue()) continue;
            log.info("found orphan assignmentId: " + item.getAssignmentId() + " id: " + item.getId() + " survey: " + item.getSurveyID() + " for deletion");
            SurveyTaskUtil.spawnDeleteTask("deleteDeviceSurveyJobQueue", item.getAssignmentId());
        }
    }
}

