/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.DataExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class SurveyFormExporter
implements DataExporter {
    private static final Logger log = Logger.getLogger(SurveyFormExporter.class);
    private static final int COL_WIDTH = 10000;
    private static final String LANG_DELIM = " / ";
    private static final String DEP_HEAD = "Only answer if you responded ";
    private static final String DEP_HEAD_TO = " to ";
    private static final String BLANK = "_________________________";
    private static final String SMALL_BLANK = "______";
    private static final String QUESTION_HEADER = "Question";
    private static final String RESPONSE_HEADER = "Response";
    private static final String SURVEY_ID_KEY = "surveyId";
    private Map<Long, Long> idToNumberMap;
    private List<QuestionGroupDto> groupList;
    private String surveyTitle;
    private Map<QuestionGroupDto, List<QuestionDto>> questionMap;

    @Override
    public void export(Map<String, String> criteria, File fileName, String serverBase, Map<String, String> options) {
        try {
            String surveyId = criteria.get(SURVEY_ID_KEY);
            String apiKey = criteria.get("apiKey");
            this.populateQuestionMap(surveyId, serverBase, apiKey);
            List<SurveyDto> surveys = BulkDataServiceClient.fetchSurvey(Long.parseLong(surveyId), serverBase, apiKey);
            if (surveys == null || surveys.isEmpty()) {
                this.surveyTitle = "";
            } else {
                SurveyDto surveyDto = surveys.get(0);
                this.surveyTitle = String.format("%s (v. %s)", surveyDto.getName(), surveyDto.getVersion());
            }
            this.writeSurvey(this.surveyTitle, fileName, this.groupList, this.questionMap);
        }
        catch (Exception e) {
            log.error((Object)"Could not write survey", (Throwable)e);
        }
    }

    private void populateQuestionMap(String surveyId, String serverBase, String apiKey) throws Exception {
        this.groupList = BulkDataServiceClient.fetchQuestionGroups(serverBase, surveyId, apiKey);
        this.questionMap = new HashMap<QuestionGroupDto, List<QuestionDto>>();
        this.idToNumberMap = new HashMap<Long, Long>();
        if (this.groupList != null) {
            Long count = 1L;
            for (QuestionGroupDto group : this.groupList) {
                List<QuestionDto> questions = BulkDataServiceClient.fetchQuestions(serverBase, group.getKeyId(), apiKey);
                if (questions == null) continue;
                ArrayList<QuestionDto> fullQuestions = new ArrayList<QuestionDto>();
                for (QuestionDto q : questions) {
                    QuestionDto fullQ = BulkDataServiceClient.loadQuestionDetails(serverBase, q.getKeyId(), apiKey);
                    if (fullQ == null) continue;
                    fullQuestions.add(fullQ);
                    Long l = count;
                    Long l2 = count = Long.valueOf(count + 1L);
                    this.idToNumberMap.put(fullQ.getKeyId(), l);
                }
                this.questionMap.put(group, fullQuestions);
            }
        }
    }

    private void writeSurvey(String title, File fileName, List<QuestionGroupDto> groupList, Map<QuestionGroupDto, List<QuestionDto>> questions) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        sheet.setColumnWidth(0, 10000);
        sheet.setColumnWidth(1, 10000);
        HSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setAlignment((short)2);
        HSSFFont headerFont = wb.createFont();
        headerFont.setBoldweight((short)700);
        headerStyle.setFont(headerFont);
        HSSFCellStyle questionStyle = wb.createCellStyle();
        questionStyle.setVerticalAlignment((short)0);
        questionStyle.setWrapText(true);
        HSSFCellStyle depStyle = wb.createCellStyle();
        depStyle.setAlignment((short)2);
        HSSFFont depFont = wb.createFont();
        depFont.setBoldweight((short)700);
        depFont.setItalic(true);
        depStyle.setFont(depFont);
        int curRow = 0;
        HSSFRow row = sheet.createRow(curRow++);
        sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 1));
        this.createCell(row, 0, title, headerStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, QUESTION_HEADER, headerStyle);
        this.createCell(row, 1, RESPONSE_HEADER, headerStyle);
        Long count = 1L;
        if (questions != null) {
            for (int i = 0; i < groupList.size(); ++i) {
                HSSFRow groupHeaderRow = sheet.createRow(curRow++);
                sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 1));
                this.createCell(groupHeaderRow, 0, groupList.get(i).getDisplayName(), headerStyle);
                for (QuestionDto q : questions.get(groupList.get(i))) {
                    int questionStartRow = curRow;
                    HSSFRow tempRow = sheet.createRow(curRow++);
                    if (q.getQuestionDependency() != null) {
                        sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 1));
                        Long qNum = this.idToNumberMap.get(q.getQuestionDependency().getQuestionId());
                        this.createCell(tempRow, 0, DEP_HEAD + q.getQuestionDependency().getAnswerValue() + DEP_HEAD_TO + "Q" + qNum, depStyle);
                        tempRow = sheet.createRow(curRow++);
                        questionStartRow = curRow;
                    }
                    Long l = count;
                    Long l2 = count = Long.valueOf(count + 1L);
                    this.createCell(tempRow, 0, l + ". " + this.formText(q.getText(), q.getTranslationMap()), questionStyle);
                    if (q.getOptionContainerDto() != null && q.getOptionContainerDto().getOptionsList() != null) {
                        for (QuestionOptionDto opt : q.getOptionContainerDto().getOptionsList()) {
                            tempRow = sheet.createRow(curRow++);
                            this.createCell(tempRow, 1, this.formText(opt.getText(), opt.getTranslationMap()) + SMALL_BLANK, null);
                        }
                        sheet.addMergedRegion(new CellRangeAddress(questionStartRow, curRow - 1, 0, 0));
                        continue;
                    }
                    this.createCell(tempRow, 1, BLANK, null);
                }
            }
        }
        FileOutputStream fileOut = new FileOutputStream(fileName);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    private HSSFCell createCell(HSSFRow row, int col, String value, HSSFCellStyle style) {
        HSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null) {
            cell.setCellValue(value);
        }
        return cell;
    }

    private String formText(String text, Map<String, TranslationDto> translationMap) {
        StringBuilder buff = new StringBuilder();
        buff.append(text);
        if (translationMap != null) {
            TreeMap<String, TranslationDto> sortedMap = null;
            sortedMap = translationMap instanceof TreeMap ? (TreeMap<String, TranslationDto>)translationMap : new TreeMap<String, TranslationDto>(translationMap);
            for (Map.Entry<String, TranslationDto> trans : sortedMap.entrySet()) {
                if (trans.getValue() == null || trans.getValue().getText() == null || trans.getValue().getText().trim().equalsIgnoreCase("null")) continue;
                buff.append(LANG_DELIM);
                buff.append(trans.getValue().getText());
            }
        }
        return buff.toString();
    }
}

