/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.CascadeNodeDao;
import com.gallatinsystems.survey.domain.CascadeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.CascadeNodeDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.CascadeNodeBulkPayload;
import org.waterforpeople.mapping.app.web.rest.dto.CascadeNodePayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/cascade_nodes"})
public class CascadeNodeRestService {
    private CascadeNodeDao cascadeNodeDao = new CascadeNodeDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<CascadeNodeDto>> listCascadeNodes(@RequestParam(value="cascadeResourceId", defaultValue="") Long cascadeResourceId, @RequestParam(value="parentNodeId", defaultValue="") Long parentNodeId) {
        HashMap<String, List<CascadeNodeDto>> response = new HashMap<String, List<CascadeNodeDto>>();
        ArrayList<CascadeNodeDto> results = new ArrayList<CascadeNodeDto>();
        List<CascadeNode> cnList = this.cascadeNodeDao.listCascadeNodesByResourceAndParentId(cascadeResourceId, parentNodeId);
        if (cnList != null) {
            for (CascadeNode cn : cnList) {
                CascadeNodeDto dto = new CascadeNodeDto();
                BeanUtils.copyProperties((Object)cn, (Object)dto);
                if (cn.getKey() != null) {
                    dto.setKeyId(cn.getKey().getId());
                }
                results.add(dto);
            }
        }
        response.put("cascade_nodes", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteCascadeNodeById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        CascadeNode cr = (CascadeNode)this.cascadeNodeDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (cr != null) {
            this.cascadeNodeDao.deleteRecursive(cr.getCascadeResourceId(), id);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingCascadeNode(@RequestBody CascadeNodePayload payLoad) {
        CascadeNode cr;
        Long keyId;
        CascadeNodeDto cascadeNodeDto = payLoad.getCascade_node();
        HashMap<String, Object> response = new HashMap<String, Object>();
        CascadeNodeDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (cascadeNodeDto != null && (keyId = cascadeNodeDto.getKeyId()) != null && (cr = (CascadeNode)this.cascadeNodeDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)cascadeNodeDto, (Object)cr, (String[])new String[]{"createdDateTime"});
            cr = this.cascadeNodeDao.save(cr);
            dto = new CascadeNodeDto();
            BeanUtils.copyProperties((Object)cr, (Object)dto);
            if (cr.getKey() != null) {
                dto.setKeyId(cr.getKey().getId());
            }
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("cascade_node", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewCascadeNode(@RequestBody CascadeNodePayload payLoad) {
        CascadeNodeDto cascadeNodeDto = payLoad.getCascade_node();
        HashMap<String, Object> response = new HashMap<String, Object>();
        CascadeNodeDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (cascadeNodeDto != null && (dto = this.createCascadeNode(cascadeNodeDto)) != null) {
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("cascade_node", dto);
        return response;
    }

    private CascadeNodeDto createCascadeNode(CascadeNodeDto cascadeNodeDto) {
        CascadeNode cn = new CascadeNode();
        BeanUtils.copyProperties((Object)cascadeNodeDto, (Object)cn);
        if (StringUtils.isEmpty((String)cascadeNodeDto.getCode())) {
            cn.setCode(cn.getName());
        }
        cn = this.cascadeNodeDao.save(cn);
        CascadeNodeDto cnDto = new CascadeNodeDto();
        DtoMarshaller.copyToDto(cn, cnDto);
        return cnDto;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/bulk"})
    @ResponseBody
    public Map<String, Object> saveNewCascadeNodeBulk(@RequestBody CascadeNodeBulkPayload payLoad) {
        String status;
        List<CascadeNodeDto> cascadeNodeDtoList = payLoad.getCascade_nodes();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<CascadeNodeDto> results = new ArrayList<CascadeNodeDto>();
        CascadeNodeDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        Boolean stateSuccess = true;
        for (CascadeNodeDto cnDto : cascadeNodeDtoList) {
            dto = this.createCascadeNode(cnDto);
            if (dto != null) {
                results.add(dto);
                continue;
            }
            stateSuccess = false;
        }
        String string = status = stateSuccess != false ? "ok" : "failed";
        if (status.equals("failed")) {
            statusDto.setMessage("Cannot save cascade nodes");
        }
        statusDto.setStatus(status);
        response.put("meta", statusDto);
        response.put("cascade_nodes", results);
        return response;
    }
}

