/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static ByteArrayOutputStream generateZip(String kmlContents) {
        return ZipUtil.generateZip(kmlContents, "waterforpeoplemapping.kml");
    }

    public static ByteArrayOutputStream generateZip(String content, String filename) {
        ZipOutputStream zipOut = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            zipOut = new ZipOutputStream(bos);
            zipOut.setLevel(8);
            ZipEntry entry = new ZipEntry(filename);
            zipOut.putNextEntry(entry);
            zipOut.write(content.getBytes("UTF-8"));
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos;
    }

    public static ByteArrayOutputStream generateZip(Map<String, String> contents, Map<String, byte[]> resources) {
        ZipOutputStream zipOut = null;
        ByteArrayOutputStream bos = null;
        try {
            ZipEntry entry;
            bos = new ByteArrayOutputStream();
            zipOut = new ZipOutputStream(bos);
            zipOut.setLevel(8);
            for (Map.Entry<String, String> entry2 : contents.entrySet()) {
                entry = new ZipEntry(entry2.getKey());
                zipOut.putNextEntry(entry);
                zipOut.write(entry2.getValue().getBytes("UTF-8"));
                zipOut.closeEntry();
            }
            for (Map.Entry<String, String> entry3 : resources.entrySet()) {
                entry = new ZipEntry(entry3.getKey());
                zipOut.putNextEntry(entry);
                zipOut.write((byte[])entry3.getValue());
                zipOut.closeEntry();
            }
            zipOut.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos;
    }

    public static String unZip(byte[] contents) throws IOException {
        return ZipUtil.unZip(contents, null);
    }

    public static String unZip(byte[] contents, String entryName) throws IOException {
        ZipEntry entry;
        ByteArrayInputStream zipContents = new ByteArrayInputStream(contents);
        ZipInputStream zis = new ZipInputStream(zipContents);
        StringBuilder line = new StringBuilder();
        while ((entry = zis.getNextEntry()) != null) {
            int size;
            if (entryName != null && !entryName.equalsIgnoreCase(entry.getName())) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, size);
            }
            line.append(out.toString());
            out.close();
        }
        zis.closeEntry();
        return line.toString();
    }
}

