/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.diagnostics.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class RemoteExceptionRequest
extends RestRequest {
    private static final long serialVersionUID = 8303938931927567747L;
    private static final String FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<DateFormat> DATE_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(RemoteExceptionRequest.FORMAT_STRING, Locale.US);
        }
    };
    public static final String SAVE_TRACE_ACTION = "saveTrace";
    public static final String PHONE_PARAM = "phoneNumber";
    public static final String DEV_ID_PARAM = "deviceIdentifier";
    public static final String VERSION_PARAM = "version";
    public static final String DATE_PARAM = "date";
    public static final String TRACE_PARAM = "trace";
    public static final String ANDROID_ID_PARAM = "androidId";
    private String phoneNumber;
    private String deviceIdent;
    private String version;
    private Date date;
    private String stackTrace;
    private String androidId;

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getDeviceIdent() {
        return this.deviceIdent;
    }

    public void setDeviceIdent(String deviceIdent) {
        this.deviceIdent = deviceIdent;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getAndroidId() {
        return this.androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    @Override
    protected void populateErrors() {
        if (this.date == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "date is required"));
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.phoneNumber = req.getParameter(PHONE_PARAM);
        this.deviceIdent = req.getParameter(DEV_ID_PARAM);
        this.version = req.getParameter(VERSION_PARAM);
        this.stackTrace = req.getParameter(TRACE_PARAM);
        this.androidId = req.getParameter(ANDROID_ID_PARAM);
        if (req.getParameter(DATE_PARAM) != null && req.getParameter(DATE_PARAM).trim().length() > 0) {
            try {
                this.date = DATE_FMT.get().parse(req.getParameter(DATE_PARAM));
            }
            catch (Exception e) {
                this.addError(new RestError("5002", "Invalid data type", "date must be in format: yyyy-MM-dd HH:mm:ss"));
            }
        }
    }
}

