/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.domain.UploadStatusContainer;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.messaging.dao.MessageDao;
import com.gallatinsystems.messaging.domain.Message;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.dao.SurveyXMLFragmentDao;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionHelpMedia;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.ScoringRule;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyContainer;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.SurveyXMLFragment;
import com.gallatinsystems.survey.domain.Translation;
import com.gallatinsystems.survey.domain.xml.AltText;
import com.gallatinsystems.survey.domain.xml.Dependency;
import com.gallatinsystems.survey.domain.xml.Help;
import com.gallatinsystems.survey.domain.xml.Level;
import com.gallatinsystems.survey.domain.xml.Levels;
import com.gallatinsystems.survey.domain.xml.ObjectFactory;
import com.gallatinsystems.survey.domain.xml.Option;
import com.gallatinsystems.survey.domain.xml.Options;
import com.gallatinsystems.survey.domain.xml.Score;
import com.gallatinsystems.survey.domain.xml.Scoring;
import com.gallatinsystems.survey.domain.xml.Text;
import com.gallatinsystems.survey.domain.xml.ValidationRule;
import com.gallatinsystems.survey.xml.SurveyXMLAdapter;
import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.utils.SystemProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.waterforpeople.mapping.app.web.dto.SurveyAssemblyRequest;
import org.waterforpeople.mapping.dao.SurveyContainerDao;

public class SurveyAssemblyServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger((String)SurveyAssemblyServlet.class.getName());
    private static final int BACKEND_QUESTION_THRESHOLD = 80;
    private static final String BACKEND_PUBLISH_PROP = "backendpublish";
    private static final long serialVersionUID = -6044156962558183224L;
    private static final String OPTION_RENDER_MODE_PROP = "optionRenderMode";
    public static final String FREE_QUESTION_TYPE = "free";
    public static final String OPTION_QUESTION_TYPE = "option";
    public static final String GEO_QUESTION_TYPE = "geo";
    public static final String VIDEO_QUESTION_TYPE = "video";
    public static final String PHOTO_QUESTION_TYPE = "photo";
    public static final String SCAN_QUESTION_TYPE = "scan";
    public static final String STRENGTH_QUESTION_TYPE = "strength";
    public static final String DATE_QUESTION_TYPE = "date";
    public static final String CASCADE_QUESTION_TYPE = "cascade";
    public static final String GEOSHAPE_QUESTION_TYPE = "geoshape";
    public static final String SIGNATURE_QUESTION_TYPE = "signature";
    public static final String CADDISFLY_QUESTION_TYPE = "caddisfly";
    private static final String SURVEY_UPLOAD_URL = "surveyuploadurl";
    private static final String SURVEY_UPLOAD_DIR = "surveyuploaddir";
    private Random randomNumber = new Random();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyAssemblyRequest restRequest = new SurveyAssemblyRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse response = new RestResponse();
        SurveyAssemblyRequest importReq = (SurveyAssemblyRequest)req;
        if ("assembleSurvey".equalsIgnoreCase(importReq.getAction())) {
            List<Question> questionList;
            QuestionDao questionDao = new QuestionDao();
            boolean useBackend = false;
            if (!importReq.getIsForwarded().booleanValue() && "true".equalsIgnoreCase(PropertyUtil.getProperty(BACKEND_PUBLISH_PROP)) && (questionList = questionDao.listQuestionsBySurvey(importReq.getSurveyId())) != null && questionList.size() > 80) {
                useBackend = true;
            }
            if (useBackend) {
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/surveyassembly").param("action", "assembleSurvey").param("isFwd", "true").param("surveyId", importReq.getSurveyId().toString());
                options = options.header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
                Queue queue = QueueFactory.getQueue((String)"surveyAssembly");
                queue.add(options);
            } else {
                this.assembleSurveyOnePass(importReq.getSurveyId());
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(importReq.getSurveyId());
            SurveyUtils.notifyReportService(ids, "invalidate");
        } else if ("dispatchAssembleQuestionGroup".equalsIgnoreCase(importReq.getAction())) {
            this.dispatchAssembleQuestionGroup(importReq.getSurveyId(), importReq.getQuestionGroupId(), importReq.getTransactionId());
        } else if ("assembleQuestionGroup".equalsIgnoreCase(importReq.getAction())) {
            this.assembleQuestionGroups(importReq.getSurveyId(), importReq.getTransactionId());
        } else if ("distributeSurvey".equalsIgnoreCase(importReq.getAction())) {
            this.uploadSurvey(importReq.getSurveyId(), importReq.getTransactionId());
        } else if ("cleanup".equalsIgnoreCase(importReq.getAction())) {
            this.cleanupFragments(importReq.getSurveyId(), importReq.getTransactionId());
        }
        return response;
    }

    private void uploadSurvey(Long surveyId, Long transactionId) {
        SurveyContainerDao scDao = new SurveyContainerDao();
        SurveyContainer sc = scDao.findBySurveyId(surveyId);
        Properties props = System.getProperties();
        String document = sc.getSurveyDocument().getValue();
        String bucketName = props.getProperty("s3bucket");
        boolean uploadedFile = false;
        boolean uploadedZip = false;
        try {
            uploadedFile = S3Util.put(bucketName, props.getProperty(SURVEY_UPLOAD_DIR) + "/" + sc.getSurveyId() + ".xml", document.getBytes("UTF-8"), "text/xml", true);
        }
        catch (IOException e) {
            log.error((Object)("Error uploading file " + e.getMessage()), (Throwable)e);
        }
        ByteArrayOutputStream os = ZipUtil.generateZip(document, sc.getSurveyId() + ".xml");
        try {
            uploadedZip = S3Util.put(bucketName, props.getProperty(SURVEY_UPLOAD_DIR) + "/" + sc.getSurveyId() + ".zip", os.toByteArray(), "application/zip", true);
        }
        catch (Exception e) {
            log.error((Object)("Error uploading zip file: " + e.getMessage()), (Throwable)e);
        }
        this.sendQueueMessage("cleanup", surveyId, null, transactionId);
        Message message = new Message();
        message.setActionAbout("surveyAssembly");
        message.setObjectId(surveyId);
        if (uploadedFile && uploadedZip) {
            SurveyDAO surveyDao = new SurveyDAO();
            String messageText = "Published.  Please check: " + props.getProperty(SURVEY_UPLOAD_URL) + props.getProperty(SURVEY_UPLOAD_DIR) + "/" + surveyId + ".xml";
            message.setShortMessage(messageText);
            Survey s = surveyDao.getById(surveyId);
            if (s != null) {
                message.setObjectTitle(s.getPath() + "/" + s.getName());
            }
            message.setTransactionUUID(transactionId.toString());
            MessageDao messageDao = new MessageDao();
            messageDao.save(message);
        } else {
            String messageText = "Failed to publish: " + surveyId + "\n";
            message.setTransactionUUID(transactionId.toString());
            message.setShortMessage(messageText);
            MessageDao messageDao = new MessageDao();
            messageDao.save(message);
        }
    }

    private void cleanupFragments(Long surveyId, Long transactionId) {
        SurveyXMLFragmentDao sxmlfDao = new SurveyXMLFragmentDao();
        sxmlfDao.deleteFragmentsForSurvey(surveyId, transactionId);
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        HttpServletResponse httpResp = this.getResponse();
        httpResp.setStatus(200);
        httpResp.getWriter().print("OK");
        httpResp.flushBuffer();
    }

    private void assembleSurveyOnePass(Long surveyId) {
        log.warn((Object)("Starting assembly of " + surveyId));
        SurveyDAO surveyDao = new SurveyDAO();
        Survey s = surveyDao.getById(surveyId);
        SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
        SurveyGroup sg = (SurveyGroup)surveyGroupDao.getByKey(s.getSurveyGroupId());
        Long transactionId = this.randomNumber.nextLong();
        String lang = "en";
        if (s != null && s.getDefaultLanguageCode() != null) {
            lang = s.getDefaultLanguageCode();
        }
        String versionAttribute = s.getVersion() == null ? "" : "version='" + s.getVersion() + "'";
        String app = String.format("app=\"%s\"", StringEscapeUtils.escapeXml((String)SystemProperty.applicationId.get()));
        String name = s.getName();
        String surveyGroupId = "";
        String surveyGroupName = "";
        String registrationForm = "";
        String surveyIdKeyValue = "surveyId=\"" + surveyId + "\"";
        if (sg != null) {
            surveyGroupId = "surveyGroupId=\"" + sg.getKey().getId() + "\"";
            surveyGroupName = "surveyGroupName=\"" + StringEscapeUtils.escapeXml((String)sg.getCode()) + "\"";
            if (Boolean.TRUE.equals(sg.getMonitoringGroup())) {
                registrationForm = " registrationSurvey=\"" + sg.getNewLocaleSurveyId() + "\"";
            }
        }
        String surveyHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><survey name=\"" + StringEscapeUtils.escapeXml((String)name) + "\" defaultLanguageCode=\"" + lang + "\" " + versionAttribute + " " + app + registrationForm + " " + surveyGroupId + " " + surveyGroupName + " " + surveyIdKeyValue + ">";
        String surveyFooter = "</survey>";
        QuestionGroupDao qgDao = new QuestionGroupDao();
        TreeMap<Integer, QuestionGroup> qgList = qgDao.listQuestionGroupsBySurvey(surveyId);
        if (qgList != null) {
            StringBuilder surveyXML = new StringBuilder();
            surveyXML.append(surveyHeader);
            for (QuestionGroup item : qgList.values()) {
                log.warn((Object)("Assembling group " + item.getKey().getId() + " for survey " + surveyId));
                surveyXML.append(this.buildQuestionGroupXML(item));
            }
            surveyXML.append(surveyFooter);
            log.warn((Object)("Uploading " + surveyId));
            UploadStatusContainer uc = this.uploadSurveyXML(surveyId, surveyXML.toString());
            Message message = new Message();
            message.setActionAbout("surveyAssembly");
            message.setObjectId(surveyId);
            message.setObjectTitle(sg.getCode() + " / " + s.getName());
            if (uc.getUploadedFile().booleanValue() && uc.getUploadedZip().booleanValue()) {
                log.warn((Object)("Finishing assembly of " + surveyId));
                s.setStatus(Survey.Status.PUBLISHED);
                surveyDao.save(s);
                String messageText = "Published.  Please check: " + uc.getUrl();
                message.setShortMessage(messageText);
                message.setTransactionUUID(transactionId.toString());
                MessageDao messageDao = new MessageDao();
                messageDao.save(message);
            } else {
                String messageText = "Failed to publish: " + surveyId + "\n" + uc.getMessage();
                message.setTransactionUUID(transactionId.toString());
                message.setShortMessage(messageText);
                MessageDao messageDao = new MessageDao();
                messageDao.save(message);
            }
            log.warn((Object)("Completed onepass assembly method for " + surveyId));
        }
    }

    public UploadStatusContainer uploadSurveyXML(Long surveyId, String surveyXML) {
        Properties props = System.getProperties();
        String bucketName = props.getProperty("s3bucket");
        String document = surveyXML;
        boolean uploadedFile = false;
        boolean uploadedZip = false;
        try {
            uploadedFile = S3Util.put(bucketName, props.getProperty(SURVEY_UPLOAD_DIR) + "/" + surveyId + ".xml", document.getBytes("UTF-8"), "text/xml", true);
        }
        catch (IOException e) {
            log.error((Object)("Error uploading file: " + e.getMessage()), (Throwable)e);
        }
        ByteArrayOutputStream os = ZipUtil.generateZip(document, surveyId + ".xml");
        UploadStatusContainer uc = new UploadStatusContainer();
        try {
            uploadedZip = S3Util.put(bucketName, props.getProperty(SURVEY_UPLOAD_DIR) + "/" + surveyId + ".zip", os.toByteArray(), "application/zip", true);
        }
        catch (IOException e) {
            log.error((Object)("Error uploading file: " + e.getMessage()), (Throwable)e);
        }
        uc.setUploadedFile(uploadedFile);
        uc.setUploadedZip(uploadedZip);
        uc.setUrl(props.getProperty(SURVEY_UPLOAD_URL) + props.getProperty(SURVEY_UPLOAD_DIR) + "/" + surveyId + ".xml");
        return uc;
    }

    public String buildQuestionGroupXML(QuestionGroup item) {
        QuestionDao questionDao = new QuestionDao();
        QuestionGroupDao questionGroupDao = new QuestionGroupDao();
        QuestionGroup group = (QuestionGroup)questionGroupDao.getByKey(item.getKey().getId());
        TreeMap<Integer, Question> questionList = questionDao.listQuestionsByQuestionGroup(item.getKey().getId(), true);
        StringBuilder sb = new StringBuilder("<questionGroup").append(Boolean.TRUE.equals(group.getRepeatable()) ? " repeatable=\"true\"" : "").append("><heading>").append(StringEscapeUtils.escapeXml((String)group.getCode())).append("</heading>");
        if (questionList != null) {
            for (Question q : questionList.values()) {
                sb.append(this.marshallQuestion(q));
            }
        }
        return sb.toString() + "</questionGroup>";
    }

    private void sendQueueMessage(String action, Long surveyId, String questionGroups, Long transactionId) {
        Queue surveyAssemblyQueue = QueueFactory.getQueue((String)"surveyAssembly");
        TaskOptions task = TaskOptions.Builder.withUrl((String)"/app_worker/surveyassembly").param("action", action).param("surveyId", surveyId.toString());
        if (questionGroups != null) {
            task.param("questionGroupId", questionGroups);
        }
        if (transactionId != null) {
            task.param("transactionId", transactionId.toString());
        }
        surveyAssemblyQueue.add(task);
    }

    private void dispatchAssembleQuestionGroup(Long surveyId, String questionGroupIds, Long transactionId) {
        boolean isLast = true;
        String currentId = questionGroupIds;
        String remainingIds = null;
        if (questionGroupIds.contains(",")) {
            isLast = false;
            currentId = questionGroupIds.substring(0, questionGroupIds.indexOf(","));
            remainingIds = questionGroupIds.substring(questionGroupIds.indexOf(",") + 1);
        }
        QuestionDao questionDao = new QuestionDao();
        QuestionGroupDao questionGroupDao = new QuestionGroupDao();
        QuestionGroup group = (QuestionGroup)questionGroupDao.getByKey(Long.parseLong(currentId));
        TreeMap<Integer, Question> questionList = questionDao.listQuestionsByQuestionGroup(Long.parseLong(currentId), true);
        StringBuilder sb = new StringBuilder("<questionGroup").append(Boolean.TRUE.equals(group.getRepeatable()) ? " repeatable=\"true\"" : "").append("><heading>").append(group.getCode()).append("</heading>");
        if (questionList != null) {
            for (Question q : questionList.values()) {
                sb.append(this.marshallQuestion(q));
            }
        }
        SurveyXMLFragment sxf = new SurveyXMLFragment();
        sxf.setSurveyId(surveyId);
        sxf.setQuestionGroupId(Long.parseLong(currentId));
        sxf.setFragmentOrder(group.getOrder());
        sxf.setFragment(new com.google.appengine.api.datastore.Text(sb.append("</questionGroup>").toString()));
        sxf.setTransactionId(transactionId);
        sxf.setFragmentType(SurveyXMLFragment.FRAGMENT_TYPE.QUESTION_GROUP);
        SurveyXMLFragmentDao sxmlfDao = new SurveyXMLFragmentDao();
        sxmlfDao.save(sxf);
        if (isLast) {
            this.sendQueueMessage("assembleQuestionGroup", surveyId, null, transactionId);
        } else {
            this.sendQueueMessage("dispatchAssembleQuestionGroup", surveyId, remainingIds, transactionId);
        }
    }

    private String marshallQuestion(Question q) {
        CascadeResourceDao crDao;
        CascadeResource cr;
        AltText aText;
        ArrayList<AltText> translationList;
        SurveyXMLAdapter sax = new SurveyXMLAdapter();
        ObjectFactory objFactory = new ObjectFactory();
        com.gallatinsystems.survey.domain.xml.Question qXML = objFactory.createQuestion();
        qXML.setId(new String("" + q.getKey().getId() + ""));
        qXML.setMandatory("false");
        if (q.getText() != null) {
            Text t = new Text();
            t.setContent(q.getText());
            qXML.setText(t);
        }
        ArrayList<Help> helpList = new ArrayList<Help>();
        if (q.getTip() != null) {
            Help tip = new Help();
            Text t = new Text();
            t.setContent(q.getTip());
            tip.setText(t);
            tip.setType("tip");
            if (q.getTip() != null && q.getTip().trim().length() > 0 && !"null".equalsIgnoreCase(q.getTip().trim())) {
                TranslationDao tDao = new TranslationDao();
                HashMap<String, Translation> tipTrans = tDao.findTranslations(Translation.ParentType.QUESTION_TIP, q.getKey().getId());
                translationList = new ArrayList();
                for (Translation trans : tipTrans.values()) {
                    aText = new AltText();
                    aText.setContent(trans.getText());
                    aText.setLanguage(trans.getLanguageCode());
                    aText.setType("translation");
                    translationList.add(aText);
                }
                if (translationList.size() > 0) {
                    tip.setAltText(translationList);
                }
                helpList.add(tip);
            }
        }
        if (q.getQuestionHelpMediaMap() != null) {
            for (QuestionHelpMedia helpItem : q.getQuestionHelpMediaMap().values()) {
                Help tip = new Help();
                Text t = new Text();
                t.setContent(helpItem.getText());
                if (helpItem.getType() == QuestionHelpMedia.Type.TEXT) {
                    tip.setType("tip");
                } else {
                    tip.setType(helpItem.getType().toString().toLowerCase());
                    tip.setValue(helpItem.getResourceUrl());
                }
                if (helpItem.getTranslationMap() != null) {
                    translationList = new ArrayList<AltText>();
                    for (Translation trans : helpItem.getTranslationMap().values()) {
                        aText = new AltText();
                        aText.setContent(trans.getText());
                        aText.setLanguage(trans.getLanguageCode());
                        aText.setType("translation");
                        translationList.add(aText);
                    }
                    if (translationList.size() > 0) {
                        tip.setAltText(translationList);
                    }
                }
                helpList.add(tip);
            }
        }
        if (helpList.size() > 0) {
            qXML.setHelp(helpList);
        }
        boolean hasValidation = false;
        if (q.getType() == Question.Type.NUMBER && (q.getAllowDecimal() != null || q.getAllowSign() != null || q.getMinVal() != null || q.getMaxVal() != null)) {
            ValidationRule validationRule = objFactory.createValidationRule();
            validationRule.setValidationType("numeric");
            validationRule.setAllowDecimal(q.getAllowDecimal() != null ? q.getAllowDecimal().toString().toLowerCase() : "false");
            validationRule.setSigned(q.getAllowSign() != null ? q.getAllowSign().toString().toLowerCase() : "false");
            if (q.getMinVal() != null) {
                validationRule.setMinVal(q.getMinVal().toString());
            }
            if (q.getMaxVal() != null) {
                validationRule.setMaxVal(q.getMaxVal().toString());
            }
            qXML.setValidationRule(validationRule);
            hasValidation = true;
        }
        qXML.setAltText(this.formAltText(q.getTranslationMap()));
        if (q.getType().equals((Object)Question.Type.FREE_TEXT)) {
            qXML.setType(FREE_QUESTION_TYPE);
            if (q.getRequireDoubleEntry() != null && q.getRequireDoubleEntry().booleanValue()) {
                qXML.setRequireDoubleEntry(q.getRequireDoubleEntry().toString());
            }
        } else if (q.getType().equals((Object)Question.Type.GEO)) {
            qXML.setType(GEO_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.NUMBER)) {
            qXML.setType(FREE_QUESTION_TYPE);
            if (!hasValidation) {
                ValidationRule vrule = new ValidationRule();
                vrule.setValidationType("numeric");
                vrule.setSigned("false");
                qXML.setValidationRule(vrule);
            }
            if (q.getRequireDoubleEntry() != null && q.getRequireDoubleEntry().booleanValue()) {
                qXML.setRequireDoubleEntry(q.getRequireDoubleEntry().toString());
            }
        } else if (q.getType().equals((Object)Question.Type.OPTION)) {
            qXML.setType(OPTION_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.PHOTO)) {
            qXML.setType(PHOTO_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.VIDEO)) {
            qXML.setType(VIDEO_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.SCAN)) {
            qXML.setType(SCAN_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.STRENGTH)) {
            qXML.setType(STRENGTH_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.DATE)) {
            qXML.setType(DATE_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.CASCADE)) {
            qXML.setType(CASCADE_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.GEOSHAPE)) {
            qXML.setType(GEOSHAPE_QUESTION_TYPE);
            qXML.setAllowPoints(Boolean.toString(q.getAllowPoints()));
            qXML.setAllowLine(Boolean.toString(q.getAllowLine()));
            qXML.setAllowPolygon(Boolean.toString(q.getAllowPolygon()));
        } else if (q.getType().equals((Object)Question.Type.SIGNATURE)) {
            qXML.setType(SIGNATURE_QUESTION_TYPE);
        } else if (q.getType().equals((Object)Question.Type.CADDISFLY)) {
            qXML.setType(CADDISFLY_QUESTION_TYPE);
        }
        if (q.getType().equals((Object)Question.Type.CADDISFLY) && q.getCaddisflyResourceUuid() != null) {
            qXML.setCaddisflyResourceUuid(q.getCaddisflyResourceUuid());
        }
        if (q.getType().equals((Object)Question.Type.CASCADE) && q.getCascadeResourceId() != null && (cr = (CascadeResource)(crDao = new CascadeResourceDao()).getByKey(q.getCascadeResourceId())) != null) {
            qXML.setCascadeResource(cr.getResourceId());
            List<String> levelNames = cr.getLevelNames();
            if (levelNames != null && levelNames.size() > 0) {
                Levels levels = objFactory.createLevels();
                ArrayList<Level> levelList = new ArrayList<Level>();
                for (int i = 0; i < cr.getNumLevels(); ++i) {
                    Level levelItem = objFactory.createLevel();
                    Text t = new Text();
                    t.setContent(levelNames.get(i));
                    levelItem.addContent(t);
                    levelList.add(levelItem);
                }
                levels.setLevel(levelList);
                qXML.setLevels(levels);
            }
        }
        if (q.getOrder() != null) {
            qXML.setOrder(q.getOrder().toString());
        }
        if (q.getMandatoryFlag() != null) {
            qXML.setMandatory(q.getMandatoryFlag().toString());
        }
        qXML.setLocaleNameFlag("false");
        if (q.getLocaleNameFlag() != null) {
            qXML.setLocaleNameFlag(q.getLocaleNameFlag().toString());
        }
        if (q.getLocaleLocationFlag() != null && q.getLocaleLocationFlag().booleanValue()) {
            qXML.setLocaleLocationFlag("true");
        }
        if (Boolean.TRUE.equals(q.getAllowMultipleFlag())) {
            qXML.setAllowMultiple("true");
        }
        if (Boolean.TRUE.equals(q.getGeoLocked())) {
            qXML.setLocked("true");
        }
        Dependency dependency = objFactory.createDependency();
        if (q.getDependentQuestionId() != null) {
            dependency.setQuestion(q.getDependentQuestionId().toString());
            dependency.setAnswerValue(q.getDependentQuestionAnswer());
            qXML.setDependency(dependency);
        }
        if (q.getQuestionOptionMap() != null && q.getQuestionOptionMap().size() > 0) {
            Options options = objFactory.createOptions();
            if (q.getAllowOtherFlag() != null) {
                options.setAllowOther(q.getAllowOtherFlag().toString());
            }
            if (q.getAllowMultipleFlag() != null) {
                options.setAllowMultiple(q.getAllowMultipleFlag().toString());
            }
            if (options.getAllowMultiple() == null || "false".equals(options.getAllowMultiple())) {
                options.setRenderType(PropertyUtil.getProperty(OPTION_RENDER_MODE_PROP));
            }
            ArrayList optionList = new ArrayList();
            for (QuestionOption qo : q.getQuestionOptionMap().values()) {
                Option option = objFactory.createOption();
                Text t = new Text();
                t.setContent(qo.getText());
                option.addContent(t);
                option.setCode(qo.getCode());
                option.setValue(qo.getText());
                List<AltText> altTextList = this.formAltText(qo.getTranslationMap());
                if (altTextList != null) {
                    for (AltText alt : altTextList) {
                        option.addContent(alt);
                    }
                }
                optionList.add(option);
            }
            options.setOption(optionList);
            qXML.setOptions(options);
        }
        if (q.getScoringRules() != null) {
            Scoring scoring = new Scoring();
            for (ScoringRule rule : q.getScoringRules()) {
                Score score = new Score();
                if (scoring.getType() == null) {
                    scoring.setType(rule.getType().toLowerCase());
                }
                score.setRangeHigh(rule.getRangeMax());
                score.setRangeLow(rule.getRangeMin());
                score.setValue(rule.getValue());
                scoring.addScore(score);
            }
            if (scoring.getScore() != null && scoring.getScore().size() > 0) {
                qXML.setScoring(scoring);
            }
        }
        if ("true".equalsIgnoreCase(String.valueOf(q.getAllowExternalSources()))) {
            qXML.setAllowExternalSources(String.valueOf(q.getAllowExternalSources()));
        }
        String questionDocument = null;
        try {
            questionDocument = sax.marshal(qXML);
        }
        catch (JAXBException e) {
            log.warn((Object)("Could not marshal question: " + qXML), (Throwable)e);
        }
        questionDocument = questionDocument.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        return questionDocument;
    }

    private List<AltText> formAltText(Map<String, Translation> translationMap) {
        ArrayList<AltText> altTextList = new ArrayList<AltText>();
        if (translationMap != null) {
            for (Translation lang : translationMap.values()) {
                AltText alt = new AltText();
                alt.setContent(lang.getText());
                alt.setType("translation");
                alt.setLanguage(lang.getLanguageCode());
                altTextList.add(alt);
            }
        }
        return altTextList;
    }

    private void assembleQuestionGroups(Long surveyId, Long transactionId) {
        SurveyXMLFragmentDao sxmlfDao = new SurveyXMLFragmentDao();
        List<SurveyXMLFragment> sxmlfList = sxmlfDao.listSurveyFragments(surveyId, SurveyXMLFragment.FRAGMENT_TYPE.QUESTION_GROUP, transactionId);
        StringBuilder sbQG = new StringBuilder();
        for (SurveyXMLFragment item : sxmlfList) {
            sbQG.append(item.getFragment().getValue());
        }
        StringBuilder completeSurvey = new StringBuilder();
        String surveyHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><survey>";
        String surveyFooter = "</survey>";
        completeSurvey.append(surveyHeader);
        completeSurvey.append(sbQG.toString());
        sbQG = null;
        completeSurvey.append(surveyFooter);
        SurveyContainerDao scDao = new SurveyContainerDao();
        SurveyContainer sc = scDao.findBySurveyId(surveyId);
        if (sc == null) {
            sc = new SurveyContainer();
        }
        sc.setSurveyDocument(new com.google.appengine.api.datastore.Text(completeSurvey.toString()));
        sc.setSurveyId(surveyId);
        scDao.save(sc);
        this.sendQueueMessage("distributeSurvey", surveyId, null, transactionId);
    }
}

