/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.common.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.waterforpeople.mapping.domain.response.value.Media;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class ExportImportUtils {
    private static final Logger log = Logger.getLogger(ExportImportUtils.class);
    private static final ThreadLocal<DataFormatter> DATA_FORMATTER = new ThreadLocal<DataFormatter>(){

        @Override
        protected DataFormatter initialValue() {
            return new DataFormatter();
        }
    };
    private static final ThreadLocal<DateFormat> DATE_RESPONSE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss z");
        }
    };

    public static String parseCellAsString(Cell cell) {
        return DATA_FORMATTER.get().formatCellValue(cell).trim();
    }

    public static String md5Digest(List<Row> rows, int lastColumnIndex, Sheet limitedSheet) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        block0: for (Row row : rows) {
            for (Cell cell : row) {
                if (row.getSheet() == limitedSheet && cell.getColumnIndex() > lastColumnIndex) continue block0;
                String val = ExportImportUtils.parseCellAsString(cell);
                if (val == null || val.equals("")) continue;
                digest.update(val.getBytes());
            }
        }
        return StringUtil.toHexString(digest.digest());
    }

    public static String formatDateTime(Date date) {
        if (date != null) {
            return DATE_TIME_FORMAT.get().format(date);
        }
        return "";
    }

    public static String formatDateResponse(String value) {
        Date date = ExportImportUtils.parseDatastoreDate(value);
        if (date != null) {
            return DATE_RESPONSE_FORMAT.get().format(date);
        }
        return "";
    }

    public static Date parseDatastoreDate(String value) {
        try {
            return new Date(Long.valueOf(value));
        }
        catch (NumberFormatException e) {
            log.info((Object)("Value is not a valid timestamp: " + value));
            return ExportImportUtils.parseSpreadsheetDate(value);
        }
    }

    public static Date parseSpreadsheetDate(String dateString) {
        if (dateString == null || dateString.equals("")) {
            return null;
        }
        try {
            return DATE_TIME_FORMAT.get().parse(dateString);
        }
        catch (ParseException parseException) {
            try {
                return DATE_RESPONSE_FORMAT.get().parse(dateString);
            }
            catch (ParseException parseException2) {
                log.warn((Object)("Response doesn't contain a valid format: " + dateString));
                return null;
            }
        }
    }

    public static String formatImage(String prefix, String value) {
        int filenameIndex;
        String cell = "";
        Media media = MediaResponse.parse(value);
        String filename = media.getFilename();
        int n = filenameIndex = filename != null ? filename.lastIndexOf("/") + 1 : -1;
        if (filenameIndex > 0 && filenameIndex < filename.length()) {
            cell = prefix + filename.substring(filenameIndex);
        }
        return cell;
    }
}

