/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dao;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.WKTReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoIndexDao {
    private static final Logger log = Logger.getLogger(GeoIndexDao.class.getName());
    private static final String INDEX_BASE_URL = "http://dru-test.s3.amazonaws.com/gis/index/";

    public void saveRegionIndex(Map<String, String> regions) {
        STRtree index = new STRtree();
        try {
            for (String region : regions.keySet()) {
                GeometryFactory factory = new GeometryFactory();
                WKTReader reader = new WKTReader(factory);
                Polygon regionPolygon = (Polygon)reader.read(regions.get(region));
                index.insert(regionPolygon.getEnvelopeInternal(), (Object)regionPolygon);
                index.build();
                ByteArrayOutputStream byteArr = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(byteArr);
                oos.writeObject(index);
                oos.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not upload index", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRtree findGeoIndex(String regionUUID) {
        STRtree index = null;
        ObjectInputStream ois = null;
        try {
            URL url = new URL(INDEX_BASE_URL + regionUUID);
            ois = new ObjectInputStream(url.openStream());
            index = (STRtree)ois.readObject();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not download index", e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return index;
    }
}

