/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.domain;

import com.gallatinsystems.device.domain.DeviceFiles;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Question;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.Persistent;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.domain.SecuredObject;
import org.apache.commons.lang.StringUtils;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.analytics.domain.SurveyQuestionSummary;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;

@javax.jdo.annotations.PersistenceCapable(identityType=IdentityType.APPLICATION)
public class SurveyInstance
extends BaseDomain
implements SecuredObject,
PersistenceCapable {
    private static final long serialVersionUID = 5840846001731305734L;
    @Persistent
    private Long userID;
    @Persistent
    private Date collectionDate;
    private Long deviceFileId;
    @NotPersistent
    private DeviceFiles deviceFile;
    @NotPersistent
    private List<QuestionAnswerStore> questionAnswersStore;
    private Long surveyId;
    private Double formVersion;
    private String deviceIdentifier;
    private String submitterName;
    private String approvedFlag;
    private String uuid;
    private Long surveyedLocaleId;
    private String surveyedLocaleIdentifier;
    private String surveyedLocaleDisplayName;
    private String countryCode;
    private String community;
    private String localeGeoLocation;
    private Long surveyalTime;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public String getCountryCode() {
        return SurveyInstance.jdoGetcountryCode(this);
    }

    public void setCountryCode(String countryCode) {
        SurveyInstance.jdoSetcountryCode(this, countryCode);
    }

    public String getCommunity() {
        return SurveyInstance.jdoGetcommunity(this);
    }

    public void setCommunity(String community) {
        SurveyInstance.jdoSetcommunity(this, community);
    }

    public Long getSurveyedLocaleId() {
        return SurveyInstance.jdoGetsurveyedLocaleId(this);
    }

    public void setSurveyedLocaleId(Long surveyedLocaleId) {
        SurveyInstance.jdoSetsurveyedLocaleId(this, surveyedLocaleId);
    }

    public String getUuid() {
        return SurveyInstance.jdoGetuuid(this);
    }

    public void setUuid(String uuid) {
        SurveyInstance.jdoSetuuid(this, uuid);
    }

    public String getApprovedFlag() {
        return SurveyInstance.jdoGetapprovedFlag(this);
    }

    public void setApprovedFlag(String approvedFlag) {
        SurveyInstance.jdoSetapprovedFlag(this, approvedFlag);
    }

    public Long getSurveyId() {
        return SurveyInstance.jdoGetsurveyId(this);
    }

    public void setSurveyId(Long surveyId) {
        SurveyInstance.jdoSetsurveyId(this, surveyId);
    }

    public Long getUserID() {
        return SurveyInstance.jdoGetuserID(this);
    }

    public void setUserID(Long userID) {
        SurveyInstance.jdoSetuserID(this, userID);
    }

    public Date getCollectionDate() {
        return SurveyInstance.jdoGetcollectionDate(this);
    }

    public void setCollectionDate(Date collectionDate) {
        SurveyInstance.jdoSetcollectionDate(this, collectionDate);
    }

    public DeviceFiles getDeviceFile() {
        return this.deviceFile;
    }

    public void setDeviceFile(DeviceFiles deviceFile) {
        this.deviceFile = deviceFile;
        if (deviceFile.getKey() != null) {
            SurveyInstance.jdoSetdeviceFileId(this, deviceFile.getKey().getId());
        }
    }

    public List<QuestionAnswerStore> getQuestionAnswersStore() {
        return this.questionAnswersStore;
    }

    public void setQuestionAnswersStore(List<QuestionAnswerStore> questionAnswersStore) {
        this.questionAnswersStore = questionAnswersStore;
    }

    public void setSubmitterName(String name) {
        SurveyInstance.jdoSetsubmitterName(this, name);
    }

    public String getSubmitterName() {
        return SurveyInstance.jdoGetsubmitterName(this);
    }

    public void setDeviceIdentifier(String id) {
        SurveyInstance.jdoSetdeviceIdentifier(this, id);
    }

    public String getDeviceIdentifier() {
        return SurveyInstance.jdoGetdeviceIdentifier(this);
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            result.append("  ");
            try {
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                System.out.println(ex);
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public void setDeviceFileId(Long deviceFileId) {
        SurveyInstance.jdoSetdeviceFileId(this, deviceFileId);
    }

    public Long getDeviceFileId() {
        return SurveyInstance.jdoGetdeviceFileId(this);
    }

    public void setSurveyalTime(Long survetalTime) {
        SurveyInstance.jdoSetsurveyalTime(this, survetalTime);
    }

    public Long getSurveyalTime() {
        return SurveyInstance.jdoGetsurveyalTime(this);
    }

    public String getSurveyedLocaleIdentifier() {
        return SurveyInstance.jdoGetsurveyedLocaleIdentifier(this);
    }

    public void setSurveyedLocaleIdentifier(String surveyedLocaleIdentifier) {
        SurveyInstance.jdoSetsurveyedLocaleIdentifier(this, surveyedLocaleIdentifier);
    }

    public String getLocaleGeoLocation() {
        return SurveyInstance.jdoGetlocaleGeoLocation(this);
    }

    public void setLocaleGeoLocation(String localeGeoLocation) {
        SurveyInstance.jdoSetlocaleGeoLocation(this, localeGeoLocation);
    }

    public String getSurveyedLocaleDisplayName() {
        return SurveyInstance.jdoGetsurveyedLocaleDisplayName(this);
    }

    public void setSurveyedLocaleDisplayName(String surveyedLocaleDisplayName) {
        SurveyInstance.jdoSetsurveyedLocaleDisplayName(this, surveyedLocaleDisplayName != null && surveyedLocaleDisplayName.length() > 500 ? surveyedLocaleDisplayName.substring(0, 500).trim() : surveyedLocaleDisplayName);
    }

    public static Map<String, Object> retrieveGeoLocation(SurveyInstance surveyInstance) throws NumberFormatException {
        String[] tokens;
        HashMap<String, Double> geoLocationMap = null;
        String geoLocationString = null;
        if (StringUtils.isNotBlank((String)surveyInstance.getLocaleGeoLocation())) {
            geoLocationString = surveyInstance.getLocaleGeoLocation();
        }
        if ((tokens = StringUtils.split((String)geoLocationString, (String)"\\|")) != null && tokens.length >= 2) {
            geoLocationMap = new HashMap<String, Double>();
            geoLocationMap.put("latitude", Double.parseDouble(tokens[0]));
            geoLocationMap.put("longitude", Double.parseDouble(tokens[1]));
        }
        return geoLocationMap;
    }

    public void updateSummaryCounts(boolean increment) {
        SurveyQuestionSummaryDao summaryDao = new SurveyQuestionSummaryDao();
        QuestionDao qDao = new QuestionDao();
        ArrayList<SurveyQuestionSummary> saveList = new ArrayList<SurveyQuestionSummary>();
        ArrayList<SurveyQuestionSummary> deleteList = new ArrayList<SurveyQuestionSummary>();
        for (QuestionAnswerStore response : this.questionAnswersStore) {
            Long questionId = Long.parseLong(response.getQuestionID());
            Question question = qDao.getByKey(questionId);
            if (question == null || !question.canBeCharted()) continue;
            String questionIdStr = response.getQuestionID();
            String[] questionResponse = DataUtils.optionResponsesTextArray(response.getValue());
            for (int i = 0; i < questionResponse.length; ++i) {
                List<SurveyQuestionSummary> questionSummaryList = summaryDao.listByResponse(questionIdStr, questionResponse[i]);
                SurveyQuestionSummary questionSummary = null;
                if (questionSummaryList.isEmpty()) {
                    questionSummary = new SurveyQuestionSummary();
                    questionSummary.setQuestionId(response.getQuestionID());
                    questionSummary.setResponse(questionResponse[i]);
                    questionSummary.setCount(0L);
                } else {
                    questionSummary = questionSummaryList.get(0);
                }
                long count = questionSummary.getCount() == null ? 0L : questionSummary.getCount();
                count = increment ? (count = count + 1L) : (count = count - 1L);
                questionSummary.setCount(count);
                if (count > 0L) {
                    saveList.add(questionSummary);
                    continue;
                }
                deleteList.add(questionSummary);
            }
        }
        summaryDao.save((List<SurveyQuestionSummary>)saveList);
        summaryDao.delete((List<SurveyQuestionSummary>)deleteList);
    }

    @Override
    public SecuredObject getParentObject() {
        if (SurveyInstance.jdoGetsurveyId(this) == null) {
            return null;
        }
        return (SecuredObject)new SurveyDAO().getByKey(SurveyInstance.jdoGetsurveyId(this));
    }

    @Override
    public Long getObjectId() {
        if (BaseDomain.jdoGetkey(this) == null) {
            return null;
        }
        return BaseDomain.jdoGetkey(this).getId();
    }

    @Override
    public List<Long> listAncestorIds() {
        if (SurveyInstance.jdoGetsurveyId(this) == null) {
            return Collections.emptyList();
        }
        SecuredObject s = (SecuredObject)new SurveyDAO().getByKey(SurveyInstance.jdoGetsurveyId(this));
        if (s == null) {
            return Collections.emptyList();
        }
        return s.listAncestorIds();
    }

    @Override
    public List<BaseDomain> updateAncestorIds(boolean cascade) {
        return Collections.emptyList();
    }

    public Double getFormVersion() {
        return SurveyInstance.jdoGetformVersion(this);
    }

    public void setFormVersion(Double formVersion) {
        SurveyInstance.jdoSetformVersion(this, formVersion);
    }

    static {
        jdoFieldNames = SurveyInstance.__jdoFieldNamesInit();
        jdoFieldTypes = SurveyInstance.__jdoFieldTypesInit();
        jdoFieldFlags = SurveyInstance.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = SurveyInstance.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = SurveyInstance.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)SurveyInstance.___jdo$loadClass("org.waterforpeople.mapping.domain.SurveyInstance"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new SurveyInstance());
    }

    @Override
    public boolean jdoIsDetached() {
        return false;
    }

    @Override
    public PersistenceCapable jdoNewInstance(StateManager sm) {
        SurveyInstance result = new SurveyInstance();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    @Override
    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        SurveyInstance result = new SurveyInstance();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - jdoInheritedFieldCount) {
            case 0: {
                this.approvedFlag = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.collectionDate = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.community = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.countryCode = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.deviceFileId = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.deviceIdentifier = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.formVersion = (Double)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.localeGeoLocation = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.submitterName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.surveyId = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.surveyalTime = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.surveyedLocaleDisplayName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.surveyedLocaleId = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.surveyedLocaleIdentifier = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.userID = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.uuid = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                super.jdoReplaceField(index);
            }
        }
    }

    @Override
    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - jdoInheritedFieldCount) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.approvedFlag);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.collectionDate);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.community);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.countryCode);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.deviceFileId);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.deviceIdentifier);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formVersion);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localeGeoLocation);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.submitterName);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.surveyId);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.surveyalTime);
                break;
            }
            case 11: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.surveyedLocaleDisplayName);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.surveyedLocaleId);
                break;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.surveyedLocaleIdentifier);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.userID);
                break;
            }
            case 15: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.uuid);
                break;
            }
            default: {
                super.jdoProvideField(index);
            }
        }
    }

    protected final void jdoCopyField(SurveyInstance obj, int index) {
        switch (index - jdoInheritedFieldCount) {
            case 0: {
                this.approvedFlag = obj.approvedFlag;
                break;
            }
            case 1: {
                this.collectionDate = obj.collectionDate;
                break;
            }
            case 2: {
                this.community = obj.community;
                break;
            }
            case 3: {
                this.countryCode = obj.countryCode;
                break;
            }
            case 4: {
                this.deviceFileId = obj.deviceFileId;
                break;
            }
            case 5: {
                this.deviceIdentifier = obj.deviceIdentifier;
                break;
            }
            case 6: {
                this.formVersion = obj.formVersion;
                break;
            }
            case 7: {
                this.localeGeoLocation = obj.localeGeoLocation;
                break;
            }
            case 8: {
                this.submitterName = obj.submitterName;
                break;
            }
            case 9: {
                this.surveyId = obj.surveyId;
                break;
            }
            case 10: {
                this.surveyalTime = obj.surveyalTime;
                break;
            }
            case 11: {
                this.surveyedLocaleDisplayName = obj.surveyedLocaleDisplayName;
                break;
            }
            case 12: {
                this.surveyedLocaleId = obj.surveyedLocaleId;
                break;
            }
            case 13: {
                this.surveyedLocaleIdentifier = obj.surveyedLocaleIdentifier;
                break;
            }
            case 14: {
                this.userID = obj.userID;
                break;
            }
            case 15: {
                this.uuid = obj.uuid;
                break;
            }
            default: {
                super.jdoCopyField(obj, index);
            }
        }
    }

    @Override
    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof SurveyInstance)) {
            throw new IllegalArgumentException("object is not an object of type org.waterforpeople.mapping.domain.SurveyInstance");
        }
        SurveyInstance other = (SurveyInstance)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"approvedFlag", "collectionDate", "community", "countryCode", "deviceFileId", "deviceIdentifier", "formVersion", "localeGeoLocation", "submitterName", "surveyId", "surveyalTime", "surveyedLocaleDisplayName", "surveyedLocaleId", "surveyedLocaleIdentifier", "userID", "uuid"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.util.Date"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.Long"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.Double"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.Long"), SurveyInstance.___jdo$loadClass("java.lang.Long"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.Long"), SurveyInstance.___jdo$loadClass("java.lang.String"), SurveyInstance.___jdo$loadClass("java.lang.Long"), SurveyInstance.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return BaseDomain.jdoGetManagedFieldCount();
    }

    protected static int jdoGetManagedFieldCount() {
        return 16 + BaseDomain.jdoGetManagedFieldCount();
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return SurveyInstance.___jdo$loadClass("com.gallatinsystems.framework.domain.BaseDomain");
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        SurveyInstance o = (SurveyInstance)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static String jdoGetapprovedFlag(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0 + jdoInheritedFieldCount, objPC.approvedFlag);
        }
        return objPC.approvedFlag;
    }

    private static void jdoSetapprovedFlag(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0 + jdoInheritedFieldCount, objPC.approvedFlag, val);
        } else {
            objPC.approvedFlag = val;
        }
    }

    private static Date jdoGetcollectionDate(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1 + jdoInheritedFieldCount)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1 + jdoInheritedFieldCount, (Object)objPC.collectionDate);
        }
        return objPC.collectionDate;
    }

    private static void jdoSetcollectionDate(SurveyInstance objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1 + jdoInheritedFieldCount, (Object)objPC.collectionDate, (Object)val);
        } else {
            objPC.collectionDate = val;
        }
    }

    private static String jdoGetcommunity(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2 + jdoInheritedFieldCount, objPC.community);
        }
        return objPC.community;
    }

    private static void jdoSetcommunity(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2 + jdoInheritedFieldCount, objPC.community, val);
        } else {
            objPC.community = val;
        }
    }

    private static String jdoGetcountryCode(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3 + jdoInheritedFieldCount, objPC.countryCode);
        }
        return objPC.countryCode;
    }

    private static void jdoSetcountryCode(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3 + jdoInheritedFieldCount, objPC.countryCode, val);
        } else {
            objPC.countryCode = val;
        }
    }

    private static Long jdoGetdeviceFileId(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4 + jdoInheritedFieldCount)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4 + jdoInheritedFieldCount, (Object)objPC.deviceFileId);
        }
        return objPC.deviceFileId;
    }

    private static void jdoSetdeviceFileId(SurveyInstance objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4 + jdoInheritedFieldCount, (Object)objPC.deviceFileId, (Object)val);
        } else {
            objPC.deviceFileId = val;
        }
    }

    private static String jdoGetdeviceIdentifier(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5 + jdoInheritedFieldCount, objPC.deviceIdentifier);
        }
        return objPC.deviceIdentifier;
    }

    private static void jdoSetdeviceIdentifier(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5 + jdoInheritedFieldCount, objPC.deviceIdentifier, val);
        } else {
            objPC.deviceIdentifier = val;
        }
    }

    private static Double jdoGetformVersion(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6 + jdoInheritedFieldCount)) {
            return (Double)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6 + jdoInheritedFieldCount, (Object)objPC.formVersion);
        }
        return objPC.formVersion;
    }

    private static void jdoSetformVersion(SurveyInstance objPC, Double val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6 + jdoInheritedFieldCount, (Object)objPC.formVersion, (Object)val);
        } else {
            objPC.formVersion = val;
        }
    }

    private static String jdoGetlocaleGeoLocation(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7 + jdoInheritedFieldCount, objPC.localeGeoLocation);
        }
        return objPC.localeGeoLocation;
    }

    private static void jdoSetlocaleGeoLocation(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7 + jdoInheritedFieldCount, objPC.localeGeoLocation, val);
        } else {
            objPC.localeGeoLocation = val;
        }
    }

    private static String jdoGetsubmitterName(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8 + jdoInheritedFieldCount, objPC.submitterName);
        }
        return objPC.submitterName;
    }

    private static void jdoSetsubmitterName(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8 + jdoInheritedFieldCount, objPC.submitterName, val);
        } else {
            objPC.submitterName = val;
        }
    }

    private static Long jdoGetsurveyId(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9 + jdoInheritedFieldCount)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9 + jdoInheritedFieldCount, (Object)objPC.surveyId);
        }
        return objPC.surveyId;
    }

    private static void jdoSetsurveyId(SurveyInstance objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9 + jdoInheritedFieldCount, (Object)objPC.surveyId, (Object)val);
        } else {
            objPC.surveyId = val;
        }
    }

    private static Long jdoGetsurveyalTime(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10 + jdoInheritedFieldCount)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10 + jdoInheritedFieldCount, (Object)objPC.surveyalTime);
        }
        return objPC.surveyalTime;
    }

    private static void jdoSetsurveyalTime(SurveyInstance objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10 + jdoInheritedFieldCount, (Object)objPC.surveyalTime, (Object)val);
        } else {
            objPC.surveyalTime = val;
        }
    }

    private static String jdoGetsurveyedLocaleDisplayName(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 11 + jdoInheritedFieldCount, objPC.surveyedLocaleDisplayName);
        }
        return objPC.surveyedLocaleDisplayName;
    }

    private static void jdoSetsurveyedLocaleDisplayName(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 11 + jdoInheritedFieldCount, objPC.surveyedLocaleDisplayName, val);
        } else {
            objPC.surveyedLocaleDisplayName = val;
        }
    }

    private static Long jdoGetsurveyedLocaleId(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12 + jdoInheritedFieldCount)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12 + jdoInheritedFieldCount, (Object)objPC.surveyedLocaleId);
        }
        return objPC.surveyedLocaleId;
    }

    private static void jdoSetsurveyedLocaleId(SurveyInstance objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12 + jdoInheritedFieldCount, (Object)objPC.surveyedLocaleId, (Object)val);
        } else {
            objPC.surveyedLocaleId = val;
        }
    }

    private static String jdoGetsurveyedLocaleIdentifier(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 13 + jdoInheritedFieldCount, objPC.surveyedLocaleIdentifier);
        }
        return objPC.surveyedLocaleIdentifier;
    }

    private static void jdoSetsurveyedLocaleIdentifier(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13 + jdoInheritedFieldCount, objPC.surveyedLocaleIdentifier, val);
        } else {
            objPC.surveyedLocaleIdentifier = val;
        }
    }

    private static Long jdoGetuserID(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14 + jdoInheritedFieldCount)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14 + jdoInheritedFieldCount, (Object)objPC.userID);
        }
        return objPC.userID;
    }

    private static void jdoSetuserID(SurveyInstance objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14 + jdoInheritedFieldCount, (Object)objPC.userID, (Object)val);
        } else {
            objPC.userID = val;
        }
    }

    private static String jdoGetuuid(SurveyInstance objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 15 + jdoInheritedFieldCount, objPC.uuid);
        }
        return objPC.uuid;
    }

    private static void jdoSetuuid(SurveyInstance objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 15 + jdoInheritedFieldCount, objPC.uuid, val);
        } else {
            objPC.uuid = val;
        }
    }
}

