/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.user.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.user.domain.UserAuthorization;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class UserAuthorizationDAO
extends BaseDAO<UserAuthorization> {
    public UserAuthorizationDAO() {
        super(UserAuthorization.class);
    }

    public List<UserAuthorization> listByObjectPath(Long userId, String objectPath) {
        if (objectPath == null) {
            return Collections.emptyList();
        }
        List<String> paths = SurveyUtils.listParentPaths(objectPath, true);
        paths.add(objectPath);
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = "userId == :p1 && :p2.contains(objectPath)";
        Query query = pm.newQuery(UserAuthorization.class, queryString);
        List results = (List)query.execute((Object)userId, paths);
        return results;
    }

    public List<UserAuthorization> listByObjectIds(Long userId, List<Long> ancestorIds) {
        if (ancestorIds == null || ancestorIds.isEmpty()) {
            return Collections.emptyList();
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = "userId == :p1 && :p2.contains(securedObjectId)";
        Query query = pm.newQuery(UserAuthorization.class, queryString);
        List results = (List)query.execute((Object)userId, ancestorIds);
        return results;
    }

    public List<UserAuthorization> listByUser(Long userId) {
        return this.listByProperty("userId", userId, "Long");
    }

    public UserAuthorization findUserAuthorization(Long userId, Long roleId, Long secureObjectId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(UserAuthorization.class);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        this.appendNonNullParam("userId", filterString, paramString, "Long", userId, paramMap);
        this.appendNonNullParam("roleId", filterString, paramString, "Long", roleId, paramMap);
        this.appendNonNullParam("securedObjectId", filterString, paramString, "Long", secureObjectId, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        List authList = (List)query.executeWithMap(paramMap);
        if (authList.isEmpty()) {
            return null;
        }
        return (UserAuthorization)authList.get(0);
    }

    public List<UserAuthorization> findFirstAssignedByRole(Long roleId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(UserAuthorization.class);
        query.setFilter("roleId == roleIdParam");
        query.declareParameters("Long roleIdParam");
        query.setRange(0L, 1L);
        List results = (List)query.execute((Object)roleId);
        return results;
    }

    @Override
    public UserAuthorization save(UserAuthorization auth) {
        return super.save(auth);
    }

    @Override
    public void delete(UserAuthorization auth) {
        super.delete(auth);
    }
}

