/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.DataExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class SurveyFormExporter
implements DataExporter {
    private static final Logger log = Logger.getLogger(SurveyFormExporter.class);
    private static final String PAPER_SHEET_NAME = "Paper Survey";
    private static final String FULL_SHEET_NAME = "Full Survey";
    private static final int COL_WIDTH = 10000;
    private static final String LANG_DELIM = " / ";
    private static final String DEP_HEAD = "Only answer if you responded ";
    private static final String DEP_HEAD_TO = " to ";
    private static final String BLANK = "_________________________";
    private static final String SMALL_BLANK = "______";
    private static final String QUESTION_HEADER = "Question";
    private static final String RESPONSE_HEADER = "Response";
    private static final String SURVEY_ID_KEY = "surveyId";
    private static final String OPTION_SEPARATOR = "|";
    private Map<Long, Long> idToNumberMap;
    private List<QuestionGroupDto> groupList;
    private String surveyTitle;
    private Map<QuestionGroupDto, List<QuestionDto>> questionMap;

    @Override
    public void export(Map<String, String> criteria, File fileName, String serverBase, Map<String, String> options) {
        try {
            String surveyId = criteria.get(SURVEY_ID_KEY);
            String apiKey = criteria.get("apiKey");
            this.populateQuestionMap(surveyId, serverBase, apiKey);
            List<SurveyDto> surveys = BulkDataServiceClient.fetchSurvey(Long.parseLong(surveyId), serverBase, apiKey);
            if (surveys == null || surveys.isEmpty()) {
                this.surveyTitle = "";
            } else {
                SurveyDto surveyDto = surveys.get(0);
                this.surveyTitle = String.format("%s (v. %s)", surveyDto.getName(), surveyDto.getVersion());
            }
            this.writeSurvey(this.surveyTitle, fileName, this.groupList, this.questionMap);
        }
        catch (Exception e) {
            log.error((Object)"Could not write survey", (Throwable)e);
        }
    }

    private void populateQuestionMap(String surveyId, String serverBase, String apiKey) throws Exception {
        this.groupList = BulkDataServiceClient.fetchQuestionGroups(serverBase, surveyId, apiKey);
        this.questionMap = new HashMap<QuestionGroupDto, List<QuestionDto>>();
        this.idToNumberMap = new HashMap<Long, Long>();
        if (this.groupList != null) {
            Long count = 1L;
            for (QuestionGroupDto group : this.groupList) {
                List<QuestionDto> questions = BulkDataServiceClient.fetchQuestions(serverBase, group.getKeyId(), apiKey);
                if (questions == null) continue;
                ArrayList<QuestionDto> fullQuestions = new ArrayList<QuestionDto>();
                for (QuestionDto q : questions) {
                    QuestionDto fullQ = BulkDataServiceClient.loadQuestionDetails(serverBase, q.getKeyId(), apiKey);
                    if (fullQ == null) continue;
                    fullQuestions.add(fullQ);
                    Long l = count;
                    Long l2 = count = Long.valueOf(count + 1L);
                    this.idToNumberMap.put(fullQ.getKeyId(), l);
                }
                this.questionMap.put(group, fullQuestions);
            }
        }
    }

    private void writeSurvey(String title, File fileName, List<QuestionGroupDto> groupList, Map<QuestionGroupDto, List<QuestionDto>> questions) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setAlignment((short)2);
        HSSFFont headerFont = wb.createFont();
        headerFont.setBoldweight((short)700);
        headerStyle.setFont(headerFont);
        HSSFCellStyle questionStyle = wb.createCellStyle();
        questionStyle.setVerticalAlignment((short)0);
        questionStyle.setWrapText(true);
        HSSFCellStyle depStyle = wb.createCellStyle();
        depStyle.setAlignment((short)2);
        HSSFFont depFont = wb.createFont();
        depFont.setBoldweight((short)700);
        depFont.setItalic(true);
        depStyle.setFont(depFont);
        this.writePaperSheet(title, groupList, questions, wb, headerStyle, questionStyle, depStyle);
        this.writeFullSheet(wb, title, groupList, questions);
        FileOutputStream fileOut = new FileOutputStream(fileName);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    private void writePaperSheet(String title, List<QuestionGroupDto> groupList, Map<QuestionGroupDto, List<QuestionDto>> questions, HSSFWorkbook wb, HSSFCellStyle headerStyle, HSSFCellStyle questionStyle, HSSFCellStyle depStyle) {
        HSSFSheet sheet = wb.createSheet(PAPER_SHEET_NAME);
        sheet.setColumnWidth(0, 10000);
        sheet.setColumnWidth(1, 10000);
        int curRow = 0;
        HSSFRow row = sheet.createRow(curRow++);
        sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 1));
        this.createCell(row, 0, title, headerStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, QUESTION_HEADER, headerStyle);
        this.createCell(row, 1, RESPONSE_HEADER, headerStyle);
        Long count = 1L;
        if (questions != null) {
            for (int i = 0; i < groupList.size(); ++i) {
                HSSFRow groupHeaderRow = sheet.createRow(curRow++);
                sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 1));
                this.createCell(groupHeaderRow, 0, groupList.get(i).getDisplayName(), headerStyle);
                for (QuestionDto q : questions.get(groupList.get(i))) {
                    int questionStartRow = curRow;
                    HSSFRow tempRow = sheet.createRow(curRow++);
                    if (q.getQuestionDependency() != null) {
                        sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 1));
                        Long qNum = this.idToNumberMap.get(q.getQuestionDependency().getQuestionId());
                        this.createCell(tempRow, 0, DEP_HEAD + q.getQuestionDependency().getAnswerValue() + DEP_HEAD_TO + "Q" + qNum, depStyle);
                        tempRow = sheet.createRow(curRow++);
                        questionStartRow = curRow;
                    }
                    Long l = count;
                    Long l2 = count = Long.valueOf(count + 1L);
                    this.createCell(tempRow, 0, l + ". " + this.formText(q.getText(), q.getTranslationMap()), questionStyle);
                    if (q.getOptionContainerDto() != null && q.getOptionContainerDto().getOptionsList() != null) {
                        for (QuestionOptionDto opt : q.getOptionContainerDto().getOptionsList()) {
                            tempRow = sheet.createRow(curRow++);
                            this.createCell(tempRow, 1, this.formText(opt.getText(), opt.getTranslationMap()) + SMALL_BLANK, null);
                        }
                        sheet.addMergedRegion(new CellRangeAddress(questionStartRow, curRow - 1, 0, 0));
                        continue;
                    }
                    this.createCell(tempRow, 1, BLANK, null);
                }
            }
        }
    }

    private void writeFullSheet(HSSFWorkbook wb, String title, List<QuestionGroupDto> groupList, Map<QuestionGroupDto, List<QuestionDto>> questions) throws Exception {
        HSSFSheet sheet = wb.createSheet(FULL_SHEET_NAME);
        HSSFCellStyle headerCtr = wb.createCellStyle();
        headerCtr.setAlignment((short)2);
        headerCtr.setVerticalAlignment((short)0);
        HSSFFont headerFont = wb.createFont();
        headerFont.setBoldweight((short)700);
        headerCtr.setFont(headerFont);
        headerCtr.setWrapText(true);
        HSSFCellStyle headerLeft = wb.createCellStyle();
        headerLeft.setFont(headerFont);
        HSSFCellStyle optionStyle = wb.createCellStyle();
        optionStyle.setVerticalAlignment((short)0);
        optionStyle.setWrapText(true);
        int startRow = this.createFullHeader(sheet, 0, headerCtr);
        int count = 0;
        if (questions != null) {
            int i;
            HashMap<Long, String> qTextFromId = new HashMap<Long, String>();
            for (i = 0; i < groupList.size(); ++i) {
                for (QuestionDto q : questions.get(groupList.get(i))) {
                    qTextFromId.put(q.getKeyId(), q.getText());
                }
            }
            for (i = 0; i < groupList.size(); ++i) {
                int firstRowInGroup = startRow + count;
                for (QuestionDto q : questions.get(groupList.get(i))) {
                    int r = startRow + count;
                    ++count;
                    HSSFRow row = sheet.createRow(r);
                    if (r == firstRowInGroup) {
                        this.createCell(row, 0, Long.valueOf(i + 1), headerCtr);
                        this.createCell(row, 1, groupList.get(i).getDisplayName(), headerCtr);
                        this.createCell(row, 2, groupList.get(i).getRepeatable(), headerCtr);
                    }
                    this.createCell(row, 3, (long)q.getOrder(), headerCtr);
                    this.createCell(row, 4, Long.valueOf(count), headerCtr);
                    this.createCell(row, 5, this.formText(q.getText(), q.getTranslationMap()), headerLeft);
                    this.createCell(row, 6, q.getTip(), null);
                    this.createCell(row, 7, q.getVariableName(), null);
                    this.createCell(row, 8, this.typeString(q), null);
                    this.createCell(row, 9, q.getMandatoryFlag(), null);
                    this.createCell(row, 10, q.getLocaleNameFlag(), null);
                    this.createCell(row, 11, q.getRequireDoubleEntry(), null);
                    this.createCell(row, 12, q.getDependentFlag(), null);
                    this.createCell(row, 13, (String)qTextFromId.get(q.getDependentQuestionId()), null);
                    this.createCell(row, 14, q.getDependentQuestionAnswer(), null);
                    this.createCell(row, 15, q.getAllowSign(), null);
                    this.createCell(row, 16, q.getAllowDecimal(), null);
                    this.createCell(row, 17, q.getMinVal(), null);
                    this.createCell(row, 18, q.getMaxVal(), null);
                    this.createCell(row, 19, this.optionString(q), optionStyle);
                    this.createCell(row, 20, q.getType() == QuestionDto.QuestionType.OPTION ? q.getAllowMultipleFlag() : null, null);
                    this.createCell(row, 21, q.getAllowOtherFlag(), null);
                    this.createCell(row, 22, q.getLocaleLocationFlag(), null);
                    this.createCell(row, 23, q.getType() == QuestionDto.QuestionType.GEO ? q.getGeoLocked() : null, null);
                    this.createCell(row, 24, q.getCascadeResourceId(), null);
                    this.createCell(row, 25, q.getAllowPoints(), null);
                    this.createCell(row, 26, q.getAllowLine(), null);
                    this.createCell(row, 27, q.getAllowPolygon(), null);
                    this.createCell(row, 28, q.getCaddisflyResourceUuid(), null);
                    this.createCell(row, 29, q.getType() == QuestionDto.QuestionType.SCAN ? q.getAllowMultipleFlag() : null, null);
                    this.createCell(row, 30, q.getType() == QuestionDto.QuestionType.SCAN ? q.getGeoLocked() : null, null);
                }
                sheet.addMergedRegion(new CellRangeAddress(firstRowInGroup, startRow + count - 1, 0, 0));
                sheet.addMergedRegion(new CellRangeAddress(firstRowInGroup, startRow + count - 1, 1, 1));
                sheet.addMergedRegion(new CellRangeAddress(firstRowInGroup, startRow + count - 1, 2, 2));
            }
        }
    }

    private int createFullHeader(HSSFSheet sheet, int startRow, HSSFCellStyle style) {
        int r = startRow;
        int c = 0;
        HSSFRow row = sheet.createRow(r++);
        row = sheet.createRow(r++);
        this.createCellBlock(row, 0, "Group", style, 3);
        this.createCellBlock(row, 3, QUESTION_HEADER, style, 3);
        c = 12;
        this.createCellBlock(row, c, "Dependency", style, 3);
        this.createCellBlock(row, c += 3, "Numbers", style, 4);
        this.createCellBlock(row, c += 4, "Options", style, 3);
        this.createCellBlock(row, c += 3, "Geolocation", style, 2);
        this.createCell(row, c += 2, "Cascade", style);
        this.createCellBlock(row, ++c, "Geographic area", style, 3);
        this.createCell(row, c += 3, "Caddisfly", style);
        this.createCellBlock(row, ++c, "Barcode", style, 2);
        row = sheet.createRow(r++);
        c = 0;
        this.createCell(row, c, "#", style);
        this.createCell(row, ++c, "Title", style);
        this.createCell(row, ++c, "Repeatable", style);
        this.createCell(row, ++c, "# in group", style);
        this.createCell(row, ++c, "# in form", style);
        this.createCell(row, ++c, "Text", style);
        this.createCell(row, ++c, "Question help", style);
        this.createCell(row, ++c, "Variable name", style);
        this.createCell(row, ++c, "Question type", style);
        this.createCell(row, ++c, "Mandatory", style);
        this.createCell(row, ++c, "Data point name", style);
        this.createCell(row, ++c, "Double entry", style);
        this.createCell(row, ++c, "Dependent", style);
        this.createCell(row, ++c, QUESTION_HEADER, style);
        this.createCell(row, ++c, "Answer(s)", style);
        this.createCell(row, ++c, "Allow sign", style);
        this.createCell(row, ++c, "Allow decimal point", style);
        this.createCell(row, ++c, "Max value", style);
        this.createCell(row, ++c, "Min value", style);
        this.createCell(row, ++c, "Options", style);
        this.createCell(row, ++c, "Allow multiple", style);
        this.createCell(row, ++c, "Allow other", style);
        this.createCell(row, ++c, "Data Point location", style);
        this.createCell(row, ++c, "Disable manual editing", style);
        this.createCell(row, ++c, "Resource", style);
        this.createCell(row, ++c, "Points", style);
        this.createCell(row, ++c, "Lines", style);
        this.createCell(row, ++c, "Areas", style);
        this.createCell(row, ++c, "Resource", style);
        this.createCell(row, ++c, "Multiple", style);
        this.createCell(row, ++c, "Disable manual editing", style);
        sheet.createFreezePane(6, 3);
        return r;
    }

    private HSSFCell createCell(HSSFRow row, int col, String value, HSSFCellStyle style) {
        HSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null) {
            cell.setCellValue(value);
        }
        return cell;
    }

    private HSSFCell createCell(HSSFRow row, int col, Double value, HSSFCellStyle style) {
        HSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null) {
            cell.setCellValue(value.doubleValue());
        }
        return cell;
    }

    private HSSFCell createCell(HSSFRow row, int col, Long value, HSSFCellStyle style) {
        HSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null) {
            cell.setCellValue((double)value.longValue());
        }
        return cell;
    }

    private HSSFCell createCell(HSSFRow row, int col, Boolean value, HSSFCellStyle style) {
        HSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null && value.booleanValue()) {
            cell.setCellValue("Yes");
        }
        return cell;
    }

    private HSSFCell createCellBlock(HSSFRow row, int col, String value, HSSFCellStyle style, int width) {
        HSSFCell cell = row.createCell(col);
        if (width > 1) {
            row.getSheet().addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), col, col + width - 1));
        }
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null) {
            cell.setCellValue(value);
        }
        return cell;
    }

    private String optionString(QuestionDto q) {
        String s = "";
        if (q.getOptionContainerDto() != null && q.getOptionContainerDto().getOptionsList() != null) {
            for (QuestionOptionDto opt : q.getOptionContainerDto().getOptionsList()) {
                s = s + this.formText(opt.getText(), opt.getTranslationMap()) + OPTION_SEPARATOR;
            }
        }
        if (s.endsWith(OPTION_SEPARATOR)) {
            s = s.substring(0, s.length() - OPTION_SEPARATOR.length());
        }
        return s;
    }

    private String typeString(QuestionDto q) {
        if (q != null) {
            switch (q.getType()) {
                case FREE_TEXT: {
                    return "Free Text";
                }
                case OPTION: {
                    return "Option";
                }
                case NUMBER: {
                    return "Number";
                }
                case GEO: {
                    return "Geolocation";
                }
                case PHOTO: {
                    return "Photo";
                }
                case VIDEO: {
                    return "Video";
                }
                case SCAN: {
                    return "Barcode";
                }
                case TRACK: {
                    return "(Track)";
                }
                case STRENGTH: {
                    return "(Strength)";
                }
                case DATE: {
                    return "Date";
                }
                case CASCADE: {
                    return "Cascade";
                }
                case GEOSHAPE: {
                    return "Geographic Shape";
                }
                case SIGNATURE: {
                    return "Signature";
                }
                case CADDISFLY: {
                    return "Caddisfly";
                }
            }
            return "(" + (Object)((Object)q.getType()) + ")";
        }
        return null;
    }

    private String formText(String text, Map<String, TranslationDto> translationMap) {
        StringBuilder buff = new StringBuilder();
        buff.append(text);
        if (translationMap != null) {
            TreeMap<String, TranslationDto> sortedMap = null;
            sortedMap = translationMap instanceof TreeMap ? (TreeMap<String, TranslationDto>)translationMap : new TreeMap<String, TranslationDto>(translationMap);
            for (Map.Entry<String, TranslationDto> trans : sortedMap.entrySet()) {
                if (trans.getValue() == null || trans.getValue().getText() == null || trans.getValue().getText().trim().equalsIgnoreCase("null")) continue;
                buff.append(LANG_DELIM);
                buff.append(trans.getValue().getText());
            }
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        ConsoleAppender console = new ConsoleAppender();
        console.setLayout((Layout)new PatternLayout("%d{ISO8601} [%t] %-5p %c - %m%n"));
        console.setThreshold((Priority)Level.DEBUG);
        console.activateOptions();
        Logger.getRootLogger().addAppender((Appender)console);
        SurveyFormExporter exporter = new SurveyFormExporter();
        HashMap<String, String> criteria = new HashMap<String, String>();
        HashMap<String, String> options = new HashMap<String, String>();
        criteria.put(SURVEY_ID_KEY, args[2]);
        criteria.put("apiKey", args[3]);
        exporter.export(criteria, new File(args[0]), args[1], options);
    }
}

