/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.framework.domain.DataChangeRecord;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.SurveyAssignmentDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Survey;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.SurveyAssignmentDto;
import org.waterforpeople.mapping.app.web.rest.dto.SurveyAssignmentPayload;
import org.waterforpeople.mapping.domain.SurveyAssignment;

@Controller
@RequestMapping(value={"/survey_assignments"})
public class SurveyAssignmentRestService {
    private SurveyAssignmentDAO surveyAssignmentDao = new SurveyAssignmentDAO();
    private DeviceDAO deviceDao;
    private SurveyDAO surveyDao;
    private DeviceSurveyJobQueueDAO deviceSurveyJobQueueDAO;

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<SurveyAssignmentDto>> listAll() {
        HashMap<String, List<SurveyAssignmentDto>> response = new HashMap<String, List<SurveyAssignmentDto>>();
        ArrayList<SurveyAssignmentDto> results = new ArrayList<SurveyAssignmentDto>();
        for (SurveyAssignment sa : this.surveyAssignmentDao.list("all")) {
            results.add(this.marshallToDto(sa));
        }
        response.put("survey_assignments", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyAssignmentDto> getById(@PathVariable(value="id") Long id) {
        HashMap<String, SurveyAssignmentDto> response = new HashMap<String, SurveyAssignmentDto>();
        SurveyAssignment sa = (SurveyAssignment)this.surveyAssignmentDao.getByKey(id);
        if (sa == null) {
            throw new HttpMessageNotReadableException("Survey Assignment with id: " + id + " not found");
        }
        response.put("survey_assignment", this.marshallToDto(sa));
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        SurveyAssignment sa = (SurveyAssignment)this.surveyAssignmentDao.getByKey(id);
        DeviceSurveyJobQueueDAO deviceSurveysDao = new DeviceSurveyJobQueueDAO();
        List<DeviceSurveyJobQueue> deviceSurveys = deviceSurveysDao.listJobByAssignment(id);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (sa != null && deviceSurveys != null) {
            this.surveyAssignmentDao.delete(sa);
            deviceSurveysDao.delete(deviceSurveys);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyAssignmentDto> updateSurveyAssignment(@PathVariable(value="id") Long id, @RequestBody SurveyAssignmentPayload payload) {
        SurveyAssignmentDto dto = payload.getSurvey_assignment();
        if (!id.equals(dto.getKeyId())) {
            throw new HttpMessageNotReadableException("Ids don't match: " + id + " <> " + dto.getKeyId());
        }
        SurveyAssignment oldAssignment = (SurveyAssignment)this.surveyAssignmentDao.getByKey(dto.getKeyId());
        HashMap<String, SurveyAssignmentDto> response = new HashMap<String, SurveyAssignmentDto>();
        if (oldAssignment == null) {
            throw new HttpMessageNotReadableException("Survey Assignment with id: " + dto.getKeyId() + " not found");
        }
        SurveyAssignment sa = this.marshallToDomain(dto);
        this.surveyAssignmentDao.save(sa);
        this.generateDeviceJobQueueItems(sa, oldAssignment);
        response.put("survey_assignment", this.marshallToDto(sa));
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, SurveyAssignmentDto> newSurveyAssignment(@RequestBody SurveyAssignmentPayload payload) {
        SurveyAssignmentDto dto = payload.getSurvey_assignment();
        SurveyAssignment sa = this.marshallToDomain(dto);
        this.surveyAssignmentDao.save(sa);
        this.generateDeviceJobQueueItems(sa, null);
        HashMap<String, SurveyAssignmentDto> response = new HashMap<String, SurveyAssignmentDto>();
        response.put("survey_assignment", this.marshallToDto(sa));
        return response;
    }

    private SurveyAssignmentDto marshallToDto(SurveyAssignment sa) {
        SurveyAssignmentDto dto = new SurveyAssignmentDto();
        BeanUtils.copyProperties((Object)sa, (Object)dto);
        if (sa.getKey() != null) {
            dto.setKeyId(sa.getKey().getId());
        }
        dto.setDevices(sa.getDeviceIds());
        dto.setSurveys(sa.getSurveyIds());
        return dto;
    }

    private SurveyAssignment marshallToDomain(SurveyAssignmentDto dto) {
        SurveyAssignment sa = new SurveyAssignment();
        BeanUtils.copyProperties((Object)dto, (Object)sa);
        if (dto.getKeyId() != null) {
            sa.setKey(KeyFactory.createKey((String)"SurveyAssignment", (long)dto.getKeyId()));
        }
        sa.setDeviceIds(dto.getDevices());
        sa.setSurveyIds(dto.getSurveys());
        return sa;
    }

    private void generateDeviceJobQueueItems(SurveyAssignment assignment, SurveyAssignment oldAssignment) {
        Device d;
        ArrayList<Long> surveyIdsToSave = new ArrayList<Long>(assignment.getSurveyIds());
        ArrayList<Long> deviceIdsToSave = new ArrayList<Long>(assignment.getDeviceIds());
        ArrayList<Object> surveyIdsToDelete = new ArrayList();
        ArrayList<Object> deviceIdsToDelete = new ArrayList();
        this.surveyAssignmentDao = new SurveyAssignmentDAO();
        this.deviceDao = new DeviceDAO();
        this.surveyDao = new SurveyDAO();
        this.deviceSurveyJobQueueDAO = new DeviceSurveyJobQueueDAO();
        if (oldAssignment != null) {
            if (oldAssignment.getSurveyIds() != null) {
                surveyIdsToSave.removeAll(oldAssignment.getSurveyIds());
                surveyIdsToDelete = new ArrayList<Long>(oldAssignment.getSurveyIds());
                surveyIdsToDelete.removeAll(assignment.getSurveyIds());
            }
            if (oldAssignment.getDeviceIds() != null) {
                deviceIdsToSave.removeAll(oldAssignment.getDeviceIds());
                deviceIdsToDelete = new ArrayList<Long>(oldAssignment.getDeviceIds());
                deviceIdsToDelete.removeAll(assignment.getDeviceIds());
            }
        }
        ArrayList<DeviceSurveyJobQueue> queueList = new ArrayList<DeviceSurveyJobQueue>();
        HashMap<Long, Survey> surveyMap = new HashMap<Long, Survey>();
        HashMap<Long, Device> deviceMap = new HashMap<Long, Device>();
        if (deviceIdsToSave != null) {
            for (Long id : deviceIdsToSave) {
                d = (Device)deviceMap.get(id);
                if (d == null) {
                    d = (Device)this.deviceDao.getByKey(id);
                    deviceMap.put(d.getKey().getId(), d);
                }
                for (Long sId : assignment.getSurveyIds()) {
                    Survey survey = (Survey)surveyMap.get(sId);
                    if (survey == null) {
                        survey = (Survey)this.surveyDao.getByKey(sId);
                        surveyMap.put(sId, survey);
                    }
                    queueList.add(this.constructQueueObject(d, survey, assignment));
                }
            }
        }
        if (surveyIdsToSave != null) {
            for (Long sId : surveyIdsToSave) {
                Survey survey = (Survey)surveyMap.get(sId);
                if (survey == null) {
                    survey = (Survey)this.surveyDao.getByKey(sId);
                    surveyMap.put(sId, survey);
                }
                for (Long id : assignment.getDeviceIds()) {
                    if (deviceIdsToSave.contains(id)) continue;
                    Device d2 = (Device)deviceMap.get(id);
                    if (d2 == null) {
                        d2 = (Device)this.deviceDao.getByKey(id);
                        deviceMap.put(d2.getKey().getId(), d2);
                    }
                    queueList.add(this.constructQueueObject(d2, survey, assignment));
                }
            }
        }
        if (queueList.size() > 0) {
            this.deviceSurveyJobQueueDAO.save(queueList);
        }
        if (deviceIdsToDelete.size() > 0 || surveyIdsToDelete.size() > 0) {
            int i;
            StringBuilder builder = new StringBuilder("d");
            for (i = 0; i < deviceIdsToDelete.size(); ++i) {
                if (i > 0) {
                    builder.append("xx");
                }
                if ((d = (Device)deviceMap.get(deviceIdsToDelete.get(i))) == null) {
                    d = (Device)this.deviceDao.getByKey((Long)deviceIdsToDelete.get(i));
                    deviceMap.put(d.getKey().getId(), d);
                }
                builder.append(d.getPhoneNumber());
            }
            builder.append("s");
            for (i = 0; i < surveyIdsToDelete.size(); ++i) {
                if (i > 0) {
                    builder.append("xx");
                }
                builder.append(((Long)surveyIdsToDelete.get(i)).toString());
            }
            DataChangeRecord change = new DataChangeRecord(SurveyAssignment.class.getName(), assignment.getKey().getId() + "", builder.toString(), "n/");
            Queue queue = QueueFactory.getQueue((String)"dataUpdate");
            queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/dataupdate").param("objectKey", assignment.getKey().getId() + "").param("type", "DeviceSurveyJobQueueChange").param("value", change.packString()));
        }
    }

    private DeviceSurveyJobQueue constructQueueObject(Device d, Survey survey, SurveyAssignment assignment) {
        DeviceSurveyJobQueue queueItem = new DeviceSurveyJobQueue();
        queueItem.setDevicePhoneNumber(d.getPhoneNumber());
        queueItem.setEffectiveStartDate(assignment.getStartDate());
        queueItem.setEffectiveEndDate(assignment.getEndDate());
        queueItem.setSurveyID(survey.getKey().getId());
        queueItem.setName(survey.getName());
        queueItem.setLanguage(assignment.getLanguage());
        queueItem.setAssignmentId(assignment.getKey().getId());
        queueItem.setSurveyDistributionStatus(DeviceSurveyJobQueue.DistributionStatus.UNSENT);
        queueItem.setImei(d.getEsn());
        queueItem.setAndroidId(d.getAndroidId());
        return queueItem;
    }
}

