/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.surveyal.dao.SurveyalValueDao;
import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.domain.mapper.QuestionGroupDtoMapper;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.web.rest.dto.QuestionGroupListPayload;
import org.waterforpeople.mapping.app.web.rest.dto.QuestionGroupPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;

@Controller
@RequestMapping(value={"/question_groups"})
public class QuestionGroupRestService {
    private QuestionGroupDao questionGroupDao = new QuestionGroupDao();
    private QuestionDao questionDao = new QuestionDao();
    private SurveyalValueDao svDao = new SurveyalValueDao();
    private QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
    private static final String[] QUESTION_GROUP_COPY_EXCLUDED_PROPS = (String[])ArrayUtils.add((Object[])Constants.EXCLUDED_PROPERTIES, (Object)"status");

    @RequestMapping(method={RequestMethod.GET}, value={"/all"})
    @ResponseBody
    public Map<String, List<QuestionGroupDto>> listQuestionGroups() {
        HashMap<String, List<QuestionGroupDto>> response = new HashMap<String, List<QuestionGroupDto>>();
        ArrayList<QuestionGroupDto> results = new ArrayList<QuestionGroupDto>();
        List questionGroups = this.questionGroupDao.list("all");
        if (questionGroups != null) {
            for (QuestionGroup qg : questionGroups) {
                results.add(QuestionGroupDtoMapper.transform(qg));
            }
        }
        response.put("question_groups", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listQuestionGroupBySurvey(@RequestParam(value="surveyId", defaultValue="") Long surveyId, @RequestParam(value="preflight", defaultValue="") String preflight, @RequestParam(value="questionGroupId", defaultValue="") Long questionGroupId) {
        QuestionGroup qg;
        List<QuestionGroup> questionGroups;
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        if (preflight.equals("delete") && questionGroupId != null) {
            statusDto.setStatus("preflight-delete-questiongroup");
            statusDto.setMessage("can_delete");
            statusDto.setKeyId(questionGroupId);
            for (Question q : this.questionDao.listQuestionsByQuestionGroup(questionGroupId, Boolean.FALSE).values()) {
                if (this.qasDao.listByQuestion(q.getKey().getId()).size() <= 0 || this.svDao.listByQuestion(q.getKey().getId()).size() <= 0) continue;
                statusDto.setMessage("cannot_delete");
                statusDto.setKeyId(null);
            }
        }
        ArrayList<QuestionGroupDto> results = new ArrayList<QuestionGroupDto>();
        if (surveyId != null && (questionGroups = this.questionGroupDao.listQuestionGroupBySurvey(surveyId)) != null) {
            for (QuestionGroup qg2 : questionGroups) {
                results.add(QuestionGroupDtoMapper.transform(qg2));
            }
        }
        if (questionGroupId != null && preflight.isEmpty() && (qg = (QuestionGroup)this.questionGroupDao.getByKey(questionGroupId)) != null) {
            results.add(QuestionGroupDtoMapper.transform(qg));
        }
        response.put("question_groups", results);
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, QuestionGroupDto> findQuestionGroup(@PathVariable(value="id") Long id) {
        HashMap<String, QuestionGroupDto> response = new HashMap<String, QuestionGroupDto>();
        QuestionGroup qg = (QuestionGroup)this.questionGroupDao.getByKey(id);
        QuestionGroupDto dto = null;
        if (qg != null) {
            dto = QuestionGroupDtoMapper.transform(qg);
        }
        response.put("question_group", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteQuestionGroupById(@PathVariable(value="id") Long questionGroupId) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        QuestionGroup group = (QuestionGroup)this.questionGroupDao.getByKey(questionGroupId);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (group != null) {
            try {
                TaskOptions deleteQuestionGroupTask = TaskOptions.Builder.withUrl((String)"/app_worker/surveytask").param("action", "deleteQuestionGroup").param("id", Long.toString(group.getKey().getId()));
                QueueFactory.getQueue((String)"deletequeue").add(deleteQuestionGroupTask);
                statusDto.setStatus("ok");
                statusDto.setMessage("deleted");
            }
            catch (Exception e) {
                statusDto.setStatus("failed");
                statusDto.setMessage(e.getMessage());
            }
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingQuestionGroup(@RequestBody QuestionGroupPayload payLoad) {
        QuestionGroup qg;
        Long keyId;
        QuestionGroupDto questionGroupDto = payLoad.getQuestion_group();
        HashMap<String, Object> response = new HashMap<String, Object>();
        QuestionGroupDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("Cannot find question group");
        if (questionGroupDto != null && (keyId = questionGroupDto.getKeyId()) != null && (qg = (QuestionGroup)this.questionGroupDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)questionGroupDto, (Object)qg, (String[])new String[]{"createdDateTime", "status"});
            qg = this.questionGroupDao.save(qg);
            dto = QuestionGroupDtoMapper.transform(qg);
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        response.put("question_group", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/bulk"})
    @ResponseBody
    public Map<String, Object> saveExistingQuestionGroups(@RequestBody QuestionGroupListPayload payLoad) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("No question groups to change");
        ArrayList<QuestionGroup> saveList = new ArrayList<QuestionGroup>();
        List<QuestionGroupDto> requestList = payLoad.getQuestion_groups();
        if (requestList != null && requestList.size() > 0) {
            for (QuestionGroupDto questionGroupDto : requestList) {
                if (questionGroupDto == null) continue;
                Long keyId = questionGroupDto.getKeyId();
                if (keyId != null) {
                    QuestionGroup qg = (QuestionGroup)this.questionGroupDao.getByKey(keyId);
                    if (qg != null) {
                        BeanUtils.copyProperties((Object)questionGroupDto, (Object)qg, (String[])new String[]{"createdDateTime", "status"});
                        saveList.add(qg);
                        continue;
                    }
                    statusDto.setMessage("Cannot change unknown question group " + keyId);
                    response.put("meta", statusDto);
                    return response;
                }
                statusDto.setMessage("Cannot change question group without id");
                response.put("meta", statusDto);
                return response;
            }
            this.questionGroupDao.save(saveList);
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewQuestionGroup(@RequestBody QuestionGroupPayload payLoad) {
        QuestionGroupDto questionGroupDto = payLoad.getQuestion_group();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("Cannot create question group");
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("meta", statusDto);
        response.put("question_group", null);
        if (questionGroupDto == null) {
            return response;
        }
        QuestionGroup qg = null;
        if (questionGroupDto.getSourceId() != null) {
            qg = this.copyGroup(questionGroupDto);
        } else {
            qg = new QuestionGroup();
            BeanUtils.copyProperties((Object)questionGroupDto, (Object)qg, (String[])new String[]{"createdDateTime", "status"});
            qg.setStatus(QuestionGroup.Status.valueOf(questionGroupDto.getStatus()));
            qg = this.questionGroupDao.save(qg);
        }
        if (qg == null) {
            return response;
        }
        QuestionGroupDto dto = QuestionGroupDtoMapper.transform(qg);
        statusDto.setStatus("ok");
        statusDto.setMessage("");
        response.put("meta", statusDto);
        response.put("question_group", dto);
        return response;
    }

    private QuestionGroup copyGroup(QuestionGroupDto questionGroupDto) {
        QuestionGroup tmpGroup = new QuestionGroup();
        BeanUtils.copyProperties((Object)questionGroupDto, (Object)tmpGroup, (String[])QUESTION_GROUP_COPY_EXCLUDED_PROPS);
        tmpGroup.setStatus(QuestionGroup.Status.COPYING);
        QuestionGroup copyGroup = this.questionGroupDao.save(tmpGroup);
        Queue queue = QueueFactory.getDefaultQueue();
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "copyQuestionGroup").param("questionGroupId", String.valueOf(copyGroup.getKey().getId())).param("source", questionGroupDto.getSourceId().toString()).header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
        queue.add(options);
        return copyGroup;
    }
}

