/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyTaskUtil;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.util.List;
import java.util.logging.Logger;

public class SurveyGroupDAO
extends BaseDAO<SurveyGroup> {
    private static final Logger log = Logger.getLogger(SurveyGroupDAO.class.getName());
    private SurveyDAO surveyDao = new SurveyDAO();

    public SurveyGroupDAO() {
        super(SurveyGroup.class);
    }

    @Override
    public SurveyGroup save(SurveyGroup group) {
        if ((group = super.save(group)).getSurveyList() != null) {
            for (Survey s : group.getSurveyList()) {
                s.setSurveyGroupId(group.getKey().getId());
                this.surveyDao.save(s);
            }
        }
        return group;
    }

    public SurveyGroup findBySurveyGroupName(String name) {
        return (SurveyGroup)super.findByProperty("code", name, "String");
    }

    @Override
    public void delete(SurveyGroup item) {
        SurveyDAO surveyDao = new SurveyDAO();
        item = (SurveyGroup)super.getByKey(item.getKey().getId());
        for (Survey survey : surveyDao.listSurveysByGroup(item.getKey().getId())) {
            SurveyTaskUtil.spawnDeleteTask("deleteSurvey", survey.getKey().getId());
        }
        super.delete(item);
    }

    public List<SurveyGroup> listByProjectFolderId(Long parentId) {
        return super.listByProperty("parentId", parentId, "Long");
    }

    public List<SurveyGroup> listAllFilteredByUserAuthorization() {
        List allSurveyGroups = this.list("all");
        return this.filterByUserAuthorizationObjectId(allSurveyGroups);
    }
}

