/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.messaging.dao.MessageDao;
import com.gallatinsystems.messaging.domain.Message;
import com.gallatinsystems.operations.dao.ProcessingStatusDao;
import com.gallatinsystems.operations.domain.ProcessingStatus;
import com.gallatinsystems.survey.dao.CascadeNodeDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.CascadeNode;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.Translation;
import com.gallatinsystems.surveyal.dao.SurveyalValueDao;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyalValue;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.servlet.http.HttpServletRequest;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheManager;
import org.akvo.flow.domain.DataUtils;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.analytics.domain.SurveyQuestionSummary;
import org.waterforpeople.mapping.app.web.dto.DataProcessorRequest;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.dataexport.SurveyReplicationImporter;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class DataProcessorRestServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger("DataProcessorRestServlet");
    private static final long serialVersionUID = -7902002525342262821L;
    private static final String REBUILD_Q_SUM_STATUS_KEY = "rebuildQuestionSummary";
    private static final Integer QAS_PAGE_SIZE = 300;
    private static final Integer LOCALE_PAGE_SIZE = 500;
    private static final Integer T_PAGE_SIZE = 300;
    private static final Integer SVAL_PAGE_SIZE = 600;
    private static final String QAS_TO_REMOVE = "QAStoRemove";
    private static final long NAME_ASSEMBLY_TASK_DELAY = 3000L;
    private SurveyInstanceDAO siDao;

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataProcessorRequest restRequest = new DataProcessorRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DataProcessorRequest dpReq = (DataProcessorRequest)req;
        if (REBUILD_Q_SUM_STATUS_KEY.equalsIgnoreCase(dpReq.getAction())) {
            this.rebuildQuestionSummary(dpReq.getSurveyId());
        } else if ("copySurvey".equalsIgnoreCase(dpReq.getAction())) {
            this.copySurvey(dpReq.getSurveyId(), Long.valueOf(dpReq.getSource()));
        } else if ("copyQuestionGroup".equalsIgnoreCase(dpReq.getAction())) {
            QuestionGroupDao qgDao = new QuestionGroupDao();
            QuestionGroup newQuestionGroup = (QuestionGroup)qgDao.getByKey(dpReq.getQuestionGroupId());
            QuestionGroup originalQuestionGroup = (QuestionGroup)qgDao.getByKey(Long.valueOf(dpReq.getSource()));
            if (originalQuestionGroup != null && newQuestionGroup != null) {
                Long surveyId = originalQuestionGroup.getSurveyId();
                SurveyUtils.copyQuestionGroup(originalQuestionGroup, newQuestionGroup, surveyId, null, SurveyUtils.listQuestionIdsUsedInSurveyGroup(surveyId));
                newQuestionGroup.setStatus(QuestionGroup.Status.READY);
                qgDao.save(newQuestionGroup);
            }
        } else if ("fixQuestionGroupDepencencies".equalsIgnoreCase(dpReq.getAction())) {
            QuestionGroup newQuestionGroup = (QuestionGroup)new QuestionGroupDao().getByKey(dpReq.getQuestionGroupId());
            QuestionGroup originalQuestionGroup = (QuestionGroup)new QuestionGroupDao().getByKey(Long.valueOf(dpReq.getSource()));
            if (originalQuestionGroup != null && newQuestionGroup != null) {
                List<Long> unresolvedDependentIds = dpReq.getDependentQuestionIds();
                List<Question> processedQuestionList = this.fixQuestionGroupDependencies(newQuestionGroup, originalQuestionGroup, unresolvedDependentIds);
                ArrayList<Question> unresolvedDependencies = new ArrayList<Question>();
                for (Question question : processedQuestionList) {
                    if (question.getDependentQuestionId() != null) continue;
                    unresolvedDependencies.add(question);
                }
                if (!unresolvedDependencies.isEmpty()) {
                    void var9_17;
                    TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", dpReq.getAction()).param("questionGroupId", dpReq.getQuestionGroupId().toString()).param("source", dpReq.getSource());
                    for (Question q : unresolvedDependencies) {
                        options.param("depedentQuestionId", Long.toString(q.getKey().getId()));
                    }
                    int n = dpReq.getRetry();
                    if (unresolvedDependencies.size() == unresolvedDependentIds.size()) {
                        options.param("retry", Integer.toString((int)(++var9_17)));
                    }
                    if (var9_17 < 3) {
                        Queue queue = QueueFactory.getQueue((String)"dataUpdate");
                        queue.add(options);
                    } else {
                        log.severe("Failed to resolve dependencies for copied QuestionGroup " + newQuestionGroup.getKey().getId() + " after multiple retries");
                    }
                }
            }
        } else if ("importRemoteSurvey".equalsIgnoreCase(dpReq.getAction())) {
            SurveyReplicationImporter sri = new SurveyReplicationImporter();
            sri.executeImport(dpReq.getSource(), dpReq.getSurveyId(), dpReq.getApiKey());
        } else if ("fixDuplicateOtherText".equalsIgnoreCase(dpReq.getAction())) {
            this.fixDuplicateOtherText();
        } else if ("trimOptions".equalsIgnoreCase(dpReq.getAction())) {
            this.trimOptions();
        } else if ("fixOptions2Values".equalsIgnoreCase(dpReq.getAction())) {
            DataProcessorRestServlet.fixOptions2Values();
        } else if ("deleteDuplicatedQAS".equalsIgnoreCase(dpReq.getAction())) {
            this.deleteDuplicatedQAS(dpReq.getOffset());
        } else if ("changeLocaleType".equalsIgnoreCase(dpReq.getAction())) {
            this.changeLocaleType(dpReq.getSurveyId());
        } else if ("addTranslationFields".equalsIgnoreCase(dpReq.getAction())) {
            this.addTranslationFields(dpReq.getCursor());
        } else if ("addCreationSurveyIdToLocale".equalsIgnoreCase(dpReq.getAction())) {
            DataProcessorRestServlet.addCreationSurveyIdToLocale(dpReq.getCursor());
        } else if ("populateMonitoringFieldsLocale".equalsIgnoreCase(req.getAction())) {
            DataProcessorRestServlet.populateMonitoringFieldsLocale(dpReq.getCursor(), dpReq.getSurveyId(), dpReq.getSurveyedLocaleId());
        } else if ("createNewIdentifiersLocales".equalsIgnoreCase(req.getAction())) {
            this.createNewIdentifiersLocales(dpReq.getCursor(), dpReq.getSurveyId());
        } else if ("populateQuestionOrders".equalsIgnoreCase(req.getAction())) {
            this.populateQuestionOrdersSurveyalValues(dpReq.getSurveyId(), req.getCursor());
        } else if ("deleteSurveyInstance".equalsIgnoreCase(req.getAction())) {
            if (dpReq.getSurveyInstanceId() != null) {
                this.deleteSurveyResponses(dpReq.getSurveyInstanceId());
            }
        } else if ("surveyResponseCount".equalsIgnoreCase(req.getAction())) {
            if (dpReq.getSummaryCounterId() != null && dpReq.getDelta() != null) {
                this.updateSurveyResponseCounter(dpReq.getSummaryCounterId(), dpReq.getDelta());
            }
        } else if ("deleteCascadeNodes".equalsIgnoreCase(req.getAction())) {
            this.deleteCascadeNodes(dpReq.getCascadeResourceId(), dpReq.getParentNodeId());
        } else if ("assembleDatapointName".equalsIgnoreCase(req.getAction())) {
            this.assembleDatapointName(dpReq.getSurveyGroupId(), dpReq.getSurveyedLocaleId());
        }
        return new RestResponse();
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
    }

    private void trimOptions() {
        QuestionOptionDao optDao = new QuestionOptionDao();
        QuestionDao qDao = new QuestionDao();
        String cursor = null;
        do {
            List optList;
            if ((optList = optDao.list(cursor)) != null && optList.size() > 0) {
                for (QuestionOption opt : optList) {
                    if (opt.getText() != null) {
                        opt.setText(opt.getText().trim());
                    }
                    List<Question> qList = qDao.listQuestionsByDependency(opt.getQuestionId());
                    for (Question q : qList) {
                        if (q.getText() != null) {
                            q.setText(q.getText().trim());
                        }
                        if (q.getDependentQuestionAnswer() == null) continue;
                        q.setDependentQuestionAnswer(q.getDependentQuestionAnswer().trim());
                    }
                }
                if (optList.size() == 20) {
                    cursor = QuestionOptionDao.getCursor(optList);
                    continue;
                }
                cursor = null;
                continue;
            }
            cursor = null;
        } while (cursor != null);
    }

    private void fixDuplicateOtherText() {
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        int pageSize = 300;
        String cursor = null;
        do {
            List<QuestionAnswerStore> answers;
            if ((answers = qasDao.listByTypeAndDate("OTHER", null, null, cursor, pageSize)) == null) continue;
            for (QuestionAnswerStore ans : answers) {
                if (ans.getValue() == null || !ans.getValue().contains("|")) continue;
                String[] tokens = ans.getValue().split("\\|");
                String lastVal = null;
                boolean droppedVal = false;
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokens[i].equals(lastVal)) {
                        lastVal = tokens[i];
                        if (i > 0) {
                            buf.append("|");
                        }
                        buf.append(lastVal);
                        continue;
                    }
                    droppedVal = true;
                }
                if (!droppedVal) continue;
                ans.setValue(buf.toString());
            }
            cursor = answers.size() == pageSize ? QuestionAnswerStoreDao.getCursor(answers) : null;
        } while (cursor != null);
    }

    private void changeLocaleType(Long surveyId) {
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        SurveyDAO sDao = new SurveyDAO();
        String cursor = null;
        Survey s = (Survey)sDao.getByKey(surveyId);
        if (s != null && s.getPointType() != null && s.getPointType().length() > 0) {
            String localeType = s.getPointType();
            do {
                List<SurveyInstance> siList;
                if ((siList = siDao.listSurveyInstanceBySurvey(surveyId, QAS_PAGE_SIZE, cursor)) == null || siList.size() <= 0) continue;
                for (SurveyInstance si : siList) {
                    SurveyedLocale sl;
                    if (si.getSurveyedLocaleId() == null || (sl = (SurveyedLocale)slDao.getByKey(si.getSurveyedLocaleId())) == null || sl.getLocaleType() != null && sl.getLocaleType().equals(localeType)) continue;
                    sl.setLocaleType(localeType);
                    slDao.save(sl);
                }
                cursor = siList.size() == QAS_PAGE_SIZE.intValue() ? SurveyInstanceDAO.getCursor(siList) : null;
            } while (cursor != null);
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "recomputeLocaleClusters");
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(options);
        }
    }

    private void deleteDuplicatedQAS(Long offset) {
        log.log(Level.INFO, "Searching for duplicated QAS entities [Offset: " + offset + "]");
        Cache cache = null;
        HashMap<Integer, Constable> props = new HashMap<Integer, Constable>();
        props.put(0, Integer.valueOf(43200));
        props.put((Integer)MemcacheService.SetPolicy.SET_ALWAYS, Boolean.valueOf(true));
        try {
            CacheFactory cacheFactory = CacheManager.getInstance().getCacheFactory();
            cache = cacheFactory.createCache(props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't initialize cache: " + e.getMessage(), e);
        }
        if (cache == null) {
            return;
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        Query q = pm.newQuery(QuestionAnswerStore.class);
        q.setOrdering("createdDateTime asc");
        q.setRange(offset.longValue(), offset + (long)QAS_PAGE_SIZE.intValue());
        List results = (List)q.execute();
        List toRemove = cache.containsKey((Object)QAS_TO_REMOVE) ? (List)cache.get((Object)QAS_TO_REMOVE) : new ArrayList();
        for (QuestionAnswerStore item : results) {
            Long questionID = Long.valueOf(item.getQuestionID());
            Long surveyInstanceId = item.getSurveyInstanceId();
            HashMap<Long, Long> k = new HashMap<Long, Long>();
            k.put(surveyInstanceId, questionID);
            if (cache.containsKey(k)) {
                toRemove.add(item);
            }
            cache.put(k, (Object)true);
        }
        if (results.size() == QAS_PAGE_SIZE.intValue()) {
            cache.put((Object)QAS_TO_REMOVE, toRemove);
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "deleteDuplicatedQAS").param("offset", String.valueOf(offset + (long)QAS_PAGE_SIZE.intValue())).header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(options);
        } else {
            log.log(Level.INFO, "Removing " + toRemove.size() + " duplicated QAS entities");
            QuestionAnswerStoreDao dao = new QuestionAnswerStoreDao();
            pm.makePersistentAll(toRemove);
            dao.delete(toRemove);
        }
    }

    private void copySurvey(Long copiedSurveyId, Long originalSurveyId) {
        QuestionGroupDao qgDao = new QuestionGroupDao();
        List<QuestionGroup> qgList = qgDao.listQuestionGroupBySurvey(originalSurveyId);
        HashMap<Long, Long> qDependencyResolutionMap = new HashMap<Long, Long>();
        if (qgList == null) {
            log.log(Level.INFO, "Nothing to copy from {surveyId: " + originalSurveyId + "} to {surveyId: " + copiedSurveyId + "}");
            SurveyUtils.resetSurveyState(copiedSurveyId);
            return;
        }
        log.log(Level.INFO, "Copying " + qgList.size() + " `QuestionGroup`");
        for (QuestionGroup sourceGroup : qgList) {
            QuestionGroup tmpGroup = new QuestionGroup();
            SurveyUtils.shallowCopy(sourceGroup, tmpGroup);
            tmpGroup.setSurveyId(copiedSurveyId);
            QuestionGroup copyGroup = qgDao.save(tmpGroup);
            SurveyUtils.copyQuestionGroup(sourceGroup, copyGroup, copiedSurveyId, qDependencyResolutionMap, null);
        }
        SurveyDAO sDao = new SurveyDAO();
        Survey copiedSurvey = SurveyUtils.resetSurveyState(copiedSurveyId);
        Survey originalSurvey = sDao.getById(originalSurveyId);
        MessageDao mDao = new MessageDao();
        Message message = new Message();
        message.setObjectId(copiedSurveyId);
        message.setObjectTitle(copiedSurvey.getName());
        message.setActionAbout("copySurvey");
        message.setShortMessage("Copying from Survey " + originalSurveyId + " (" + originalSurvey.getName() + ") completed");
        mDao.save(message);
    }

    private List<Question> fixQuestionGroupDependencies(QuestionGroup newQuestionGroup, QuestionGroup oldQuestionGroup, List<Long> dependentQuestionIdsList) {
        log.info("Resolving dependencies for " + dependentQuestionIdsList.size() + " questions");
        QuestionDao qDao = new QuestionDao();
        List<Question> unresolvedDependentQuestions = qDao.listByKeys(dependentQuestionIdsList);
        ArrayList<Object> originalDependentQuestions = new ArrayList<Object>();
        for (Question q : unresolvedDependentQuestions) {
            Object source;
            if (q.getSourceQuestionId() == null || (source = qDao.getByKey(q.getSourceQuestionId())) == null) continue;
            originalDependentQuestions.add(source);
        }
        HashMap<Long, Question> originalQuestionsIdMap = new HashMap<Long, Question>();
        ArrayList<Long> originalDependentQuestionIds = new ArrayList<Long>();
        for (Question question : originalDependentQuestions) {
            originalQuestionsIdMap.put(question.getKey().getId(), question);
            if (question.getDependentQuestionId() == null) continue;
            originalDependentQuestionIds.add(question.getDependentQuestionId());
        }
        List<Question> newQuestions = qDao.listBySourceQuestionId(originalDependentQuestionIds);
        HashMap<Long, Question> hashMap = new HashMap<Long, Question>();
        for (Question q : newQuestions) {
            if (q.getSourceQuestionId() == null) continue;
            hashMap.put(q.getSourceQuestionId(), q);
        }
        for (Question unresolved : unresolvedDependentQuestions) {
            Question source = (Question)originalQuestionsIdMap.get(unresolved.getSourceQuestionId());
            if (source == null || !hashMap.containsKey(source.getDependentQuestionId())) continue;
            Question newQuestion = (Question)hashMap.get(source.getDependentQuestionId());
            unresolved.setDependentQuestionId(newQuestion.getKey().getId());
        }
        qDao.save(unresolvedDependentQuestions);
        return unresolvedDependentQuestions;
    }

    private void rebuildQuestionSummary(Long surveyId) {
        ProcessingStatusDao statusDao = new ProcessingStatusDao();
        ArrayList<Long> surveyIds = new ArrayList<Long>();
        if (surveyId == null) {
            SurveyDAO surveyDao = new SurveyDAO();
            List surveys = surveyDao.list("all");
            if (surveys != null) {
                for (Survey s : surveys) {
                    surveyIds.add(s.getKey().getId());
                }
            }
        } else {
            surveyIds.add(surveyId);
        }
        for (Long sid : surveyIds) {
            ProcessingStatus status = statusDao.getStatusByCode(REBUILD_Q_SUM_STATUS_KEY + (sid != null ? ":" + sid : ""));
            Map<String, Map<String, Long>> summaryMap = this.summarizeQuestionAnswerStore(sid, null);
            if (summaryMap != null) {
                this.saveSummaries(summaryMap);
            }
            if (status == null) {
                status = new ProcessingStatus();
                status.setCode(REBUILD_Q_SUM_STATUS_KEY + (sid != null ? ":" + sid : ""));
            }
            status.setInError(false);
            status.setLastEventDate(new Date());
            statusDao.save(status);
        }
    }

    private void saveSummaries(Map<String, Map<String, Long>> summaryMap) {
        SurveyQuestionSummaryDao summaryDao = new SurveyQuestionSummaryDao();
        for (Map.Entry<String, Map<String, Long>> summaryEntry : summaryMap.entrySet()) {
            List<SurveyQuestionSummary> summaryList = summaryDao.listByQuestion(summaryEntry.getKey());
            ArrayList<SurveyQuestionSummary> toDeleteList = new ArrayList<SurveyQuestionSummary>(summaryList);
            ArrayList<SurveyQuestionSummary> toCreateList = new ArrayList<SurveyQuestionSummary>();
            for (Map.Entry<String, Long> valueEntry : summaryEntry.getValue().entrySet()) {
                String val = valueEntry.getKey();
                boolean found = false;
                for (SurveyQuestionSummary sum : summaryList) {
                    if (sum.getResponse() == null || !sum.getResponse().equals(val)) continue;
                    toDeleteList.remove(sum);
                    sum.setCount(valueEntry.getValue());
                    found = true;
                }
                if (found) continue;
                SurveyQuestionSummary s = new SurveyQuestionSummary();
                s.setCount(valueEntry.getValue());
                s.setQuestionId(summaryEntry.getKey());
                s.setResponse(val);
                toCreateList.add(s);
            }
            if (toDeleteList.size() > 0) {
                summaryDao.delete((List<SurveyQuestionSummary>)toDeleteList);
            }
            if (toCreateList.size() > 0) {
                summaryDao.save((List<SurveyQuestionSummary>)toCreateList);
            }
            summaryDao.flushBatch();
        }
    }

    private Map<String, Map<String, Long>> summarizeQuestionAnswerStore(Long surveyId, Date sinceDate) {
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        QuestionDao questionDao = new QuestionDao();
        List<Question> qList = questionDao.listQuestionsInOrder(surveyId, Question.Type.OPTION);
        Cache cache = null;
        HashMap<Integer, Constable> props = new HashMap<Integer, Constable>();
        props.put(0, Integer.valueOf(7200));
        props.put((Integer)MemcacheService.SetPolicy.SET_ALWAYS, Boolean.valueOf(true));
        try {
            CacheFactory cacheFactory = CacheManager.getInstance().getCacheFactory();
            cache = cacheFactory.createCache(props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't initialize cache: " + e.getMessage(), e);
        }
        String cursor = null;
        HashMap<String, Map<String, Long>> summaryMap = new HashMap<String, Map<String, Long>>();
        for (Question q : qList) {
            List<QuestionAnswerStore> qasList = qasDao.listByQuestion(q.getKey().getId(), cursor, QAS_PAGE_SIZE);
            if (qasList == null || qasList.size() == 0) continue;
            do {
                cursor = QuestionAnswerStoreDao.getCursor(qasList);
                for (QuestionAnswerStore qas : qasList) {
                    HashMap<String, Long> countMap;
                    if (cache != null) {
                        HashMap<Long, String> answer = new HashMap<Long, String>();
                        answer.put(qas.getSurveyInstanceId(), qas.getQuestionID());
                        if (cache.containsKey(answer)) {
                            log.log(Level.INFO, "Found duplicated QAS {surveyInstanceId: " + qas.getSurveyInstanceId() + " , questionID: " + qas.getQuestionID() + "}");
                            continue;
                        }
                        cache.put(answer, (Object)true);
                    }
                    if ((countMap = (HashMap<String, Long>)summaryMap.get(qas.getQuestionID())) == null) {
                        countMap = new HashMap<String, Long>();
                        summaryMap.put(qas.getQuestionID(), countMap);
                    }
                    String[] answers = DataUtils.optionResponsesTextArray(qas.getValue());
                    for (int i = 0; i < answers.length; ++i) {
                        Long count = (Long)countMap.get(answers[i]);
                        count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
                        countMap.put(answers[i], count);
                    }
                }
            } while ((qasList = qasDao.listByQuestion(q.getKey().getId(), cursor, QAS_PAGE_SIZE)) != null && qasList.size() > 0);
            cursor = null;
        }
        return summaryMap;
    }

    public static void sendProjectUpdateTask(String country, String cursor) {
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "projectFlagUpdate").param("country", country).param("cursor", cursor != null ? cursor : "");
        Queue queue = QueueFactory.getDefaultQueue();
        queue.add(options);
    }

    public static void fixOptions2Values() {
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        List<QuestionAnswerStore> qasList = siDao.listQAOptions(null, QAS_PAGE_SIZE, "OPTION", "FREE_TEXT", "NUMBER", "SCAN", "PHOTO");
        ArrayList<QuestionAnswerStore> qasChangedList = new ArrayList<QuestionAnswerStore>();
        log.log(Level.INFO, "Running fixOptions2Values");
        if (qasList != null) {
            for (QuestionAnswerStore qas : qasList) {
                if (Question.Type.OPTION.toString().equals(qas.getType()) || Question.Type.NUMBER.toString().equals(qas.getType()) || Question.Type.FREE_TEXT.toString().equals(qas.getType()) || Question.Type.SCAN.toString().equals(qas.getType())) {
                    qas.setType("VALUE");
                    qasChangedList.add(qas);
                    continue;
                }
                if (!Question.Type.PHOTO.toString().equals(qas.getType())) continue;
                qas.setType("IMAGE");
                qasChangedList.add(qas);
            }
            qasDao.save((List<QuestionAnswerStore>)qasChangedList);
            if (qasList.size() == QAS_PAGE_SIZE.intValue()) {
                log.log(Level.INFO, "invoking another fixOptions task");
                Queue queue = QueueFactory.getDefaultQueue();
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "fixOptions2Values");
                queue.add(options);
            }
        }
    }

    private void addTranslationFields(String cursor) {
        SurveyDAO sDao = new SurveyDAO();
        QuestionGroupDao qgDao = new QuestionGroupDao();
        QuestionDao qDao = new QuestionDao();
        QuestionOptionDao qoDao = new QuestionOptionDao();
        TranslationDao tDao = new TranslationDao();
        Long surveyId = null;
        Long questionGroupId = null;
        ArrayList<Translation> tListSave = new ArrayList<Translation>();
        List<Translation> results = tDao.listTranslations(T_PAGE_SIZE, cursor);
        for (Translation t : results) {
            surveyId = null;
            questionGroupId = null;
            switch (t.getParentType()) {
                case SURVEY_NAME: 
                case SURVEY_DESC: {
                    Survey s = sDao.getById(t.getParentId());
                    if (s == null) break;
                    surveyId = s.getKey().getId();
                    break;
                }
                case QUESTION_GROUP_DESC: 
                case QUESTION_GROUP_NAME: {
                    QuestionGroup qg = (QuestionGroup)qgDao.getByKey(t.getParentId());
                    if (qg == null) break;
                    surveyId = qg.getSurveyId();
                    questionGroupId = qg.getKey().getId();
                    break;
                }
                case QUESTION_NAME: 
                case QUESTION_DESC: 
                case QUESTION_TEXT: 
                case QUESTION_TIP: {
                    Question qu = qDao.getByKey(t.getParentId());
                    if (qu == null) break;
                    surveyId = qu.getSurveyId();
                    questionGroupId = qu.getQuestionGroupId();
                    break;
                }
                case QUESTION_OPTION: {
                    Long questionId;
                    Question qu;
                    QuestionOption qo = (QuestionOption)qoDao.getByKey(t.getParentId());
                    if (qo == null || (qu = qDao.getByKey(questionId = qo.getQuestionId())) == null) break;
                    surveyId = qu.getSurveyId();
                    questionGroupId = qu.getQuestionGroupId();
                    break;
                }
            }
            t.setSurveyId(surveyId);
            t.setQuestionGroupId(questionGroupId);
            tListSave.add(t);
        }
        tDao.save(tListSave);
        if (results.size() == T_PAGE_SIZE.intValue()) {
            cursor = TranslationDao.getCursor(results);
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "addTranslationFields").param("cursor", cursor != null ? cursor : "");
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(options);
        }
    }

    public static void addCreationSurveyIdToLocale(String cursor) {
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        List<SurveyedLocale> results = slDao.listAll(cursor, LOCALE_PAGE_SIZE);
        for (SurveyedLocale sl : results) {
            SurveyInstance si;
            if (sl.getCreationSurveyId() != null || sl.getLastSurveyalInstanceId() == null || (si = (SurveyInstance)siDao.getByKey(sl.getLastSurveyalInstanceId())) == null) continue;
            sl.setCreationSurveyId(si.getSurveyId());
            slDao.save(sl);
        }
        if (results.size() == LOCALE_PAGE_SIZE.intValue()) {
            String cursorParam = SurveyedLocaleDao.getCursor(results);
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "addCreationSurveyIdToLocale").param("cursor", cursorParam != null ? cursorParam : "");
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(options);
        }
    }

    public static void populateMonitoringFieldsLocale(String cursor, Long surveyId, Long surveyedLocaleId) {
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        SurveyDAO sDao = new SurveyDAO();
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        QuestionDao qDao = new QuestionDao();
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        List<Object> locales = null;
        if (surveyedLocaleId != null) {
            locales = new ArrayList<SurveyedLocale>();
            locales.add(slDao.getById(surveyedLocaleId));
        } else {
            locales = slDao.listLocalesByCreationSurvey(surveyId, cursor, LOCALE_PAGE_SIZE);
            log.log(Level.INFO, "found surveyedLocales: " + locales.size());
        }
        Cache cache = MemCacheUtils.initCache(43200);
        for (SurveyedLocale surveyedLocale : locales) {
            try {
                if (surveyedLocale.getLastSurveyalInstanceId() == null) {
                    log.log(Level.WARNING, "lastSurveyalInstanceId null for locale: " + surveyedLocale.getKey().getId());
                    continue;
                }
                SurveyInstance si = (SurveyInstance)siDao.getByKey(surveyedLocale.getLastSurveyalInstanceId());
                Boolean addSl = false;
                if (si == null) {
                    log.log(Level.WARNING, "Couldn't find surveyInstance: " + surveyedLocale.getLastSurveyalInstanceId());
                    continue;
                }
                if (surveyedLocale.getSurveyInstanceContrib() == null || surveyedLocale.getSurveyInstanceContrib().size() == 0) {
                    surveyedLocale.addContributingSurveyInstance(surveyedLocale.getLastSurveyalInstanceId());
                    addSl = true;
                }
                Long sIsurveyId = si.getSurveyId();
                String sgKey = "popMonitoringFields-sISurveyGroupId-" + sIsurveyId;
                if (MemCacheUtils.containsKey(cache, sgKey)) {
                    surveyedLocale.setSurveyGroupId((Long)cache.get((Object)sgKey));
                    addSl = true;
                } else {
                    Survey s = (Survey)sDao.getByKey(sIsurveyId);
                    MemCacheUtils.putObject(cache, sgKey, s.getSurveyGroupId());
                    surveyedLocale.setSurveyGroupId(s.getSurveyGroupId());
                    addSl = true;
                }
                String qKey = "popMonitoringFields-displayNameQuestions-" + sIsurveyId;
                List<Long> qList = null;
                if (MemCacheUtils.containsKey(cache, qKey)) {
                    qList = (List)cache.get((Object)qKey);
                } else {
                    qList = new ArrayList();
                    List<Question> questions = qDao.listDisplayNameQuestionsBySurveyId(sIsurveyId);
                    if (questions != null) {
                        for (Question q : questions) {
                            qList.add(q.getKey().getId());
                        }
                    }
                    MemCacheUtils.putObject(cache, qKey, qList);
                }
                if (qList.size() > 0) {
                    String displayName = "";
                    for (Long qId : qList) {
                        QuestionAnswerStore qas = qasDao.getByQuestionAndSurveyInstance(qId, si.getKey().getId());
                        if (qas == null || qas.getValue() == null) continue;
                        if (displayName.length() > 0) {
                            displayName = displayName + " - ";
                        }
                        displayName = displayName + qas.getValue().replaceAll("\\s*\\|\\s*", " - ");
                    }
                    addSl = true;
                    surveyedLocale.setDisplayName(displayName);
                }
                if (!addSl.booleanValue()) continue;
                slDao.save(surveyedLocale);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem while populating monitoring fields: " + e.getMessage(), e);
            }
        }
        if (locales.size() == LOCALE_PAGE_SIZE.intValue()) {
            String cursorParam = SurveyedLocaleDao.getCursor(locales);
            TaskOptions taskOptions = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "populateMonitoringFieldsLocale").param("surveyId", surveyId.toString()).param("cursor", cursorParam != null ? cursorParam : "");
            Queue queue = QueueFactory.getQueue((String)"background-processing");
            queue.add(taskOptions);
        }
    }

    private void createNewIdentifiersLocales(String cursor, Long surveyId) {
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        Pattern localeIdPattern = Pattern.compile("^[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}$");
        List<SurveyedLocale> results = slDao.listLocalesByCreationSurvey(surveyId, cursor, LOCALE_PAGE_SIZE);
        log.log(Level.INFO, "Found " + results.size() + " surveyedLocales for surveyId=" + surveyId);
        for (SurveyedLocale sl : results) {
            if (sl.getIdentifier() != null) {
                String identifier = sl.getIdentifier();
                Matcher localeIdMatcher = localeIdPattern.matcher(identifier);
                if (localeIdMatcher.matches()) continue;
                sl.setIdentifier(SurveyedLocale.generateBase32Uuid(identifier));
            } else {
                sl.setIdentifier(SurveyedLocale.generateBase32Uuid());
            }
            slDao.save(sl);
        }
        if (results.size() == LOCALE_PAGE_SIZE.intValue()) {
            String cursorParam = SurveyedLocaleDao.getCursor(results);
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "createNewIdentifiersLocales").param("surveyId", surveyId.toString()).param("cursor", cursorParam != null ? cursorParam : "");
            Queue queue = QueueFactory.getQueue((String)"background-processing");
            queue.add(options);
        }
    }

    private void populateQuestionOrdersSurveyalValues(Long surveyId, String cursor) {
        SurveyalValueDao svDao = new SurveyalValueDao();
        List<Object> svList = null;
        svList = surveyId != null ? svDao.listBySurvey(surveyId, cursor, SVAL_PAGE_SIZE) : svDao.list(cursor, SVAL_PAGE_SIZE);
        if (svList == null || svList.size() == 0) {
            return;
        }
        QuestionDao qDao = new QuestionDao();
        QuestionGroupDao qgDao = new QuestionGroupDao();
        ArrayList<SurveyalValue> svSaveList = new ArrayList<SurveyalValue>();
        Cache cache = MemCacheUtils.initCache(43200);
        for (SurveyalValue surveyalValue : svList) {
            Long sId = null;
            if (surveyalValue.getSurveyQuestionId() == null) continue;
            Long sqId = surveyalValue.getSurveyQuestionId();
            String orderKey = "q-order-" + sqId;
            if (MemCacheUtils.containsKey(cache, orderKey)) {
                Map orderMap = (Map)cache.get((Object)orderKey);
                surveyalValue.setQuestionOrder((Integer)orderMap.get("q-order"));
                surveyalValue.setQuestionGroupOrder((Integer)orderMap.get("qg-order"));
                sId = (Long)orderMap.get("q-survey-id");
            } else {
                QuestionGroup qg;
                Question q = qDao.getByKey(sqId);
                QuestionGroup questionGroup = qg = q != null && q.getQuestionGroupId() != null ? (QuestionGroup)qgDao.getByKey(q.getQuestionGroupId()) : null;
                if (q != null) {
                    surveyalValue.setQuestionOrder(q.getOrder());
                    sId = q.getSurveyId();
                }
                if (qg != null) {
                    surveyalValue.setQuestionGroupOrder(qg.getOrder());
                }
                HashMap<String, Number> v = new HashMap<String, Number>();
                v.put("q-order", surveyalValue.getQuestionOrder());
                v.put("qg-order", surveyalValue.getQuestionGroupOrder());
                v.put("q-survey-id", surveyalValue.getSurveyId());
                MemCacheUtils.putObject(cache, orderKey, v);
            }
            if (surveyalValue.getSurveyId() == null) {
                surveyalValue.setSurveyId(sId);
            }
            svSaveList.add(surveyalValue);
        }
        svDao.save(svSaveList);
        if (svList.size() == SVAL_PAGE_SIZE.intValue()) {
            Queue queue = QueueFactory.getDefaultQueue();
            String string = SurveyalValueDao.getCursor(svList);
            TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "populateQuestionOrders").param("cursor", string).header("host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
            if (surveyId != null) {
                to.param("surveyId", surveyId.toString());
            }
            queue.add(to);
        }
    }

    private void deleteSurveyResponses(Long surveyInstanceId) {
        this.siDao = new SurveyInstanceDAO();
        SurveyInstance surveyInstance = (SurveyInstance)this.siDao.getByKey(surveyInstanceId);
        if (surveyInstance != null) {
            this.siDao.deleteSurveyInstance(surveyInstance);
        }
    }

    private void updateSurveyResponseCounter(long summaryCounterId, int delta) {
        SurveyQuestionSummaryDao summaryDao = new SurveyQuestionSummaryDao();
        SurveyQuestionSummary summary = (SurveyQuestionSummary)summaryDao.getByKey(summaryCounterId);
        if (summary == null) {
            return;
        }
        summary.setCount(summary.getCount() + (long)delta);
        summaryDao.save(summary);
    }

    private void deleteCascadeNodes(Long cascadeResourceId, Long parentNodeId) {
        CascadeNodeDao dao = new CascadeNodeDao();
        List<CascadeNode> nodes = dao.listCascadeNodesByResourceAndParentId(cascadeResourceId, parentNodeId == null ? 0L : parentNodeId);
        if (nodes.isEmpty()) {
            return;
        }
        if (!this.areLeafNodes(dao, cascadeResourceId, nodes)) {
            for (CascadeNode node : nodes) {
                this.scheduleCascadeNodeDeletion(cascadeResourceId, node.getKey().getId());
            }
        }
        dao.delete(nodes);
    }

    private boolean areLeafNodes(CascadeNodeDao dao, Long cascadeResourceId, List<CascadeNode> nodes) {
        CascadeNode firstNode = nodes.get(0);
        List<CascadeNode> childNodes = dao.listCascadeNodesByResourceAndParentId(cascadeResourceId, firstNode.getKey().getId());
        return childNodes.size() == 0;
    }

    private void scheduleCascadeNodeDeletion(Long cascadeResourceId, Long parentNodeId) {
        try {
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "deleteCascadeNodes").param("cascadeResourceId", cascadeResourceId.toString()).param("parentNodeId", parentNodeId.toString());
            Queue queue = QueueFactory.getQueue((String)"background-processing");
            queue.add(options);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.format("Error scheduling Cascade Node deletion - cascadeResourceId: %s - parentNodeId: %s", cascadeResourceId, parentNodeId), e);
        }
    }

    private void assembleDatapointName(Long surveyGroupId, Long surveyedLocaleId) {
        if (surveyedLocaleId == null && surveyGroupId == null) {
            log.log(Level.WARNING, "Either surveyGroupId or surveyedLocaleId must be defined");
            return;
        }
        SurveyGroupDAO sgDao = new SurveyGroupDAO();
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        QuestionDao qDao = new QuestionDao();
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        List<SurveyedLocale> locales = null;
        if (surveyedLocaleId != null) {
            SurveyedLocale sl = slDao.getById(surveyedLocaleId);
            if (sl == null) {
                log.log(Level.WARNING, "SurveyedLocale not found: " + surveyedLocaleId);
                return;
            }
            surveyGroupId = sl.getSurveyGroupId();
            locales = new ArrayList<SurveyedLocale>();
            locales.add(slDao.getById(surveyedLocaleId));
        } else {
            locales = slDao.listLocalesBySurveyGroupId(surveyGroupId);
        }
        SurveyGroup sg = (SurveyGroup)sgDao.getByKey(surveyGroupId);
        if (sg == null || sg.getNewLocaleSurveyId() == null) {
            log.log(Level.WARNING, "SurveyGroup or registration form not found: " + surveyGroupId);
            return;
        }
        List<Question> nameQuestions = qDao.listDisplayNameQuestionsBySurveyId(sg.getNewLocaleSurveyId());
        for (SurveyedLocale sl : locales) {
            try {
                SurveyInstance si = siDao.getRegistrationSurveyInstance(sl, sg.getNewLocaleSurveyId());
                if (si == null) {
                    log.log(Level.WARNING, "Null registartion SurveyInstance for locale: " + sl.getKey().getId());
                    continue;
                }
                List<QuestionAnswerStore> responses = qasDao.listBySurveyInstance(si.getKey().getId());
                sl.assembleDisplayName(nameQuestions, responses);
                log.info("Reassembled display name for SurveyedLocale : " + sl.getKey().getId() + ": " + sl.getDisplayName());
                slDao.save(sl);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem while assembling datapoint name: " + e.getMessage(), e);
            }
        }
    }

    public static void scheduleDatapointNameAssembly(Long surveyGroupId, Long surveyedLocaleId) {
        DataProcessorRestServlet.scheduleDatapointNameAssembly(surveyGroupId, surveyedLocaleId, false);
    }

    public static void scheduleDatapointNameAssembly(Long surveyGroupId, Long surveyedLocaleId, boolean delay) {
        log.info("Scheduling name assembly for survey group, locale - " + surveyGroupId + ", " + surveyedLocaleId);
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "assembleDatapointName");
        if (delay) {
            options.countdownMillis(3000L);
        }
        if (surveyGroupId != null) {
            options.param("surveyGroupId", String.valueOf(surveyGroupId));
        }
        if (surveyedLocaleId != null) {
            options.param("surveyedLocaleId", String.valueOf(surveyedLocaleId));
        }
        Queue queue = QueueFactory.getQueue((String)"background-processing");
        queue.add(options);
    }
}

