/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.DataImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.codehaus.jackson.map.ObjectMapper;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.dataexport.ExportImportUtils;
import org.waterforpeople.mapping.dataexport.InstanceData;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class RawDataSpreadsheetImporter
implements DataImporter {
    private static final Logger log = Logger.getLogger(RawDataSpreadsheetImporter.class);
    private static final String SERVLET_URL = "/rawdatarestapi";
    public static final String SURVEY_CONFIG_KEY = "surveyId";
    protected static final String KEY_PARAM = "apiKey";
    private InputStream stream;
    private ThreadPoolExecutor threadPool;
    private BlockingQueue<Runnable> jobQueue;
    private List<String> errorIds;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int LEGACY_MONITORING_FORMAT = 6;
    private static final int MONITORING_FORMAT_WITH_DEVICE_ID_COLUMN = 7;
    private static final int MONITORING_FORMAT_WITH_REPEAT_COLUMN = 8;
    private static final int MONITORING_FORMAT_WITH_APPROVAL_COLUMN = 9;
    private static final int MONITORING_FORMAT_WITH_FORM_VERSION = 10;
    private boolean otherValuesInSeparateColumns = false;
    public static final String DATAPOINT_IDENTIFIER_COLUMN_KEY = "dataPointIdentifier";
    private static final String DATAPOINT_APPROVAL_COLUMN_KEY = "dataPointApproval";
    public static final String REPEAT_COLUMN_KEY = "repeat";
    public static final String DATAPOINT_NAME_COLUMN_KEY = "dataPointDisplayName";
    public static final String DEVICE_IDENTIFIER_COLUMN_KEY = "deviceIdentifier";
    public static final String SURVEY_INSTANCE_COLUMN_KEY = "surveyInstanceId";
    public static final String COLLECTION_DATE_COLUMN_KEY = "collectionDate";
    public static final String SUBMITTER_COLUMN_KEY = "submitterName";
    public static final String DURATION_COLUMN_KEY = "surveyalTime";
    public static final String FORM_VER_COLUMN_KEY = "formVersion";
    public static final String NEW_DATA_PATTERN = "^[Nn]ew-\\d+";

    public Sheet getDataSheet(File file) {
        Workbook wb = null;
        try {
            this.stream = new PushbackInputStream(new FileInputStream(file));
            wb = WorkbookFactory.create((InputStream)this.stream);
        }
        catch (Exception e) {
            log.error((Object)("Workbook creation exception:" + e));
        }
        return wb.getSheetAt(0);
    }

    protected void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImport(File file, String serverBase, Map<String, String> criteria) {
        try {
            log.info((Object)String.format("Importing %s to %s using criteria %s", file, serverBase, criteria));
            Workbook wb = this.getDataSheet(file).getWorkbook();
            int headerRowIndex = 1;
            HashMap<Sheet, Map<Integer, Long>> sheetMap = new HashMap<Sheet, Map<Integer, Long>>();
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                Sheet sheet = wb.getSheetAt(i);
                String sn = sheet.getSheetName();
                if (i != 0 && !sn.startsWith("Group ")) continue;
                sheetMap.put(sheet, RawDataSpreadsheetImporter.processHeader(sheet, headerRowIndex));
                this.otherValuesInSeparateColumns |= this.separatedOtherValues(sheet, headerRowIndex);
            }
            Map<Long, QuestionDto> questionIdToQuestionDto = RawDataSpreadsheetImporter.fetchQuestions(serverBase, criteria);
            Map<Long, List<QuestionOptionDto>> optionNodes = RawDataSpreadsheetImporter.fetchOptionNodes(serverBase, criteria, questionIdToQuestionDto.values());
            List<InstanceData> instanceDataList = this.parseSplitSheets(wb.getSheetAt(0), sheetMap, questionIdToQuestionDto, optionNodes, headerRowIndex);
            for (InstanceData instanceData : instanceDataList) {
                if (!instanceData.surveyInstanceDto.getSurveyedLocaleIdentifier().matches(NEW_DATA_PATTERN)) continue;
                instanceData.surveyInstanceDto.setSurveyedLocaleIdentifier("");
            }
            ArrayList<String> importUrls = new ArrayList<String>();
            String surveyId = criteria.get(SURVEY_CONFIG_KEY);
            for (InstanceData instanceData : instanceDataList) {
                String importUrl = RawDataSpreadsheetImporter.buildImportURL(instanceData, surveyId, questionIdToQuestionDto);
                importUrls.add(importUrl);
            }
            log.info((Object)String.format("Attempting to upload %s form instances to %s", importUrls.size(), serverBase));
            this.errorIds = new ArrayList<String>();
            this.jobQueue = new LinkedBlockingQueue<Runnable>();
            this.threadPool = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, this.jobQueue);
            for (String importUrl : importUrls) {
                this.sendDataToServer(serverBase, importUrl, criteria.get(KEY_PARAM));
            }
            while (!this.jobQueue.isEmpty() && this.threadPool.getActiveCount() > 0) {
                Thread.sleep(5000L);
            }
            if (this.errorIds.size() > 0) {
                log.error((Object)"There were ERRORS: ");
                for (String line : this.errorIds) {
                    log.error((Object)line);
                }
            }
            Thread.sleep(5000L);
            log.debug((Object)"Updating summaries");
            this.invokeUrl(serverBase, "action=updateSummaries&surveyId=" + surveyId, true, criteria.get(KEY_PARAM));
            this.invokeUrl(serverBase, "action=saveMessage&surveyId=" + surveyId, true, criteria.get(KEY_PARAM));
        }
        catch (Exception e) {
            log.error((Object)"Failed to import raw data report", (Throwable)e);
        }
        finally {
            if (this.threadPool != null) {
                this.threadPool.shutdown();
            }
            this.cleanup();
        }
    }

    public List<InstanceData> parseSplitSheets(Sheet baseSheet, Map<Sheet, Map<Integer, Long>> sheetMap, Map<Long, QuestionDto> questionIdToQuestionDto, Map<Long, List<QuestionOptionDto>> optionNodes, int headerRowIndex) throws Exception {
        InstanceData instanceData;
        ArrayList<InstanceData> result = new ArrayList<InstanceData>();
        HashMap<Sheet, Integer> sheetPosition = new HashMap<Sheet, Integer>();
        int md5Column = 0;
        while (!this.isEmptyCell(baseSheet.getRow(headerRowIndex).getCell(md5Column))) {
            ++md5Column;
        }
        Map<Integer, Long> columnIndexToQuestionId = sheetMap.get(baseSheet);
        int firstQuestionColumnIndex = Collections.min(columnIndexToQuestionId.keySet());
        Map<String, Integer> metadataColumnHeaderIndex = this.getMetadataColumnIndex(baseSheet, firstQuestionColumnIndex, headerRowIndex, false);
        Map<String, Integer> repMetadataIndex = null;
        int row = headerRowIndex + 1;
        while ((instanceData = this.parseInstance(baseSheet, row, metadataColumnHeaderIndex, firstQuestionColumnIndex, questionIdToQuestionDto, columnIndexToQuestionId, optionNodes, false)) != null) {
            String newMd5Hash;
            ArrayList<Row> allRows = new ArrayList<Row>();
            for (Sheet repSheet : sheetMap.keySet()) {
                Integer pos;
                if (repSheet == baseSheet) continue;
                Map<Integer, Long> repQMap = sheetMap.get(repSheet);
                int repFirstQIdx = Collections.min(repQMap.keySet());
                if (repMetadataIndex == null) {
                    repMetadataIndex = this.getMetadataColumnIndex(repSheet, repFirstQIdx, headerRowIndex, true);
                }
                if ((pos = (Integer)sheetPosition.get(repSheet)) == null) {
                    pos = headerRowIndex + 1;
                }
                pos = this.parseRepeatsForInstance(instanceData, repSheet, pos, repMetadataIndex, questionIdToQuestionDto, repQMap, optionNodes, allRows);
                sheetPosition.put(repSheet, pos);
            }
            allRows.add(baseSheet.getRow(row));
            String existingMd5Hash = "";
            Cell md5Cell = baseSheet.getRow(row).getCell(md5Column);
            if (md5Cell != null) {
                existingMd5Hash = md5Cell.getStringCellValue();
            }
            if (!(newMd5Hash = ExportImportUtils.md5Digest(allRows, md5Column - 1, baseSheet)).equals(existingMd5Hash)) {
                result.add(instanceData);
            }
            ++row;
        }
        return result;
    }

    private Map<String, Integer> getMetadataColumnIndex(Sheet sheet, int firstQuestionColumnIndex, int headerRow, boolean singleOrRepSheet) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        Row row = sheet.getRow(headerRow);
        for (int i = 0; i < firstQuestionColumnIndex; ++i) {
            String header = row.getCell(i).getStringCellValue();
            if (header.equalsIgnoreCase("Identifier")) {
                index.put(DATAPOINT_IDENTIFIER_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Data approval status")) {
                index.put(DATAPOINT_APPROVAL_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Repeat no")) {
                index.put(REPEAT_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Display Name")) {
                index.put(DATAPOINT_NAME_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Device identifier")) {
                index.put(DEVICE_IDENTIFIER_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Instance")) {
                index.put(SURVEY_INSTANCE_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Submission Date")) {
                index.put(COLLECTION_DATE_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Submitter")) {
                index.put(SUBMITTER_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Duration")) {
                index.put(DURATION_COLUMN_KEY, i);
                continue;
            }
            if (header.equalsIgnoreCase("Form version")) {
                index.put(FORM_VER_COLUMN_KEY, i);
                continue;
            }
            log.warn((Object)("Unknown column header '" + header + "'"));
        }
        return index;
    }

    boolean checkCol(Map<String, Integer> index, String name) {
        if (!index.containsKey(name)) {
            log.warn((Object)("Required column '" + name + "' not found!"));
            return false;
        }
        return true;
    }

    private Integer parseRepeatsForInstance(InstanceData instanceData, Sheet repSheet, int currentRowIndex, Map<String, Integer> metadataColumnHeaderIdx, Map<Long, QuestionDto> questionIdToQuestionDto, Map<Integer, Long> columnIndexToQuestionId, Map<Long, List<QuestionOptionDto>> optionNodes, List<Row> checksumRows) {
        Row row;
        int identifierColumnIndex = metadataColumnHeaderIdx.get(DATAPOINT_IDENTIFIER_COLUMN_KEY);
        int repeatIterationColumnIndex = metadataColumnHeaderIdx.get(REPEAT_COLUMN_KEY);
        String dataPointIdentifier = instanceData.surveyInstanceDto.getSurveyedLocaleIdentifier();
        int rowIx = currentRowIndex;
        while ((row = repSheet.getRow(rowIx)) == null || row.getCell(identifierColumnIndex) == null || !row.getCell(identifierColumnIndex).getStringCellValue().equals(dataPointIdentifier)) {
            if (rowIx > repSheet.getLastRowNum()) {
                rowIx = 1;
            }
            if (++rowIx != currentRowIndex) continue;
            return rowIx;
        }
        HashMap<Long, Map<Long, String>> responseMap = new HashMap<Long, Map<Long, String>>();
        while (row != null && row.getCell(identifierColumnIndex) != null && row.getCell(identifierColumnIndex).getStringCellValue().equals(dataPointIdentifier) && row.getCell(repeatIterationColumnIndex) != null && row.getCell(repeatIterationColumnIndex).getCellType() == 0) {
            Long rep = (long)row.getCell(repeatIterationColumnIndex).getNumericCellValue();
            if (rep < 1L) continue;
            checksumRows.add(row);
            for (Map.Entry<Integer, Long> m : columnIndexToQuestionId.entrySet()) {
                int columnIndex = m.getKey();
                long questionId = m.getValue();
                QuestionDto questionDto = questionIdToQuestionDto.get(questionId);
                if (questionDto == null) continue;
                QuestionDto.QuestionType questionType = questionDto.getType();
                this.getIterationResponse(row, columnIndex, responseMap, questionType, questionId, questionDto, rep, optionNodes);
            }
            row = repSheet.getRow(++rowIx);
        }
        if (!instanceData.addResponses(responseMap)) {
            log.warn((Object)"Some questions have answers on more than one sheet!");
        }
        return rowIx;
    }

    public InstanceData parseInstance(Sheet sheet, int startRow, Map<String, Integer> metadataColumnHeaderIndex, int firstQuestionColumnIndex, Map<Long, QuestionDto> questionIdToQuestionDto, Map<Integer, Long> columnIndexToQuestionId, Map<Long, List<QuestionOptionDto>> optionNodes, boolean singleOrRepSheet) {
        Row baseRow = sheet.getRow(startRow);
        if (this.isEmptyRow(baseRow)) {
            return null;
        }
        String surveyedLocaleIdentifier = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, DATAPOINT_IDENTIFIER_COLUMN_KEY);
        String surveyedLocaleDisplayName = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, DATAPOINT_NAME_COLUMN_KEY);
        String deviceIdentifier = "";
        if (metadataColumnHeaderIndex.containsKey(DEVICE_IDENTIFIER_COLUMN_KEY)) {
            deviceIdentifier = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, DEVICE_IDENTIFIER_COLUMN_KEY);
        }
        String surveyInstanceId = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, SURVEY_INSTANCE_COLUMN_KEY);
        Date collectionDate = ExportImportUtils.parseSpreadsheetDate(RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, COLLECTION_DATE_COLUMN_KEY));
        String submitterName = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, SUBMITTER_COLUMN_KEY);
        String surveyalTime = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, DURATION_COLUMN_KEY);
        Double formVer = null;
        if (metadataColumnHeaderIndex.containsKey(FORM_VER_COLUMN_KEY)) {
            String fvStr = RawDataSpreadsheetImporter.getMetadataCellContent(baseRow, metadataColumnHeaderIndex, FORM_VER_COLUMN_KEY);
            try {
                formVer = Double.valueOf(fvStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int iterations = 1;
        int repeatIterationColumnIndex = -1;
        if (singleOrRepSheet) {
            Row row;
            repeatIterationColumnIndex = metadataColumnHeaderIndex.get(REPEAT_COLUMN_KEY);
            while ((row = sheet.getRow(startRow + iterations)) != null && !this.isEmptyCell(row.getCell(repeatIterationColumnIndex)) && !ExportImportUtils.parseCellAsString(row.getCell(repeatIterationColumnIndex)).equals("1")) {
                ++iterations;
            }
        }
        HashMap<Long, Map<Long, String>> responseMap = new HashMap<Long, Map<Long, String>>();
        for (Map.Entry<Integer, Long> m : columnIndexToQuestionId.entrySet()) {
            int columnIndex = m.getKey();
            long questionId = m.getValue();
            QuestionDto questionDto = questionIdToQuestionDto.get(questionId);
            if (questionDto == null) continue;
            QuestionDto.QuestionType questionType = questionDto.getType();
            for (int iter = 0; iter < iterations; ++iter) {
                Cell cell;
                Row iterationRow = sheet.getRow(startRow + iter);
                long iteration = 1L;
                if (singleOrRepSheet && (cell = iterationRow.getCell(repeatIterationColumnIndex)) != null) {
                    iteration = (long)iterationRow.getCell(repeatIterationColumnIndex).getNumericCellValue();
                }
                this.getIterationResponse(iterationRow, columnIndex, responseMap, questionType, questionId, questionDto, iteration, optionNodes);
            }
        }
        SurveyInstanceDto surveyInstanceDto = new SurveyInstanceDto();
        surveyInstanceDto.setSurveyedLocaleIdentifier(surveyedLocaleIdentifier);
        surveyInstanceDto.setSurveyedLocaleDisplayName(surveyedLocaleDisplayName);
        surveyInstanceDto.setDeviceIdentifier(deviceIdentifier);
        if (!surveyInstanceId.equals("")) {
            surveyInstanceDto.setKeyId(Long.parseLong(surveyInstanceId));
        }
        surveyInstanceDto.setCollectionDate(collectionDate);
        surveyInstanceDto.setSubmitterName(submitterName);
        surveyInstanceDto.setSurveyalTime((long)this.durationToSeconds(surveyalTime));
        surveyInstanceDto.setFormVersion(formVer);
        InstanceData instanceData = new InstanceData(surveyInstanceDto, responseMap);
        instanceData.maxIterationsCount = iterations;
        return instanceData;
    }

    private void getIterationResponse(Row iterationRow, int columnIndex, Map<Long, Map<Long, String>> responseMap, QuestionDto.QuestionType questionType, Long questionId, QuestionDto questionDto, Long iteration, Map<Long, List<QuestionOptionDto>> optionNodes) {
        block35: {
            Cell cell;
            String val;
            block34: {
                val = "";
                cell = iterationRow.getCell(columnIndex);
                if (cell != null) break block34;
                if (questionType != QuestionDto.QuestionType.OPTION || !Boolean.TRUE.equals(questionDto.getAllowOtherFlag() != false && this.otherValuesInSeparateColumns)) break block35;
            }
            switch (questionType) {
                case GEO: {
                    String latitude = ExportImportUtils.parseCellAsString(cell);
                    String longitude = ExportImportUtils.parseCellAsString(iterationRow.getCell(columnIndex + 1));
                    String elevation = ExportImportUtils.parseCellAsString(iterationRow.getCell(columnIndex + 2));
                    if (latitude == "" || longitude == "") break;
                    val = latitude + "|" + longitude + "|" + elevation;
                    break;
                }
                case CASCADE: {
                    String cascadeString = ExportImportUtils.parseCellAsString(cell);
                    String[] cascadeParts = cascadeString.split("\\|");
                    ArrayList cascadeList = new ArrayList();
                    for (String cascadeNode : cascadeParts) {
                        String[] codeAndName = cascadeNode.split(":");
                        HashMap<String, String> cascadeMap = new HashMap<String, String>();
                        if (codeAndName.length == 1) {
                            cascadeMap.put("name", codeAndName[0]);
                        } else if (codeAndName.length == 2) {
                            cascadeMap.put("code", codeAndName[0]);
                            cascadeMap.put("name", codeAndName[1]);
                        } else {
                            log.warn((Object)("Invalid cascade node: " + cascadeNode));
                        }
                        cascadeList.add(cascadeMap);
                    }
                    try {
                        val = OBJECT_MAPPER.writeValueAsString(cascadeList);
                    }
                    catch (IOException e) {
                        log.warn((Object)("Could not parse cascade string: " + cascadeString));
                    }
                    break;
                }
                case OPTION: {
                    ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
                    String optionString = ExportImportUtils.parseCellAsString(cell);
                    if (!optionString.isEmpty()) {
                        String[] optionParts;
                        for (String optionNode : optionParts = optionString.split("\\|")) {
                            optionList.add(this.parsedOptionValue(optionNode, false));
                        }
                    }
                    if (Boolean.TRUE.equals(questionDto.getAllowOtherFlag())) {
                        if (this.otherValuesInSeparateColumns) {
                            Cell otherCell = iterationRow.getCell(columnIndex + 1);
                            String otherString = ExportImportUtils.parseCellAsString(otherCell);
                            if (otherString != null && !otherString.trim().isEmpty()) {
                                optionList.add(this.parsedOptionValue(otherString, true));
                            }
                        } else if (!optionList.isEmpty()) {
                            Map lastNode = (Map)optionList.get(optionList.size() - 1);
                            String lastNodeText = (String)lastNode.get("text");
                            boolean isOther = true;
                            List<QuestionOptionDto> existingOptions = optionNodes.get(questionId);
                            if (existingOptions != null && lastNodeText != null) {
                                for (QuestionOptionDto questionOptionDto : existingOptions) {
                                    if (!lastNodeText.equals(questionOptionDto.getText())) continue;
                                    isOther = false;
                                    break;
                                }
                            }
                            if (isOther) {
                                lastNode.put("isOther", true);
                            }
                        }
                    }
                    try {
                        if (optionList.isEmpty()) break;
                        val = OBJECT_MAPPER.writeValueAsString(optionList);
                    }
                    catch (IOException e) {
                        log.warn((Object)("Could not parse option string: " + optionString), (Throwable)e);
                    }
                    break;
                }
                case DATE: {
                    String dateString = ExportImportUtils.parseCellAsString(cell);
                    Date date = ExportImportUtils.parseSpreadsheetDate(dateString);
                    if (date != null) {
                        val = String.valueOf(date.getTime());
                        break;
                    }
                    log.warn((Object)("Could not parse date string: " + dateString));
                    break;
                }
                case SIGNATURE: {
                    val = null;
                    break;
                }
                case CADDISFLY: {
                    val = null;
                    break;
                }
                default: {
                    val = ExportImportUtils.parseCellAsString(cell);
                }
            }
            if (val != null && !val.equals("")) {
                Map<Long, String> iterationToResponse = responseMap.get(questionId);
                if (iterationToResponse == null) {
                    iterationToResponse = new HashMap<Long, String>();
                    iterationToResponse.put(iteration - 1L, val);
                    responseMap.put(questionId, iterationToResponse);
                } else {
                    iterationToResponse.put(iteration - 1L, val);
                }
            }
        }
    }

    private Map<String, Object> parsedOptionValue(String optionNode, boolean other) {
        String[] codeAndText = optionNode.split(":", 2);
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        if (codeAndText.length == 1) {
            optionMap.put("text", codeAndText[0].trim());
        } else if (codeAndText.length == 2) {
            optionMap.put("code", codeAndText[0].trim());
            optionMap.put("text", codeAndText[1].trim());
        }
        if (other) {
            optionMap.put("isOther", true);
        }
        return optionMap;
    }

    private static String getMetadataCellContent(Row baseRow, Map<String, Integer> metadataColumnHeaderIndex, String metadataCellColumnKey) {
        Cell metadataCell = baseRow.getCell(metadataColumnHeaderIndex.get(metadataCellColumnKey).intValue());
        return ExportImportUtils.parseCellAsString(metadataCell);
    }

    private boolean separatedOtherValues(Sheet sheet, int headerRowIndex) {
        Row headerRow = sheet.getRow(headerRowIndex);
        for (Cell cell : headerRow) {
            String cellValue = cell.getStringCellValue();
            if (cell.getStringCellValue().indexOf("|") <= -1 || !cellValue.endsWith("--OTHER--")) continue;
            return true;
        }
        return false;
    }

    private static Map<Integer, Long> processHeader(Sheet sheet, int headerRowIndex) {
        HashMap<Integer, Long> columnIndexToQuestionId = new HashMap<Integer, Long>();
        Row headerRow = sheet.getRow(headerRowIndex);
        for (Cell cell : headerRow) {
            String[] parts;
            String cellValue = cell.getStringCellValue();
            if (cell.getStringCellValue().indexOf("|") <= -1 || cellValue.startsWith("--GEO") || cellValue.endsWith("--OTHER--") || cellValue.startsWith("--CADDISFLY") || (parts = cell.getStringCellValue().split("\\|"))[0].trim().length() <= 0) continue;
            columnIndexToQuestionId.put(cell.getColumnIndex(), Long.valueOf(parts[0].trim()));
        }
        return columnIndexToQuestionId;
    }

    private static Map<Long, QuestionDto> fetchQuestions(String serverBase, Map<String, String> criteria) throws Exception {
        String apiKey;
        String surveyId = criteria.get(SURVEY_CONFIG_KEY);
        Object[] results = BulkDataServiceClient.loadQuestions(surveyId, serverBase, apiKey = criteria.get(KEY_PARAM));
        if (results == null) {
            throw new Exception("Could not fetch questions");
        }
        HashMap<Long, QuestionDto> questionMap = new HashMap<Long, QuestionDto>();
        for (Map.Entry entry : ((Map)results[1]).entrySet()) {
            questionMap.put(Long.valueOf((String)entry.getKey()), (QuestionDto)entry.getValue());
        }
        return questionMap;
    }

    private static Map<Long, List<QuestionOptionDto>> fetchOptionNodes(String serverBase, Map<String, String> criteria, Collection<QuestionDto> questions) throws Exception {
        String surveyId = criteria.get(SURVEY_CONFIG_KEY);
        String apiKey = criteria.get(KEY_PARAM);
        ArrayList<Long> optionQuestionIds = new ArrayList<Long>();
        for (QuestionDto question : questions) {
            if (!QuestionDto.QuestionType.OPTION.equals((Object)question.getType())) continue;
            optionQuestionIds.add(question.getKeyId());
        }
        return BulkDataServiceClient.fetchOptionNodes(surveyId, serverBase, apiKey, optionQuestionIds);
    }

    private static String buildImportURL(InstanceData instanceData, String surveyId, Map<Long, QuestionDto> questionIdToQuestionDto) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        SurveyInstanceDto dto = instanceData.surveyInstanceDto;
        sb.append("action=saveSurveyInstance&surveyId=" + surveyId + "&");
        if (dto.getKeyId() != null) {
            sb.append("surveyInstanceId=" + dto.getKeyId() + "&");
        }
        String dateString = ExportImportUtils.formatDateTime(dto.getCollectionDate());
        sb.append("collectionDate=" + URLEncoder.encode(dateString, "UTF-8"));
        sb.append("&submitter=" + URLEncoder.encode(dto.getSubmitterName(), "UTF-8"));
        sb.append("&duration=" + dto.getSurveyalTime());
        if (dto.getFormVersion() != null) {
            sb.append("&formVersion=" + dto.getFormVersion());
        }
        for (Map.Entry<Long, SortedMap<Long, String>> entry : instanceData.responseMap.entrySet()) {
            Long questionId = entry.getKey();
            sb.append("&questionId=" + questionId);
            SortedMap<Long, String> iterations = entry.getValue();
            StringBuilder responseBuilder = new StringBuilder();
            for (Map.Entry<Long, String> iterationEntry : iterations.entrySet()) {
                Long iteration = iterationEntry.getKey();
                String response = iterationEntry.getValue();
                responseBuilder.append("|" + iteration + "=" + URLEncoder.encode(response, "UTF-8"));
            }
            sb.append(URLEncoder.encode(responseBuilder.toString(), "UTF-8"));
            String typeString = "VALUE";
            QuestionDto questionDto = questionIdToQuestionDto.get(questionId);
            if (questionDto != null) {
                switch (questionDto.getType()) {
                    case GEO: {
                        typeString = "GEO";
                        break;
                    }
                    case PHOTO: {
                        typeString = "IMAGE";
                        break;
                    }
                    case VIDEO: {
                        typeString = "VIDEO";
                        break;
                    }
                    case DATE: {
                        typeString = "DATE";
                        break;
                    }
                    case CASCADE: {
                        typeString = "CASCADE";
                        break;
                    }
                    case OPTION: {
                        typeString = "OPTION";
                        break;
                    }
                }
            }
            sb.append(URLEncoder.encode("|type=" + typeString, "UTF-8"));
        }
        return sb.toString();
    }

    private Integer durationToSeconds(String duration) {
        if (duration == null || duration.length() == 0) {
            return 0;
        }
        if (!duration.contains(":")) {
            try {
                int seconds = Integer.parseInt(duration);
                return seconds;
            }
            catch (Exception e) {
                return 0;
            }
        }
        String[] tokens = duration.split(":");
        if (tokens.length != 3) {
            return 0;
        }
        try {
            int hours = Integer.parseInt(tokens[0]);
            int minutes = Integer.parseInt(tokens[1]);
            int seconds = Integer.parseInt(tokens[2]);
            return 3600 * hours + 60 * minutes + seconds;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void sendDataToServer(final String serverBase, final String saveUrlString, final String key) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RawDataSpreadsheetImporter.this.invokeUrl(serverBase, saveUrlString, true, key);
                }
                catch (Exception e) {
                    RawDataSpreadsheetImporter.this.errorIds.add(saveUrlString);
                    System.err.println("Could not invoke rest services: " + e);
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    protected void invokeUrl(String serverBase, String urlString, boolean shouldSign, String key) throws Exception {
        BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, urlString, shouldSign, key);
    }

    @Override
    public Map<Integer, String> validate(File file) {
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        try {
            Sheet sheet = this.getDataSheet(file);
            boolean splitSheets = RawDataSpreadsheetImporter.safeCellCompare(sheet, 0, 0, "Metadata");
            if (!splitSheets) {
                errorMap.put(0, "First header cell must contain 'Metadata'");
                return errorMap;
            }
            int headerRowIndex = splitSheets ? 1 : 0;
            Row headerRow = sheet.getRow(headerRowIndex);
            boolean firstQuestionFound = false;
            int firstQuestionColumnIndex = 0;
            for (Cell cell : headerRow) {
                String cellValue = cell.getStringCellValue();
                if ((cellValue == null || cellValue.trim().isEmpty()) && this.isMissingHeaderCell(cell)) {
                    errorMap.put(cell.getColumnIndex(), String.format("Cannot import data from Column %s - \"%s\". Please check and/or fix the header cell", CellReference.convertNumToColString((int)cell.getColumnIndex()), cellValue));
                    break;
                }
                if (firstQuestionFound || !cellValue.matches("[0-9]+\\|.+")) continue;
                firstQuestionFound = true;
                firstQuestionColumnIndex = cell.getColumnIndex();
                if (!this.isSupportedReportFormat(firstQuestionColumnIndex)) {
                    errorMap.put(firstQuestionColumnIndex, "Found the first question at the wrong column index");
                    break;
                }
                log.info((Object)("Importing report with first question column index: " + firstQuestionColumnIndex));
            }
            if (!firstQuestionFound) {
                errorMap.put(-1, "A question could not be found");
            }
            Workbook wb = sheet.getWorkbook();
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                sheet = wb.getSheetAt(i);
                Map<String, Integer> index = this.getMetadataColumnIndex(sheet, firstQuestionColumnIndex, headerRowIndex, false);
                if (!this.checkCol(index, DATAPOINT_IDENTIFIER_COLUMN_KEY)) {
                    errorMap.put(-1, "Column header 'Identifier' missing on sheet " + i);
                }
                if (!this.checkCol(index, DATAPOINT_NAME_COLUMN_KEY)) {
                    errorMap.put(-1, "Column header 'Display Name' missing on sheet " + i);
                }
                if (!this.checkCol(index, SURVEY_INSTANCE_COLUMN_KEY)) {
                    errorMap.put(-1, "Column header 'Instance' missing on sheet " + i);
                }
                if (!this.checkCol(index, COLLECTION_DATE_COLUMN_KEY)) {
                    errorMap.put(-1, "Column header 'Submission Date' missing on sheet " + i);
                }
                if (!this.checkCol(index, SUBMITTER_COLUMN_KEY)) {
                    errorMap.put(-1, "Column header 'Submitter' missing on sheet " + i);
                }
                if (!this.checkCol(index, DURATION_COLUMN_KEY)) {
                    errorMap.put(-1, "Column header 'Duration' missing on sheet " + i);
                }
                if (i > 0 && !this.checkCol(index, "Repeat no")) {
                    errorMap.put(-1, "Column header 'Repeat no' missing on sheet " + i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            errorMap.put(-1, e.getMessage());
        }
        return errorMap;
    }

    private boolean isSupportedReportFormat(int firstQuestionColumnIndex) {
        return firstQuestionColumnIndex == 6 || firstQuestionColumnIndex == 7 || firstQuestionColumnIndex == 8 || firstQuestionColumnIndex == 9 || firstQuestionColumnIndex == 10;
    }

    private static boolean safeCellCompare(Sheet sheet, int row, int col, String value) {
        return sheet.getRow(row) != null && sheet.getRow(row).getCell(col) != null && sheet.getRow(row).getCell(col).getCellType() == 1 && sheet.getRow(row).getCell(col).getStringCellValue().trim().equals(value);
    }

    private boolean isEmptyCell(Cell cell) {
        return cell == null || cell.getCellType() == 3 || cell.getCellType() == 1 && cell.getStringCellValue().trim().equals("");
    }

    private boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        if (row.getFirstCellNum() == -1) {
            return true;
        }
        boolean blank = true;
        for (int ix = row.getFirstCellNum(); ix < row.getLastCellNum(); ++ix) {
            if (this.isEmptyCell(row.getCell(ix))) continue;
            blank = false;
            break;
        }
        return blank;
    }

    private boolean isMissingHeaderCell(Cell cell) {
        assert (cell.getRow().getRowNum() == 0);
        Row row = cell.getRow();
        for (int i = cell.getColumnIndex(); i < row.getLastCellNum(); ++i) {
            if (row.getCell(i) == null || row.getCell(i).getStringCellValue().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        if (args.length != 4) {
            log.error((Object)"Error.\nUsage:\n\tjava org.waterforpeople.mapping.dataexport.RawDataSpreadsheetImporter <file> <serverBase> <surveyId> <apiKey>");
            System.exit(1);
        }
        File file = new File(args[0].trim());
        String serverBaseArg = args[1].trim();
        RawDataSpreadsheetImporter r = new RawDataSpreadsheetImporter();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(SURVEY_CONFIG_KEY, args[2].trim());
        configMap.put(KEY_PARAM, args[3].trim());
        Map<Integer, String> validationErrors = r.validate(file);
        if (validationErrors.isEmpty()) {
            r.executeImport(file, serverBaseArg, configMap);
        }
    }
}

