/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest.security;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.gallatinsystems.common.Constants;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.dao.UserRoleDao;
import com.gallatinsystems.user.domain.Permission;
import com.gallatinsystems.user.domain.UserAuthorization;
import com.gallatinsystems.user.domain.UserRole;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.domain.RootFolder;
import org.akvo.flow.domain.SecuredObject;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;

public class RequestUriVoter
implements AccessDecisionVoter<FilterInvocation> {
    private static final Logger log = Logger.getLogger(RequestUriVoter.class.getName());
    private static String PROJECT_FOLDER_URI_PREFIX = Permission.PROJECT_FOLDER_CREATE.getUriPrefix();
    private static String FORM_URI_PREFIX = Permission.FORM_CREATE.getUriPrefix();
    private static String SURVEY_RESPONSE_URI_PREFIX = Permission.DATA_DELETE.getUriPrefix();
    private static String URI_SUFFIX = "/(\\d*)";
    private static final Pattern URI_PATTERN = Pattern.compile("(" + PROJECT_FOLDER_URI_PREFIX + "|" + FORM_URI_PREFIX + "|" + SURVEY_RESPONSE_URI_PREFIX + ")(" + URI_SUFFIX + ")?");
    private static final Pattern OBJECT_ID_PATTERN = Pattern.compile("(" + PROJECT_FOLDER_URI_PREFIX + "|" + FORM_URI_PREFIX + "|" + SURVEY_RESPONSE_URI_PREFIX + ")(" + URI_SUFFIX + ")");
    private static final int PREFIX_GROUP = 1;
    private static final int OBJECT_ID_GROUP = 3;
    private UserRoleDao userRoleDao = new UserRoleDao();
    private UserAuthorizationDAO userAuthorizationDao = new UserAuthorizationDAO();
    private SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
    private SurveyDAO surveyDao = new SurveyDAO();
    private SurveyInstanceDAO surveyInstanceDao = new SurveyInstanceDAO();

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(FilterInvocation.class);
    }

    public int vote(Authentication authentication, FilterInvocation securedObject, Collection<ConfigAttribute> attributes) {
        if (this.abstainVote(authentication, securedObject)) {
            return 0;
        }
        if (authentication.getCredentials() == null) {
            throw new AccessDeniedException("Access is Denied. Unable to identify user");
        }
        String requestUri = securedObject.getRequestUrl();
        if (requestUri.startsWith(PROJECT_FOLDER_URI_PREFIX) || requestUri.startsWith(FORM_URI_PREFIX)) {
            return this.voteFolderSurveyUri(authentication, securedObject);
        }
        if (requestUri.startsWith(SURVEY_RESPONSE_URI_PREFIX)) {
            return this.voteSurveyResponseUri(authentication, securedObject);
        }
        return -1;
    }

    private boolean abstainVote(Authentication authentication, FilterInvocation securedObject) {
        if (!URI_PATTERN.matcher(securedObject.getRequestUrl()).find()) {
            return true;
        }
        if (authentication.getAuthorities().contains((Object)AppRole.SUPER_ADMIN)) {
            return true;
        }
        return "GET".equals(securedObject.getHttpRequest().getMethod()) && this.parseObjectId(securedObject.getRequestUrl()) == null;
    }

    private int voteFolderSurveyUri(Authentication authentication, FilterInvocation securedObject) {
        boolean includeSecuredObjectId;
        HttpServletRequest request = securedObject.getHttpRequest();
        String httpMethod = request.getMethod();
        String requestUri = securedObject.getRequestUrl();
        ArrayList<Long> ancestorIds = new ArrayList<Long>();
        Long objectId = null;
        if ("GET".equals(httpMethod) || "PUT".equals(httpMethod) || "DELETE".equals(httpMethod)) {
            objectId = this.parseObjectId(requestUri);
            ancestorIds.addAll(this.retrieveAncestorIdsFromDataStore(this.parseRequestPrefix(requestUri), objectId));
        } else if ("POST".equals(httpMethod)) {
            objectId = this.parsePayload(request);
            ancestorIds.addAll(this.retrieveAncestorIdsFromDataStore(PROJECT_FOLDER_URI_PREFIX, objectId));
        }
        boolean bl = includeSecuredObjectId = objectId != null;
        if (includeSecuredObjectId) {
            ancestorIds.add(objectId);
        }
        return this.checkUserAuthorization(authentication, securedObject, ancestorIds);
    }

    private Long parsePayload(HttpServletRequest httpRequest) {
        if (httpRequest.getContentType() == null || !httpRequest.getContentType().startsWith("application/json") || httpRequest.getContentLength() == 0) {
            return null;
        }
        boolean isValidPayload = false;
        String idString = null;
        try {
            JsonFactory f = new JsonFactory();
            JsonParser parser = f.createParser((InputStream)httpRequest.getInputStream());
            boolean isSurvey = false;
            boolean isForm = false;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String field = parser.getCurrentName();
                if (null == field) continue;
                if ("survey_group".equals(field)) {
                    isSurvey = true;
                    continue;
                }
                if ("survey".equals(field)) {
                    isForm = true;
                    continue;
                }
                if ("parentId".equals(field)) {
                    parser.nextToken();
                    idString = parser.getText();
                    isValidPayload = isSurvey && idString != null;
                    continue;
                }
                if (!"surveyGroupId".equals(field)) continue;
                parser.nextToken();
                idString = parser.getText();
                isValidPayload = isForm && idString != null;
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
        if (!isValidPayload) {
            return null;
        }
        Long objectId = null;
        try {
            objectId = Long.parseLong(idString);
        }
        catch (NumberFormatException e) {
            log.warning("Unable to identify the requested object id: " + idString);
        }
        return objectId;
    }

    private int checkUserAuthorization(Authentication authentication, FilterInvocation securedObject, List<Long> objectIds) {
        Long userId = (Long)authentication.getCredentials();
        if (objectIds == null || objectIds.isEmpty()) {
            throw new AccessDeniedException("Access is Denied. Unable to identify object(s)");
        }
        List<UserAuthorization> authorizations = this.userAuthorizationDao.listByObjectIds(userId, objectIds);
        if (authorizations.isEmpty()) {
            throw new AccessDeniedException("Access is Denied. Insufficient permissions");
        }
        ArrayList<Long> authorizedRoleIds = new ArrayList<Long>();
        for (UserAuthorization auth : authorizations) {
            authorizedRoleIds.add(auth.getRoleId());
        }
        List authorizedRoles = this.userRoleDao.listByKeys(authorizedRoleIds.toArray(new Long[0]));
        Permission permission = Permission.lookup(securedObject.getHttpRequest().getMethod(), securedObject.getRequestUrl());
        for (UserRole role : authorizedRoles) {
            if (!role.getPermissions().contains((Object)permission)) continue;
            return 1;
        }
        throw new AccessDeniedException("Access is Denied. Insufficient permissions");
    }

    private int voteSurveyResponseUri(Authentication authentication, FilterInvocation securedObject) {
        String httpMethod = securedObject.getHttpRequest().getMethod();
        String requestUri = securedObject.getRequestUrl();
        ArrayList<Long> ancestorIds = new ArrayList();
        if ("GET".equals(httpMethod) || "DELETE".equals(httpMethod)) {
            ancestorIds = this.retrieveAncestorIdsFromDataStore(this.parseRequestPrefix(requestUri), this.parseObjectId(requestUri));
        } else if ("POST".equals(httpMethod) || "PUT".equals(httpMethod)) {
            String message = "This operation is not supported operation at the moment.";
            log.warning("POST/PUT survey responses :" + message);
            throw new AccessDeniedException("Access is Denied. " + message);
        }
        return this.checkUserAuthorization(authentication, securedObject, ancestorIds);
    }

    private String parseRequestPrefix(String requestUri) {
        Matcher requestUriMatcher = URI_PATTERN.matcher(requestUri);
        if (requestUriMatcher.find()) {
            return requestUriMatcher.group(1);
        }
        return null;
    }

    private Long parseObjectId(String requestUri) {
        Matcher objectIdMatcher = OBJECT_ID_PATTERN.matcher(requestUri);
        if (objectIdMatcher.find()) {
            String objectIdStr = objectIdMatcher.group(3);
            return Long.parseLong(objectIdStr);
        }
        return null;
    }

    private List<Long> retrieveAncestorIdsFromDataStore(String requestPrefix, Long objectId) {
        if (requestPrefix == null || objectId == null) {
            log.warning("Failed to identify request parameters requestPrefix=" + requestPrefix + "; object=" + objectId);
            return Collections.emptyList();
        }
        ArrayList<Long> ancestorIds = new ArrayList<Long>();
        SecuredObject obj = null;
        if (Constants.ROOT_FOLDER_ID.equals(objectId)) {
            obj = new RootFolder();
        } else if (SURVEY_RESPONSE_URI_PREFIX.equals(requestPrefix)) {
            obj = (SecuredObject)this.surveyInstanceDao.getByKey(objectId);
        } else if (FORM_URI_PREFIX.equals(requestPrefix)) {
            obj = (SecuredObject)this.surveyDao.getByKey(objectId);
        } else if (PROJECT_FOLDER_URI_PREFIX.equals(requestPrefix)) {
            obj = (SecuredObject)this.surveyGroupDao.getByKey(objectId);
        }
        if (obj != null) {
            ancestorIds.addAll(obj.listAncestorIds());
        }
        return ancestorIds;
    }
}

