/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.utils.SystemProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.server.survey.SurveyServiceImpl;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.dao.DeviceApplicationDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.DeviceApplication;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

@Controller
@RequestMapping(value={"/actions"})
public class ActionRestService {
    private static final Logger logger = Logger.getLogger(ActionRestService.class.getName());
    private SurveyDAO surveyDao = new SurveyDAO();
    private SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
    private QuestionDao questionDao = new QuestionDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> doAction(@RequestParam(value="action", defaultValue="") String action, @RequestParam(value="surveyId", defaultValue="") Long surveyId, @RequestParam(value="cascadeResourceId", defaultValue="") Long cascadeResourceId, @RequestParam(value="surveyIds[]", defaultValue="") Long[] surveyIds, @RequestParam(value="email", defaultValue="") String email, @RequestParam(value="version", defaultValue="") String version, @RequestParam(value="dbInstructions", defaultValue="") String dbInstructions, @RequestParam(value="targetId", defaultValue="") Long targetId, @RequestParam(value="folderId", defaultValue="") Long folderId) {
        String status = "failed";
        String message = "";
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        if ("publishSurvey".equals(action) && surveyId != null) {
            status = this.publishSurvey(surveyId);
        } else if ("generateBootstrapFile".equals(action) && surveyIds != null && email != null) {
            message = this.generateBootstrapFile(surveyIds, dbInstructions, email);
            status = "ok";
            statusDto.setMessage(message);
        } else if ("removeZeroValues".equals(action)) {
            status = this.removeZeroMinMaxValues();
        } else if ("fixOptions2Values".equals(action)) {
            status = this.fixOptions2Values();
        } else if ("newApkVersion".equals(action)) {
            String path = this.newApkVersion(version);
            if (path.length() > 0) {
                status = "success";
                statusDto.setMessage("Created entry for " + path);
            }
        } else if ("populateGeocellsForLocale".equals(action)) {
            status = this.computeGeocellsForLocales();
        } else if ("createTestLocales".equals(action)) {
            status = this.createTestLocales();
        } else if ("publishCascade".equals(action)) {
            status = SurveyUtils.publishCascade(cascadeResourceId);
        } else if ("copyProject".equals(action)) {
            status = this.copyProject(targetId, folderId);
        }
        statusDto.setStatus(status);
        response.put("actions", "[]");
        response.put("meta", statusDto);
        return response;
    }

    private String createTestLocales() {
        SurveyInstanceDAO sDao = new SurveyInstanceDAO();
        Random generator = new Random();
        for (int i = 0; i < 1; ++i) {
            double latc = generator.nextDouble() * 120.0 - 60.0;
            double lonc = generator.nextDouble() * 360.0 - 180.0;
            for (int j = 0; j < 100; ++j) {
                SurveyInstance newSI = new SurveyInstance();
                newSI.setSurveyId(1L);
                newSI.setCollectionDate(new Date());
                newSI = sDao.save(newSI);
                QuestionAnswerStore newQAS = new QuestionAnswerStore();
                newQAS.setSurveyInstanceId(newSI.getKey().getId());
                newQAS.setType("GEO");
                newQAS.setCollectionDate(new Date());
                double lat = latc + generator.nextDouble() * 10.0 - 5.0;
                double lon = lonc + generator.nextDouble() * 10.0 - 5.0;
                String geoloc = lat + "|" + lon + "|" + 0 + "|aaaaaa";
                newQAS.setValue(geoloc);
                newQAS = sDao.save(newQAS);
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "ingestInstance").param("surveyInstanceId", newSI.getKey().getId() + ""));
            }
        }
        return "ok";
    }

    private String computeGeocellsForLocales() {
        Queue queue = QueueFactory.getDefaultQueue();
        queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "populateGeocellsForLocale").param("cursor", ""));
        return "Done";
    }

    private String removeZeroMinMaxValues() {
        List questions = this.questionDao.list("all");
        int counter = 0;
        if (questions != null) {
            Double epsilon = 1.0E-6;
            for (Question q : questions) {
                if (q.getMinVal() == null || q.getMaxVal() == null || !(Math.abs(q.getMinVal()) < epsilon) || !(Math.abs(q.getMaxVal()) < epsilon)) continue;
                q.setMinVal(null);
                q.setMaxVal(null);
                this.questionDao.save(q);
                ++counter;
            }
        }
        return "updated " + counter + " questions";
    }

    private String publishSurvey(Long surveyId) {
        SurveyServiceImpl surveyService = new SurveyServiceImpl();
        surveyService.publishSurveyAsync(surveyId);
        return "publishing requested";
    }

    private String fixOptions2Values() {
        Queue queue = QueueFactory.getDefaultQueue();
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "fixOptions2Values");
        queue.add(options);
        return "fixing opions to values in surveyInstances requested";
    }

    private String generateBootstrapFile(Long[] surveyIdList, String dbInstructions, String notificationEmail) {
        StringBuilder buf = new StringBuilder();
        if (surveyIdList != null && surveyIdList[0] != null) {
            for (int i = 0; i < surveyIdList.length; ++i) {
                if (i > 0) {
                    buf.append("||");
                }
                buf.append(String.valueOf(surveyIdList[i]));
            }
        }
        Queue queue = QueueFactory.getQueue((String)"background-processing");
        queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/bootstrapgen").param("action", "generate").param("surveyIds", buf.toString()).param("email", notificationEmail).param("dbInstructions", dbInstructions != null ? dbInstructions : ""));
        return "_request_submitted_email_will_be_sent";
    }

    private String newApkVersion(String version) {
        Properties props = System.getProperties();
        String apkS3Path = props.getProperty("apkS3Path");
        apkS3Path = apkS3Path + SystemProperty.applicationId.get() + "/";
        if (version != null && version.length() > 0 && apkS3Path != null && apkS3Path.length() > 0) {
            DeviceApplicationDao daDao = new DeviceApplicationDao();
            DeviceApplication da = new DeviceApplication();
            da.setAppCode("fieldSurvey");
            da.setDeviceType("androidPhone");
            da.setVersion(version);
            da.setFileName(apkS3Path + "fieldsurvey-" + version + ".apk");
            daDao.save(da);
            return da.getFileName();
        }
        return "";
    }

    private String copyProject(Long targetId, Long folderId) {
        boolean isCopiedToDifferentFolder;
        SurveyGroup projectSource = (SurveyGroup)this.surveyGroupDao.getByKey(targetId);
        SurveyGroup projectParent = null;
        if (folderId != null) {
            projectParent = (SurveyGroup)this.surveyGroupDao.getByKey(folderId);
        }
        if (projectSource == null) {
            logger.log(Level.WARNING, String.format("Failed to copy project %s to folder %s", targetId, folderId));
            return "failed";
        }
        SurveyGroup projectCopy = new SurveyGroup();
        BeanUtils.copyProperties((Object)projectSource, (Object)projectCopy, (String[])Constants.EXCLUDED_PROPERTIES);
        projectCopy.setCode(projectSource.getCode() + " copy");
        projectCopy.setName(projectSource.getName() + " copy");
        String parentPath = null;
        parentPath = projectParent != null ? projectParent.getPath() : "";
        projectCopy.setPath(parentPath + "/" + projectCopy.getName());
        projectCopy.setParentId(folderId);
        boolean bl = isCopiedToDifferentFolder = projectSource.getParentId() != null && folderId != null && !projectSource.getParentId().equals(folderId);
        if (isCopiedToDifferentFolder) {
            projectCopy.setAncestorIds(SurveyUtils.retrieveAncestorIds(projectCopy));
        }
        projectCopy.setPublished(false);
        SurveyGroup savedProjectCopy = this.surveyGroupDao.save(projectCopy);
        List<Survey> sourceSurveys = this.surveyDao.listSurveysByGroup(targetId);
        ArrayList<Long> surveysAncestorIds = new ArrayList<Long>(savedProjectCopy.getAncestorIds());
        surveysAncestorIds.add(savedProjectCopy.getKey().getId());
        for (Survey sourceSurvey : sourceSurveys) {
            SurveyDto surveyDto = new SurveyDto();
            surveyDto.setCode(sourceSurvey.getCode());
            surveyDto.setName(sourceSurvey.getName());
            surveyDto.setPath(projectCopy.getPath() + "/" + sourceSurvey.getName());
            surveyDto.setSurveyGroupId(savedProjectCopy.getKey().getId());
            Survey surveyCopy = SurveyUtils.copySurvey(sourceSurvey, surveyDto);
            surveyCopy.setAncestorIds(surveysAncestorIds);
            surveyCopy.setSurveyGroupId(savedProjectCopy.getKey().getId());
            long copyId = this.surveyDao.save(surveyCopy).getKey().getId();
            if (!ActionRestService.isRegistrationFormId(sourceSurvey.getKey().getId(), projectSource.getNewLocaleSurveyId())) continue;
            savedProjectCopy.setNewLocaleSurveyId(copyId);
            this.surveyGroupDao.save(savedProjectCopy);
        }
        return "success";
    }

    private static boolean isRegistrationFormId(Long sourceFormId, Long sourceProjectRegistrationFormId) {
        return sourceFormId != null && sourceProjectRegistrationFormId != null && sourceFormId.equals(sourceProjectRegistrationFormId);
    }
}

