/*
 * Decompiled with CFR 0.152.
 */
package test.java.org.akvo.flow.util;

import com.gallatinsystems.survey.domain.Question;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FlowJsonObjectWriterTests {
    FlowJsonObjectWriterTests() {
    }

    @Test
    void testComplexJsonObject() {
        LinkedHashMap<String, Cloneable> complexJsonObject = new LinkedHashMap<String, Cloneable>();
        complexJsonObject.put("nullList", null);
        complexJsonObject.put("emptyList", new ArrayList());
        ArrayList<Integer> listOfNumbers = new ArrayList<Integer>();
        listOfNumbers.add(1);
        listOfNumbers.add(2);
        listOfNumbers.add(3);
        complexJsonObject.put("listOfNumbers", listOfNumbers);
        ArrayList<Integer> firstList = new ArrayList<Integer>();
        firstList.add(5345);
        firstList.add(6587);
        firstList.add(9987);
        ArrayList<String> secondList = new ArrayList<String>();
        secondList.add("tea");
        secondList.add("coffee");
        LinkedHashMap<String, ArrayList<Object>> mapOfLists = new LinkedHashMap<String, ArrayList<Object>>();
        mapOfLists.put("firstList", firstList);
        mapOfLists.put("secondList", secondList);
        complexJsonObject.put("mapOfLists", mapOfLists);
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
        String jsonString = null;
        try {
            jsonString = writer.writeAsString(complexJsonObject);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String jsonStringExpected = "{\"nullList\":null,\"emptyList\":[],\"listOfNumbers\":[1,2,3],\"mapOfLists\":{\"firstList\":[5345,6587,9987],\"secondList\":[\"tea\",\"coffee\"]}}";
        Assertions.assertEquals((Object)jsonStringExpected, (Object)jsonString);
    }

    @Test
    void testWriteSimpleJsonObjectWithExcludeNonNull() {
        Question question = new Question();
        question.setText("First Question");
        question.setOrder(0);
        question.setType(Question.Type.FREE_TEXT);
        question.setAllowOtherFlag(true);
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter().withExcludeNullValues();
        String jsonString = null;
        try {
            jsonString = writer.writeAsString(question);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String jsonStringExpected = "{\"type\":\"FREE_TEXT\",\"text\":\"First Question\",\"allowOtherFlag\":true,\"collapseable\":false,\"immutable\":false,\"order\":0}";
        Assertions.assertEquals((Object)jsonStringExpected, (Object)jsonString);
    }
}

