/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Translation;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class QuestionOptionDao
extends BaseDAO<QuestionOption> {
    private TranslationDao translationDao = new TranslationDao();

    public QuestionOptionDao() {
        super(QuestionOption.class);
    }

    public TreeMap<Integer, QuestionOption> listOptionByQuestion(Long questionId) {
        List oList = this.listByProperty("questionId", (Object)questionId, "Long", "order", "asc");
        TreeMap<Integer, QuestionOption> map = new TreeMap<Integer, QuestionOption>();
        if (oList != null) {
            int i = 1;
            for (QuestionOption o : oList) {
                o.setTranslationMap(this.translationDao.findTranslations(Translation.ParentType.QUESTION_OPTION, o.getKey().getId()));
                map.put(o.getOrder() != null ? o.getOrder() : ++i, o);
            }
        }
        return map;
    }

    public List<QuestionOption> listByQuestionId(Long questionId) {
        return this.listByProperty("questionId", (Object)questionId, "Long", "order", "asc");
    }

    public List<QuestionOption> listByQuestionId(List<Long> questionIds) {
        if (questionIds == null || questionIds.isEmpty()) {
            return Collections.emptyList();
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = ":p1.contains(questionId)";
        Query query = pm.newQuery(QuestionOption.class, queryString);
        List results = (List)query.execute(questionIds);
        return results;
    }

    public void deleteOptionsForQuestion(Long questionId) {
        List oList = this.listByProperty("questionId", questionId, "Long");
        if (oList != null) {
            TranslationDao tDao = new TranslationDao();
            for (QuestionOption opt : oList) {
                tDao.deleteTranslationsForParent(opt.getKey().getId(), Translation.ParentType.QUESTION_OPTION);
            }
            super.delete(oList);
        }
    }
}

