/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.web.dto.DeviceApplicationRestRequest;
import org.waterforpeople.mapping.app.web.dto.DeviceApplicationRestResponse;
import org.waterforpeople.mapping.dao.DeviceApplicationDao;
import org.waterforpeople.mapping.domain.DeviceApplication;

public class DeviceApplicationRestService
extends AbstractRestApiServlet {
    private static final long serialVersionUID = -830140106880504436L;
    private static final int MINIMUM_SUPPORTED_ANDROID_VERSION = 15;
    private DeviceApplicationDao devAppDao;

    public DeviceApplicationRestService() {
        this.setMode("JSON");
        this.devAppDao = new DeviceApplicationDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DeviceApplicationRestRequest restRequest = new DeviceApplicationRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DeviceApplicationRestResponse resp = new DeviceApplicationRestResponse();
        Properties props = System.getProperties();
        String autoUpdateApk = props.getProperty("autoUpdateApk");
        if ("getLatestVersion".equalsIgnoreCase(req.getAction()) && autoUpdateApk != null && autoUpdateApk.equalsIgnoreCase("true")) {
            DeviceApplicationRestRequest daReq = (DeviceApplicationRestRequest)req;
            String androidBuildVersion = daReq.getAndroidBuildVersion();
            if (androidBuildVersion == null || this.parseBuildVersion(androidBuildVersion) < 15) {
                DeviceApplication devApp = this.devAppDao.listAppVersionForUnsupportedDevices(daReq.getDeviceType(), daReq.getAppCode());
                if (devApp != null) {
                    resp.setVersion(devApp.getVersion());
                    resp.setFileName(devApp.getFileName());
                    resp.setMd5Checksum(devApp.getMd5Checksum());
                }
            } else {
                List<DeviceApplication> devAppList = this.devAppDao.listByDeviceTypeAndAppCode(daReq.getDeviceType(), daReq.getAppCode(), 1);
                if (devAppList != null && devAppList.size() > 0) {
                    DeviceApplication deviceApplication = devAppList.get(0);
                    resp.setVersion(deviceApplication.getVersion());
                    resp.setFileName(deviceApplication.getFileName());
                    resp.setMd5Checksum(deviceApplication.getMd5Checksum());
                }
            }
        }
        return resp;
    }

    private int parseBuildVersion(String androidBuildVersion) {
        try {
            return Integer.parseInt(androidBuildVersion);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        this.getResponse().getWriter().println(new JSONObject((Object)resp).toString());
    }
}

