/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.domain;

public class GeoCoordinates {
    private Double latitude;
    private Double longitude;
    private Double altitude;
    private String code;

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static GeoCoordinates extractGeoCoordinate(String line) {
        GeoCoordinates gc = null;
        if (line != null && line.trim().length() > 0 && !line.trim().equals("||") && !line.startsWith("||")) {
            gc = new GeoCoordinates();
            String[] coordinates = line.split("\\|", -1);
            if (coordinates.length > 1) {
                try {
                    gc.setLatitude(Double.parseDouble(coordinates[0]));
                    gc.setLongitude(Double.parseDouble(coordinates[1]));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            } else {
                return null;
            }
            if (coordinates.length > 2 && coordinates[2] != null && coordinates[2].trim().length() > 0) {
                try {
                    gc.setAltitude(Double.parseDouble(coordinates[2]));
                }
                catch (NumberFormatException nfe) {
                    gc.setAltitude(null);
                }
            }
            if (coordinates.length > 3) {
                gc.setCode(coordinates[3]);
            }
        }
        return gc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GeoCoordinates:");
        sb.append("\n--Latitude: " + this.latitude);
        sb.append("\n--Longitude: " + this.longitude);
        sb.append("\n--Altitude: " + this.altitude);
        return sb.toString();
    }
}

