/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.dao.UserRoleDao;
import com.gallatinsystems.user.domain.Permission;
import com.gallatinsystems.user.domain.User;
import com.gallatinsystems.user.domain.UserAuthorization;
import com.gallatinsystems.user.domain.UserRole;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.security.core.context.SecurityContextHolder;
import org.waterforpeople.mapping.app.web.rest.security.user.GaeUser;

public class CurrentUserServlet
extends HttpServlet {
    private UserRoleDao userRoleDAO = new UserRoleDao();
    private UserAuthorizationDAO userAuthorizationDAO = new UserAuthorizationDAO();
    private static final long serialVersionUID = -430515593814261770L;
    private static final Logger log = Logger.getLogger(CurrentUserServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (CurrentUserServlet.getCurrentUser() == null) {
            return;
        }
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
        try {
            engine.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not initialize velocity", e);
        }
        Template t = null;
        try {
            t = engine.getTemplate("CurrentUser.vm");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not get the template `CurrentUser`", e);
            return;
        }
        VelocityContext context = new VelocityContext();
        User currentUser = CurrentUserServlet.getCurrentUser();
        context.put("user", (Object)currentUser);
        context.put("permissions", (Object)this.getPermissionsMap(currentUser));
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        resp.setContentType("application/javascript;charset=UTF-8");
        PrintWriter pw = resp.getWriter();
        pw.println(writer.toString());
        pw.close();
    }

    public static User getCurrentUser() {
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null) {
            return null;
        }
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof GaeUser) {
            GaeUser user = (GaeUser)principal;
            if (user.getEmail() == null) {
                return null;
            }
            String currentUserEmail = user.getEmail().toLowerCase();
            UserDao uDao = new UserDao();
            return uDao.findUserByEmail(currentUserEmail);
        }
        return null;
    }

    public static Long getCurrentUserId() {
        User u = CurrentUserServlet.getCurrentUser();
        if (u == null || u.getKey() == null) {
            return null;
        }
        return u.getKey().getId();
    }

    private String getPermissionsMap(User currentUser) {
        List<UserAuthorization> authorizationList = this.userAuthorizationDAO.listByUser(currentUser.getKey().getId());
        HashMap<Long, Object> roleMap = new HashMap<Long, Object>();
        for (Object role : this.userRoleDAO.list("all")) {
            roleMap.put(((BaseDomain)role).getKey().getId(), role);
        }
        HashMap<Long, Set<Permission>> permissions = new HashMap<Long, Set<Permission>>();
        for (UserAuthorization auth : authorizationList) {
            UserRole role = (UserRole)roleMap.get(auth.getRoleId());
            if (role == null || auth.getSecuredObjectId() == null) continue;
            if (permissions.containsKey(auth.getSecuredObjectId())) {
                ((Set)permissions.get(auth.getSecuredObjectId())).addAll(role.getPermissions());
                continue;
            }
            permissions.put(auth.getSecuredObjectId(), role.getPermissions());
        }
        this.addSuperAdminPermissions(currentUser, permissions);
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
        String permissionsString = null;
        try {
            permissionsString = writer.writeAsString(permissions);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return permissionsString;
    }

    private void addSuperAdminPermissions(User currentUser, Map<Long, Set<Permission>> permissions) {
        if (!currentUser.getPermissionList().equals("0")) {
            return;
        }
        List<Permission> permissionList = Arrays.asList(Permission.values());
        permissions.put(Constants.ROOT_FOLDER_ID, new HashSet<Permission>(permissionList));
    }
}

