/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest.security;

import com.google.appengine.api.users.UserServiceFactory;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Controller;
import org.waterforpeople.mapping.app.web.rest.security.oidc.AppConfig;
import org.waterforpeople.mapping.app.web.rest.security.user.GaeUser;

@Controller
public class LogoutController
implements LogoutSuccessHandler {
    private AppConfig appConfig;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public LogoutController(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public void onLogoutSuccess(HttpServletRequest req, HttpServletResponse res, Authentication authentication) throws IOException {
        this.logger.fine("Performing logout");
        this.invalidateSession(req);
        if (authentication != null && authentication.getPrincipal() != null && authentication.getPrincipal() instanceof GaeUser) {
            GaeUser principal = (GaeUser)authentication.getPrincipal();
            if (!principal.isAuthByGAE()) {
                this.logoutFromOIDC(req, res);
            } else {
                this.logoutFromGAE(res);
            }
        }
    }

    private void logoutFromGAE(HttpServletResponse res) throws IOException {
        res.sendRedirect(UserServiceFactory.getUserService().createLogoutURL("/"));
    }

    private void logoutFromOIDC(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String returnTo = req.getScheme() + "://" + req.getServerName();
        if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
            returnTo = returnTo + ":" + req.getServerPort();
        }
        returnTo = returnTo + "/";
        String logoutUrl = String.format("https://%s/v2/logout?client_id=%s&returnTo=%s", this.appConfig.getDomain(), this.appConfig.getClientId(), returnTo);
        res.sendRedirect(logoutUrl);
    }

    private void invalidateSession(HttpServletRequest request) {
        SecurityContextHolder.clearContext();
        request.getSession().invalidate();
    }
}

