/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest.security.oidc;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class TokenAuthentication
extends AbstractAuthenticationToken {
    private final DecodedJWT jwt;
    private boolean invalidated;

    public TokenAuthentication(DecodedJWT jwt) {
        super(TokenAuthentication.readAuthorities(jwt));
        this.jwt = jwt;
    }

    private boolean hasExpired() {
        return this.jwt.getExpiresAt().before(new Date());
    }

    private static Collection<? extends GrantedAuthority> readAuthorities(DecodedJWT jwt) {
        String[] scopes;
        Claim rolesClaim = jwt.getClaim("https://access.control/roles");
        if (rolesClaim.isNull()) {
            return Collections.emptyList();
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String s : scopes = (String[])rolesClaim.asArray(String.class)) {
            SimpleGrantedAuthority a = new SimpleGrantedAuthority(s);
            if (authorities.contains(a)) continue;
            authorities.add(a);
        }
        return authorities;
    }

    public String getCredentials() {
        return this.jwt.getToken();
    }

    public Object getPrincipal() {
        return this.jwt.getSubject();
    }

    public void setAuthenticated(boolean authenticated) {
        if (authenticated) {
            throw new IllegalArgumentException("Create a new Authentication object to authenticate");
        }
        this.invalidated = true;
    }

    public boolean isAuthenticated() {
        return !this.invalidated && !this.hasExpired();
    }

    public Map<String, Claim> getClaims() {
        return this.jwt.getClaims();
    }
}

