/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.security;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.rest.security.ApiUserAuthentication;
import org.akvo.flow.rest.security.user.ApiUser;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class ApiAuthenticationFilter
extends GenericFilterBean {
    private AuthenticationManager authenticationManager;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("HTTP-Verb", httpRequest.getMethod());
        details.put("Date", httpRequest.getHeader("Date"));
        details.put("Authorization", httpRequest.getHeader("Authorization"));
        details.put("Resource", httpRequest.getRequestURI());
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new ApiUserAuthentication(new ApiUser(), details));
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        chain.doFilter(request, response);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

