/*
 * Decompiled with CFR 0.152.
 */
package test.java.org.akvo.flow.rest.security.google;

import com.google.appengine.api.users.User;
import org.akvo.flow.rest.security.GaeUserAuthentication;
import org.akvo.flow.rest.security.google.GoogleAuthenticationFilter;
import org.akvo.flow.rest.security.user.GaeUser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.security.core.Authentication;

class GoogleAuthenticationFilterTest {
    private static final User ANY_GOOGLE_USER = GoogleAuthenticationFilterTest.googleUser("any@foo.bar");

    GoogleAuthenticationFilterTest() {
    }

    @Test
    void notLoggedIn() {
        Authentication notLoggedIn = null;
        this.assertDoNotClearContext(notLoggedIn, ANY_GOOGLE_USER);
    }

    @Test
    void loggedInWithAuth0() {
        this.assertDoNotClearContext(this.auth0User(), ANY_GOOGLE_USER);
    }

    @Test
    void userLoggedOutFromGoogleButNotFromFlow() {
        User notLoggedInGoogle = null;
        this.assertClearSecurityContext(this.gaeUser("any@akvo.org"), notLoggedInGoogle);
    }

    @Test
    void userLoggedInGoogleWithADifferentUserThanFlow() {
        this.assertClearSecurityContext(this.gaeUser("this.one@akvo.org"), GoogleAuthenticationFilterTest.googleUser("this.other.one@akvo.org"));
    }

    @Test
    void userLoggedInGoogleWithSameUserAsFlow() {
        String sameEmail = "same@akvo.org";
        this.assertDoNotClearContext(this.gaeUser(sameEmail), GoogleAuthenticationFilterTest.googleUser(sameEmail));
    }

    private static User googleUser(String email) {
        return new User(email, "any");
    }

    private void assertClearSecurityContext(Authentication authentication, User googleUser) {
        Assertions.assertTrue((boolean)GoogleAuthenticationFilter.shouldClearSession(authentication, googleUser));
    }

    private Authentication auth0User() {
        return new GaeUserAuthentication(new GaeUser(false, "any", "any"), null);
    }

    private Authentication gaeUser(String email) {
        return new GaeUserAuthentication(new GaeUser(true, "any", email), null);
    }

    private void assertDoNotClearContext(Authentication notLoggedIn, User anyGoogleUser) {
        Assertions.assertFalse((boolean)GoogleAuthenticationFilter.shouldClearSession(notLoggedIn, anyGoogleUser));
    }
}

